/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem;

import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.rm.core.AbstractToolsAttributes;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolResourceManager;
import org.eclipse.ptp.rm.mpi.openmpi.core.parameters.OmpiInfo;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystem;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;

public class OpenMPIResourceManager
extends AbstractToolResourceManager {
    private Integer OPENMPI_RMID;
    private OpenMPIRuntimeSystem rts = null;

    public OpenMPIResourceManager(Integer id, IPUniverseControl universe, IResourceManagerConfiguration config) {
        super(id.toString(), universe, config);
        this.OPENMPI_RMID = id;
    }

    protected IRuntimeSystem doCreateRuntimeSystem() {
        IOpenMPIResourceManagerConfiguration config = (IOpenMPIResourceManagerConfiguration)this.getConfiguration();
        AttributeDefinitionManager attrDefMgr = this.getAttributeDefinitionManager();
        attrDefMgr.setAttributeDefinitions(AbstractToolsAttributes.getDefaultAttributeDefinitions());
        this.rts = new OpenMPIRuntimeSystem(this.OPENMPI_RMID, config, attrDefMgr);
        return this.rts;
    }

    public OmpiInfo getOmpiInfo() {
        if (this.rts == null) {
            return null;
        }
        try {
            return this.rts.getOmpiInfo().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

