/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.jproxy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.messages.Messages;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.proxy.runtime.event.ProxyRuntimeEventFactory;
import org.eclipse.ptp.proxy.runtime.server.AbstractProxyRuntimeServer;
import org.eclipse.ptp.proxy.runtime.server.ElementIDGenerator;
import org.eclipse.ptp.proxy.server.AbstractProxyServer;
import org.eclipse.ptp.rm.pbs.jproxy.attributes.PBSJobClientAttributes;
import org.eclipse.ptp.rm.pbs.jproxy.attributes.PBSNodeClientAttributes;
import org.eclipse.ptp.rm.pbs.jproxy.attributes.PBSQueueClientAttributes;
import org.eclipse.ptp.rm.pbs.jproxy.parser.QstatJobXMLReader;
import org.eclipse.ptp.rm.pbs.jproxy.parser.QstatQueuesReader;
import org.eclipse.ptp.rm.proxy.core.Controller;
import org.eclipse.ptp.rm.proxy.core.attributes.AttributeDefinition;
import org.eclipse.ptp.rm.proxy.core.attributes.IElementAttributes;
import org.eclipse.ptp.rm.proxy.core.element.IElement;
import org.eclipse.ptp.rm.proxy.core.event.IEventFactory;
import org.eclipse.ptp.rm.proxy.core.event.JobEventFactory;
import org.eclipse.ptp.rm.proxy.core.event.NodeEventFactory;
import org.eclipse.ptp.rm.proxy.core.event.QueueEventFactory;
import org.eclipse.ptp.rm.proxy.core.parser.IParser;
import org.eclipse.ptp.rm.proxy.core.parser.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSProxyRuntimeServer
extends AbstractProxyRuntimeServer {
    private static final boolean debugReadFromFiles = false;
    private static final String debugFolder = "helics";
    private static final String debugUser = "xli";
    private Controller nodeController;
    private Controller queueController;
    private Controller jobController;
    String user = null;

    public static void main(String[] args) {
        Map<String, Object> params = PBSProxyRuntimeServer.parseArguments(args);
        String host = (String)params.get("host");
        if (host == null) {
            System.err.println("host argument missing");
            return;
        }
        int port = 0;
        Integer portVal = (Integer)params.get("port");
        if (portVal == null) {
            System.err.println("port argument missing");
            return;
        }
        port = portVal;
        PBSProxyRuntimeServer server = new PBSProxyRuntimeServer(host, port);
        try {
            server.connect();
            System.out.println(String.valueOf(PBSProxyRuntimeServer.class.getSimpleName()) + " started");
            server.start();
        }
        catch (IOException e) {
            System.err.println("Failed to start: " + e.getMessage());
            return;
        }
    }

    protected static Map<String, Object> parseArguments(String[] args) {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        int i = 0;
        while (i < args.length) {
            String host;
            if (args[i].startsWith("--port")) {
                try {
                    int port = new Integer(args[i].substring(7));
                    argsMap.put("port", port);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(Messages.AbstractProxyRuntimeServer_0) + args[i + 1].substring(7));
                }
            } else if (args[i].startsWith("--host") && (host = args[i].substring(7)) != null) {
                argsMap.put("host", host);
            }
            ++i;
        }
        return argsMap;
    }

    private static String normalize(String content) {
        content = content.replaceAll("\\\\\\\\", "\\");
        content = content.replaceAll("\\\\n", "\n");
        content = content.replaceAll("\\\\t", "\t");
        content = content.replaceAll("\\\\s", " ");
        return content;
    }

    private PBSProxyRuntimeServer(String host, int port) {
        super(host, port, (IProxyRuntimeEventFactory)new ProxyRuntimeEventFactory());
    }

    private String getUser() {
        if (this.user == null) {
            try {
                Process p = Runtime.getRuntime().exec("whoami");
                p.waitFor();
                this.user = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.user;
    }

    protected void startEventThread(final int transID) {
        int dummyMachineID = ElementIDGenerator.getInstance().getUniqueID();
        System.out.println(Messages.getString((String)"PBSProxyRuntimeServer.2"));
        int resourceManagerID = ElementIDGenerator.getInstance().getBaseID();
        try {
            this.sendEvent((IProxyEvent)this.getEventFactory().newProxyRuntimeNewMachineEvent(transID, new String[]{Integer.toString(resourceManagerID), "1", Integer.toString(dummyMachineID), "2", "machineState=UP", "name=PBSdummy"}));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.nodeController = new Controller("pbsnodes -x", new AttributeDefinition((IElementAttributes)new PBSNodeClientAttributes()), (IEventFactory)new NodeEventFactory(), (IParser)new XMLReader(), dummyMachineID);
        this.queueController = new Controller("qstat -Q -f -1", new AttributeDefinition((IElementAttributes)new PBSQueueClientAttributes()), (IEventFactory)new QueueEventFactory(), (IParser)new QstatQueuesReader(), resourceManagerID);
        this.jobController = new Controller("qstat -x", new AttributeDefinition((IElementAttributes)new PBSJobClientAttributes()), (IEventFactory)new JobEventFactory(), (IParser)new QstatJobXMLReader(), this.queueController);
        this.jobController.setFilter("job_owner", String.valueOf(Pattern.quote(this.getUser())) + "@.*");
        if (this.eventThread == null) {
            this.eventThread = new Thread(){

                public void run() {
                    while (PBSProxyRuntimeServer.this.state != AbstractProxyServer.ServerState.SHUTDOWN) {
                        ArrayList events = new ArrayList();
                        events.addAll(PBSProxyRuntimeServer.this.nodeController.update());
                        events.addAll(PBSProxyRuntimeServer.this.queueController.update());
                        events.addAll(PBSProxyRuntimeServer.this.jobController.update());
                        try {
                            for (IProxyEvent e : events) {
                                e.setTransactionID(transID);
                                PBSProxyRuntimeServer.this.sendEvent(e);
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    System.err.println(Messages.getString((String)"PBSProxyRuntimeServer.0"));
                }
            };
            this.eventThread.start();
        }
    }

    protected void submitJob(int transID, String[] arguments) {
        File tmp;
        block16: {
            String jobSubId = null;
            String script = null;
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                String[] keyValue = argument.split("=", 2);
                String key = keyValue[0];
                String value = keyValue[1];
                if (key.equals("jobSubId")) {
                    jobSubId = value;
                } else if (key.equals("script")) {
                    script = PBSProxyRuntimeServer.normalize(value);
                }
                ++n2;
            }
            if (jobSubId == null || script == null) {
                System.err.println("missing arguments!");
                return;
            }
            tmp = null;
            try {
                tmp = File.createTempFile("job", "qsub");
                BufferedWriter out = new BufferedWriter(new FileWriter(tmp));
                out.write(script);
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            String[] args = new String[]{"qsub", tmp.getAbsolutePath()};
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(args);
                p.waitFor();
                try {
                    String line;
                    if (p.exitValue() == 0) {
                        this.sendEvent((IProxyEvent)this.getEventFactory().newOKEvent(transID));
                        break block16;
                    }
                    BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    String errMsg = "";
                    while ((line = err.readLine()) != null) {
                        errMsg = String.valueOf(errMsg) + line;
                    }
                    String[] errArgs = new String[]{"jobSubId=" + jobSubId, "errorCode=0", "errorMsg=" + errMsg};
                    this.sendEvent((IProxyEvent)this.getEventFactory().newProxyRuntimeSubmitJobErrorEvent(transID, errArgs));
                    System.out.println("submitJob: err: " + errMsg);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (IOException e) {
                String[] errArgs = new String[]{"jobSubId=" + jobSubId, "errorCode=0", "errorMsg=" + e.getMessage()};
                try {
                    System.out.println("SubmitJobError: " + e.getMessage());
                    this.sendEvent((IProxyEvent)this.getEventFactory().newProxyRuntimeSubmitJobErrorEvent(transID, errArgs));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        tmp.delete();
    }

    protected void terminateJob(int transID, String[] arguments) {
        int id = Integer.parseInt(arguments[0].split("=")[1]);
        IElement job = this.jobController.currentElements.getElementByElementID(id);
        System.out.println(String.valueOf(Messages.getString((String)"PBSProxyRuntimeServer.25")) + id + "," + job.getKey());
        String[] args = new String[]{"qdel", job.getKey()};
        try {
            Process p = Runtime.getRuntime().exec(args);
            p.waitFor();
            if (p.exitValue() == 0) {
                this.sendEvent((IProxyEvent)this.getEventFactory().newOKEvent(transID));
            } else {
                String line;
                BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String errMsg = "";
                while ((line = err.readLine()) != null) {
                    errMsg = String.valueOf(errMsg) + line;
                }
                String[] errArgs = new String[]{"errorCode=" + p.exitValue(), "errorMsg=" + errMsg};
                this.sendEvent((IProxyEvent)this.getEventFactory().newErrorEvent(transID, errArgs));
            }
            System.out.println(p.exitValue());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

