/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.pbs.ui.PBSUIPlugin;
import org.eclipse.ptp.rm.pbs.ui.data.PBSBatchScriptTemplate;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.utils.ConfigUtils;
import org.osgi.framework.Bundle;

public class PBSBatchScriptTemplateManager {
    private static final String DEFAULT_TEMPLATE = Messages.PBSBatchScriptTemplateManager_defaultTemplate;
    private static final String FULL_TEMPLATE = Messages.PBSBatchScriptTemplateManager_fullTemplate;
    private static final String RESOURCE_PATH = String.valueOf(Messages.PBSBatchScriptTemplateManager_resourcePath) + System.getProperty("file.separator");
    private static final String SUFFIX = Messages.PBSBatchScriptTemplateManager_templateSuffix;
    private PBSBatchScriptTemplate current;

    public PBSBatchScriptTemplateManager() throws Throwable {
        this.initializeStore();
    }

    public String[] findAvailableTemplates() {
        ArrayList<String> templateNames = new ArrayList<String>();
        try {
            File attrconf = PBSUIPlugin.getDefault().getStateLocation().toFile();
            ConfigUtils.SuffixFilter filter = new ConfigUtils.SuffixFilter(SUFFIX);
            File[] properties = attrconf.listFiles(filter);
            int i = 0;
            while (i < properties.length) {
                templateNames.add(properties[i].getName());
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return templateNames.toArray(new String[0]);
    }

    public PBSBatchScriptTemplate getCurrent() {
        return this.current;
    }

    public PBSBatchScriptTemplate loadTemplate(String choice, ILaunchConfiguration config) {
        this.current = new PBSBatchScriptTemplate();
        if (choice == null || "".equals(choice)) {
            return this.current;
        }
        try {
            File f = new File(PBSUIPlugin.getDefault().getStateLocation().toFile(), choice);
            if (!f.exists()) {
                return this.current;
            }
            this.current.setConfiguration(config);
            this.current.load(new FileInputStream(f));
            this.current.setName(choice);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.current;
    }

    public void removeTemplate(String name) throws IllegalAccessError {
        if (DEFAULT_TEMPLATE.equals(name) || FULL_TEMPLATE.equals(name)) {
            throw new IllegalAccessError(String.valueOf(name) + Messages.PBSAttributeTemplateManager_removeError);
        }
        File configFile = new File(PBSUIPlugin.getDefault().getStateLocation().toFile(), name);
        if (configFile.exists()) {
            configFile.delete();
        }
    }

    public void storeTemplate(String editedContent, String fileName) throws IOException, NoSuchElementException, IllegalAccessError {
        OutputStreamWriter fw = null;
        try {
            File configFile = new File(PBSUIPlugin.getDefault().getStateLocation().toFile(), fileName);
            if (configFile.exists()) {
                configFile.delete();
            }
            fw = new FileWriter(configFile, false);
            fw.write(editedContent);
            fw.flush();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public String validateTemplateNameForEdit(String fileName) throws IllegalArgumentException, IllegalAccessError {
        if (fileName.length() == 0) {
            throw new IllegalArgumentException(Messages.PBSRMLaunchConfigEditChoose_illegalArgument);
        }
        if (!fileName.endsWith(Messages.PBSBatchScriptTemplateManager_templateSuffix)) {
            fileName = String.valueOf(fileName) + Messages.PBSBatchScriptTemplateManager_templateSuffix;
        }
        if (DEFAULT_TEMPLATE.equals(fileName) || FULL_TEMPLATE.equals(fileName)) {
            throw new IllegalAccessError(String.valueOf(fileName) + Messages.PBSAttributeTemplateManager_storeError);
        }
        return fileName;
    }

    private PBSBatchScriptTemplate getResourceTemplate(String name) throws Throwable {
        PBSBatchScriptTemplate template;
        block12: {
            Bundle bundle = PBSUIPlugin.getDefault().getBundle();
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(RESOURCE_PATH) + name), null);
            if (url == null) {
                return null;
            }
            InputStream s = null;
            template = null;
            try {
                try {
                    s = url.openStream();
                    template = new PBSBatchScriptTemplate();
                    template.load(s);
                    template.setName(name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return template;
    }

    private void initializeStore() throws Throwable {
        File attrconf = PBSUIPlugin.getDefault().getStateLocation().toFile();
        if (!attrconf.exists()) {
            attrconf.mkdirs();
        }
        String[] found = this.findAvailableTemplates();
        HashSet<String> readOnly = new HashSet<String>();
        readOnly.add(DEFAULT_TEMPLATE);
        readOnly.add(FULL_TEMPLATE);
        int i = 0;
        while (i < found.length) {
            if (DEFAULT_TEMPLATE.equals(found[i]) || FULL_TEMPLATE.equals(found[i])) {
                readOnly.remove(found[i]);
                if (readOnly.isEmpty()) {
                    return;
                }
            }
            ++i;
        }
        for (String name : readOnly) {
            PBSBatchScriptTemplate template = this.getResourceTemplate(name);
            if (template == null) continue;
            this.storeTemplate(template.getText(), name);
        }
    }
}

