/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.ll.ui.rmLaunchConfiguration;

import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.ibm.ll.ui.messages.Messages;
import org.eclipse.ptp.rm.ibm.ll.ui.rmLaunchConfiguration.ValidationState;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectorRowWidget
implements ValidationState {
    private Label label;
    private Label nonDefaultMarker;
    private GridData gridData;
    private IAttributeDefinition<?, ?, ?> attr;
    private FileSelector widget;
    private String defaultValue;
    private EventMonitor eventMonitor;
    private int validationState;

    public FileSelectorRowWidget(Composite parent, String id, Integer selectorID, IAttributeDefinition<?, ?, ?> def) {
        this.attr = def;
        this.label = new Label(parent, 0);
        this.label.setText(Messages.getString(this.attr.getName()));
        this.nonDefaultMarker = new Label(parent, 0);
        this.nonDefaultMarker.setText(" ");
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = false;
        this.label.setLayoutData((Object)this.gridData);
        this.widget = new FileSelector(parent, selectorID, Messages.getString(this.attr.getDescription()));
        this.widget.setData(id);
        try {
            this.defaultValue = this.attr.create().getValueAsString();
        }
        catch (IllegalValueException illegalValueException) {
            this.defaultValue = "";
        }
        this.eventMonitor = new EventMonitor();
        this.widget.addModifyListener(this.eventMonitor);
    }

    public void setPath(String path) {
        this.widget.setPath(path);
    }

    public void setEnabled(boolean state) {
        this.widget.setEnabled(state);
    }

    public void setData(Object value) {
        this.widget.setData(value);
    }

    public Object getData() {
        return this.widget.getData();
    }

    public String getValue() {
        return this.widget.getPath().trim();
    }

    public boolean isEnabled() {
        return this.widget.isEnabled();
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.widget.addSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.widget.addModifyListener(listener);
    }

    @Override
    public void resetValidationState() {
        this.validationState = 0;
    }

    @Override
    public void setFieldInError() {
        this.validationState = 2;
    }

    @Override
    public void setValidationRequired() {
        this.validationState = 1;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationState == 1 || this.validationState == 2;
    }

    @Override
    public boolean isMatchingWidget(Widget source) {
        return this.widget.isMatchingWidget(source);
    }

    private class EventMonitor
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            if (FileSelectorRowWidget.this.widget.getPath().equals(FileSelectorRowWidget.this.defaultValue)) {
                FileSelectorRowWidget.this.nonDefaultMarker.setText(" ");
            } else {
                FileSelectorRowWidget.this.nonDefaultMarker.setText("*");
            }
        }
    }

    private class FileSelector {
        private Object attrValue;
        private Text path;
        private Button browseButton;

        public FileSelector(Composite parent, Integer selectorID, String tooltipText) {
            this.path = new Text(parent, 2052);
            this.path.setToolTipText(tooltipText);
            GridData gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            this.path.setLayoutData((Object)gd);
            this.browseButton = new Button(parent, 8);
            this.browseButton.setText(Messages.getString("FileSelector.BrowseButton"));
            this.browseButton.setData("BUTTON_ID", (Object)new Integer(selectorID));
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = false;
            this.browseButton.setLayoutData((Object)gd);
        }

        public void setEnabled(boolean enable) {
            this.path.setEnabled(enable);
            this.browseButton.setEnabled(enable);
        }

        public boolean isEnabled() {
            return this.path.isEnabled();
        }

        public void setPath(String pathname) {
            this.path.setText(pathname);
        }

        public String getPath() {
            return this.path.getText();
        }

        public boolean setFocus() {
            return this.path.setFocus();
        }

        public void setData(Object value) {
            this.attrValue = value;
        }

        public Object getData() {
            return this.attrValue;
        }

        public void addSelectionListener(SelectionListener listener) {
            this.browseButton.addSelectionListener(listener);
        }

        public void addModifyListener(ModifyListener listener) {
            this.path.addModifyListener(listener);
        }

        public boolean isMatchingWidget(Widget source) {
            return this.path == source;
        }
    }
}

