/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.core.ServiceProvider;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceManagerServiceProvider
extends ServiceProvider
implements IResourceManagerConfiguration,
IServiceProviderWorkingCopy {
    private static final String TAG_AUTOSTART = "autoStart";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_NAME = "name";
    private static final String TAG_UNIQUE_NAME = "uniqName";
    private static final String TAG_CONNECTION_NAME = "connectionName";
    private static final String TAG_REMOTE_SERVICES_ID = "remoteServicesID";
    private static final String TAG_STATE = "state";
    private final IModelManager fModelManager = PTPCorePlugin.getDefault().getModelManager();
    private final IServiceModelManager fServiceManager = ServiceModelManager.getInstance();
    private final IService fLaunchService = this.fServiceManager.getService("org.eclipse.ptp.core.LaunchService");
    private boolean fIsDirty = false;
    private IServiceProvider fServiceProvider = null;
    private final IModelManagerChildListener fModelListener = new IModelManagerChildListener(){

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public void handleEvent(INewResourceManagerEvent e) {
        }

        public void handleEvent(IRemoveResourceManagerEvent e) {
            if (e.getResourceManager().getUniqueName().equals(AbstractResourceManagerServiceProvider.this.getUniqueName())) {
                AbstractResourceManagerServiceProvider.this.unregisterListeners();
                AbstractResourceManagerServiceProvider.this.removeThisProviderFromAllConfigurations();
            }
        }
    };

    public AbstractResourceManagerServiceProvider() {
        this.registerListeners();
    }

    public AbstractResourceManagerServiceProvider(IServiceProvider provider) {
        this.fServiceProvider = provider;
        this.setProperties(provider.getProperties());
        this.setDescriptor(provider.getDescriptor());
    }

    @Override
    public abstract IResourceManagerControl createResourceManager();

    @Override
    public boolean getAutoStart() {
        return this.getBoolean(TAG_AUTOSTART, false);
    }

    @Override
    public String getConnectionName() {
        return this.getString(TAG_CONNECTION_NAME, "");
    }

    @Override
    public String getDescription() {
        return this.getString(TAG_DESCRIPTION, "");
    }

    @Override
    public String getName() {
        return this.getString(TAG_NAME, "");
    }

    public IServiceProvider getOriginal() {
        return this.fServiceProvider;
    }

    @Override
    public String getRemoteServicesId() {
        return this.getString(TAG_REMOTE_SERVICES_ID, null);
    }

    @Override
    public String getResourceManagerId() {
        return super.getId();
    }

    public ResourceManagerAttributes.State getState() {
        return ResourceManagerAttributes.State.valueOf(this.getString(TAG_STATE, ResourceManagerAttributes.State.STOPPED.toString()));
    }

    @Override
    public String getType() {
        return super.getName();
    }

    @Override
    public String getUniqueName() {
        String name = this.getString(TAG_UNIQUE_NAME, null);
        if (name == null) {
            name = UUID.randomUUID().toString();
            this.putString(TAG_UNIQUE_NAME, name);
        }
        return name;
    }

    public boolean isConfigured() {
        return !this.getConnectionName().equals("") && this.getRemoteServicesId() != null;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    @Override
    public boolean needsDebuggerLaunchHelp() {
        return false;
    }

    public void putString(String key, String value) {
        this.fIsDirty = true;
        super.putString(key, value);
    }

    public void registerListeners() {
        this.fModelManager.addListener(this.fModelListener);
    }

    public void save() {
        if (this.fServiceProvider != null) {
            this.fServiceProvider.setProperties(this.getProperties());
            this.fIsDirty = false;
        }
    }

    @Override
    public void save(IMemento memento) {
        memento.putString(TAG_UNIQUE_NAME, this.getUniqueName());
    }

    @Override
    public void setAutoStart(boolean flag) {
        this.putBoolean(TAG_AUTOSTART, flag);
    }

    @Override
    public void setConnectionName(String name) {
        this.putString(TAG_CONNECTION_NAME, name);
    }

    @Override
    public void setDescription(String description) {
        this.putString(TAG_DESCRIPTION, description);
    }

    @Override
    public void setName(String name) {
        this.putString(TAG_NAME, name);
    }

    public void setProperties(Map<String, String> properties) {
        this.fIsDirty = true;
        super.setProperties(properties);
    }

    @Override
    public void setRemoteServicesId(String id) {
        this.putString(TAG_REMOTE_SERVICES_ID, id);
    }

    public void setResourceManagerId(String id) {
    }

    public void setState(ResourceManagerAttributes.State state) {
        this.putString(TAG_STATE, state.name());
    }

    public void setUniqueName(String id) {
        this.putString(TAG_UNIQUE_NAME, id);
    }

    public void unregisterListeners() {
        this.fModelManager.removeListener(this.fModelListener);
    }

    private void removeThisProviderFromAllConfigurations() {
        Set configs = this.fServiceManager.getConfigurations();
        for (IServiceConfiguration config : configs) {
            if (this != config.getServiceProvider(this.fLaunchService)) continue;
            config.setServiceProvider(this.fLaunchService, null);
        }
    }
}

