/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTwoPhaseBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPParameter
extends PlatformObject
implements ICPPParameter,
ICPPInternalBinding,
ICPPTwoPhaseBinding {
    private IType fType = null;
    private IASTName[] fDeclarations = null;
    private int fPosition;

    public CPPParameter(IASTName name, int pos) {
        this.fDeclarations = new IASTName[]{name};
        this.fPosition = pos;
    }

    public CPPParameter(IType type, int pos) {
        this.fType = type;
        this.fPosition = pos;
    }

    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    public IASTNode[] getDeclarations() {
        return this.fDeclarations;
    }

    public IASTNode getDefinition() {
        return null;
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        this.fDeclarations = this.fDeclarations == null ? new IASTName[]{name} : (this.fDeclarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.fDeclarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.fDeclarations, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.fDeclarations, name));
    }

    private IASTName getPrimaryDeclaration() {
        if (this.fDeclarations != null) {
            int i = 0;
            while (i < this.fDeclarations.length && this.fDeclarations[i] != null) {
                IASTNode node = this.fDeclarations[i].getParent();
                while (!(node instanceof IASTDeclaration)) {
                    node = node.getParent();
                }
                if (node instanceof IASTFunctionDefinition) {
                    return this.fDeclarations[i];
                }
                ++i;
            }
            return this.fDeclarations[0];
        }
        return null;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.getSimpleID();
        }
        return CharArrayUtils.EMPTY;
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getPrimaryDeclaration());
    }

    public IASTNode getPhysicalNode() {
        if (this.fDeclarations != null) {
            return this.fDeclarations[0];
        }
        return null;
    }

    public IType getType() {
        if (this.fType == null && this.fDeclarations != null) {
            IASTNode parent = this.fDeclarations[0].getParent();
            while (parent != null) {
                if (parent instanceof ICPPASTParameterDeclaration) {
                    this.fType = CPPVisitor.createParameterType((ICPPASTParameterDeclaration)parent, false);
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.fType;
    }

    public boolean isStatic() {
        return false;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    public boolean isGloballyQualified() {
        return false;
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        IASTNode[] ns = this.getDeclarations();
        if (ns == null) {
            return false;
        }
        int i = 0;
        while (i < ns.length && ns[i] != null) {
            IASTDeclSpecifier declSpec;
            IASTNode parent = ns[i].getParent();
            while (parent != null && !(parent instanceof IASTParameterDeclaration)) {
                parent = parent.getParent();
            }
            if (parent != null && (declSpec = ((IASTParameterDeclaration)parent).getDeclSpecifier()).getStorageClass() == storage) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IASTInitializer getDefaultValue() {
        if (this.fDeclarations == null) {
            return null;
        }
        int i = 0;
        while (i < this.fDeclarations.length && this.fDeclarations[i] != null) {
            IASTNode parent = this.fDeclarations[i].getParent();
            while (parent.getPropertyInParent() == IASTDeclarator.NESTED_DECLARATOR) {
                parent = parent.getParent();
            }
            IASTInitializer init = ((IASTDeclarator)parent).getInitializer();
            if (init != null) {
                return init;
            }
            ++i;
        }
        return null;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public boolean isExternC() {
        return false;
    }

    public String toString() {
        String name = this.getName();
        return name.length() != 0 ? name : "<unnamed>";
    }

    public IBinding getOwner() throws DOMException {
        return CPPVisitor.findEnclosingFunction(this.fDeclarations[0]);
    }

    public IValue getInitialValue() {
        return null;
    }

    public IBinding resolveFinalBinding(CPPASTNameBase name) {
        IASTName funcName;
        IBinding b;
        IBinding current = name.getPreBinding();
        if (current != this) {
            return current;
        }
        IASTNode node = this.getPrimaryDeclaration();
        while (node != null && !(node instanceof IASTFunctionDeclarator)) {
            node = node.getParent();
        }
        if (node instanceof IASTFunctionDeclarator && (b = (funcName = ASTQueries.findInnermostDeclarator((IASTFunctionDeclarator)node).getName()).resolvePreBinding()) instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)b).resolveParameter(this);
        }
        return this;
    }

    public int getParameterPosition() {
        return this.fPosition;
    }

    public static class CPPParameterProblem
    extends ProblemBinding
    implements ICPPParameter {
        public CPPParameterProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExternC() {
            return false;
        }

        public IValue getInitialValue() {
            return null;
        }

        public boolean isParameterPack() {
            return false;
        }
    }
}

