/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.proxy.core.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.rm.proxy.core.attributes.AttributeDefinition;
import org.eclipse.ptp.rm.proxy.core.element.IElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements IElement {
    private int elementID;
    private Map<String, String> attributes = new HashMap<String, String>();
    private final AttributeDefinition attrDef;

    public Element(AttributeDefinition attrDef) {
        this.attrDef = attrDef;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Element)) {
            return false;
        }
        return this.attributes.equals(((Element)other).attributes);
    }

    @Override
    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getElementID() {
        return this.elementID;
    }

    @Override
    public String getKey() {
        return this.attributes.get(this.attrDef.getKey());
    }

    @Override
    public String getParentKey() {
        return this.attributes.get(this.attrDef.getParentKey());
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }

    @Override
    public boolean isComplete() {
        Set<String> reqAttrs = this.attrDef.getRequiredAttributes();
        for (String key : reqAttrs) {
            if (this.attributes.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setAttribute(String key, String value) throws IElement.UnknownValueExecption {
        if (!this.attrDef.hasAttribute(key)) {
            throw new IElement.UnknownValueExecption();
        }
        this.attributes.put(key, value);
    }

    @Override
    public void setAttributes(IElement element) {
        this.attributes = new HashMap<String, String>(element.getAttributes());
    }

    @Override
    public void setElementID(int elementID) {
        this.elementID = elementID;
    }

    public String toString() {
        return this.toStringArray().toString();
    }

    @Override
    public Collection<String> toStringArray() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Integer.toString(this.getElementID()));
        ret.add(Integer.toString(this.attributes.size()));
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            ret.add(String.valueOf(this.attrDef.getProtocolKey(e.getKey())) + "=" + this.attrDef.getMappedValue(e.getKey(), e.getValue()));
        }
        return ret;
    }
}

