/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.internal.core.elements.Parent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PUniverse
extends Parent
implements IPUniverseControl {
    private static final int RMID_SHIFT = 24;
    private int nextResourceManagerId = 1;
    private final List<IResourceManagerControl> resourceManagers = Collections.synchronizedList(new LinkedList());
    protected String NAME_TAG = "universe ";

    private static IAttribute<?, ?, ?>[] getDefaultAttributes(String name) {
        StringAttribute nameAttr = ElementAttributes.getNameAttributeDefinition().create(name);
        return new IAttribute[]{nameAttr};
    }

    public PUniverse() {
        super("1", null, 10, PUniverse.getDefaultAttributes("TheUniverse"));
    }

    @Override
    public void addResourceManager(IResourceManagerControl addedManager) {
        this.resourceManagers.add(addedManager);
    }

    @Override
    public void addResourceManagers(IResourceManagerControl[] addedManagers) {
        IResourceManagerControl[] iResourceManagerControlArray = addedManagers;
        int n = addedManagers.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            this.addResourceManager(rm);
            ++n2;
        }
    }

    @Override
    public synchronized int getNextResourceManagerId() {
        return this.nextResourceManagerId++ << 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResourceManager getResourceManager(String id) {
        List<IResourceManagerControl> list = this.resourceManagers;
        synchronized (list) {
            for (IResourceManager iResourceManager : this.resourceManagers) {
                if (!iResourceManager.getID().equals(id)) continue;
                return iResourceManager;
            }
        }
        return null;
    }

    @Override
    public IResourceManagerControl[] getResourceManagerControls() {
        return this.resourceManagers.toArray(new IResourceManagerControl[0]);
    }

    @Override
    public IResourceManager[] getResourceManagers() {
        return this.getResourceManagerControls();
    }

    @Override
    public boolean hasChildren() {
        return !this.resourceManagers.isEmpty();
    }

    @Override
    public void removeResourceManager(IResourceManager removedManager) {
        this.resourceManagers.remove(removedManager);
    }

    @Override
    public void removeResourceManagers(IResourceManager[] removedRMs) {
        IResourceManager[] iResourceManagerArray = removedRMs;
        int n = removedRMs.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            this.removeResourceManager(rm);
            ++n2;
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
    }
}

