/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedStack<T> {
    private LinkedList<T> topScope = new LinkedList();
    private final LinkedList<LinkedList<T>> scopeStack = new LinkedList();

    public void openScope() {
        this.scopeStack.add(this.topScope);
        this.topScope = new LinkedList();
    }

    public void openScope(Collection<T> items) {
        this.openScope();
        for (T item : items) {
            this.push(item);
        }
    }

    public void openScope(T[] items) {
        this.openScope();
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            this.push(item);
            ++n2;
        }
    }

    public List<T> closeScope() {
        if (this.scopeStack.isEmpty()) {
            throw new NoSuchElementException("cannot close outermost scope");
        }
        LinkedList<T> top = this.topScope;
        this.topScope = this.scopeStack.removeLast();
        return top;
    }

    public void push(T o) {
        this.topScope.add(o);
    }

    public T pop() {
        return this.topScope.removeLast();
    }

    public T peek() {
        return this.topScope.getLast();
    }

    public List<T> topScope() {
        return this.topScope;
    }

    public List<T> outerScope() {
        return this.scopeStack.getLast();
    }

    public boolean isEmpty() {
        return this.topScope.isEmpty() && this.scopeStack.isEmpty();
    }

    public void print() {
        System.out.println();
        System.out.println('-');
        this.printScope(this.topScope);
        System.out.println("----------");
        for (List list : CollectionUtils.reverseIterable(this.scopeStack)) {
            this.printScope(list);
        }
        System.out.println();
    }

    private void printScope(List<T> scope) {
        for (Object t : CollectionUtils.reverseIterable(scope)) {
            System.out.println(t);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (List list : this.scopeStack) {
            this.appendScopeContents(sb, list);
        }
        this.appendScopeContents(sb, this.topScope);
        return sb.toString();
    }

    private void appendScopeContents(StringBuilder sb, List<T> scope) {
        sb.append('[');
        boolean first = true;
        for (T t : scope) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(t);
        }
        sb.append(']');
    }
}

