/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.io.PrintStream;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;

public class ASTPrinter {
    private static boolean PRINT_PARENT_PROPERTIES = false;
    private static boolean RESOLVE_BINDINGS = false;

    public static boolean print(IASTNode node, PrintStream out) {
        int n;
        int n2;
        IASTNode[] iASTNodeArray;
        IASTPreprocessorStatement[] preStats;
        if (node == null) {
            out.println("null");
            return false;
        }
        if (node instanceof IASTTranslationUnit && (preStats = ((IASTTranslationUnit)node).getAllPreprocessorStatements()) != null) {
            iASTNodeArray = preStats;
            n2 = preStats.length;
            n = 0;
            while (n < n2) {
                IASTPreprocessorStatement stat = iASTNodeArray[n];
                ASTPrinter.print(out, 0, stat);
                ++n;
            }
        }
        node.accept(new PrintVisitor(out));
        if (node instanceof IASTTranslationUnit) {
            IASTComment[] comments;
            IASTProblem[] problems = ((IASTTranslationUnit)node).getPreprocessorProblems();
            if (problems != null) {
                iASTNodeArray = problems;
                n2 = problems.length;
                n = 0;
                while (n < n2) {
                    IASTNode problem = iASTNodeArray[n];
                    ASTPrinter.print(out, 0, problem);
                    ++n;
                }
            }
            if ((comments = ((IASTTranslationUnit)node).getComments()) != null) {
                IASTComment[] iASTCommentArray = comments;
                int n3 = comments.length;
                n2 = 0;
                while (n2 < n3) {
                    IASTComment comment = iASTCommentArray[n2];
                    ASTPrinter.print(out, 0, comment);
                    ++n2;
                }
            }
        }
        return false;
    }

    public static boolean print(IASTNode root) {
        return ASTPrinter.print(root, System.out);
    }

    public static boolean printProblems(IASTNode node, PrintStream out) {
        IASTProblem[] problems;
        if (node == null) {
            out.println("null");
            return false;
        }
        node.accept(new PrintProblemsVisitor(out));
        if (node instanceof IASTTranslationUnit && (problems = ((IASTTranslationUnit)node).getPreprocessorProblems()) != null) {
            IASTProblem[] iASTProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IASTProblem problem = iASTProblemArray[n2];
                ASTPrinter.print(out, 0, problem);
                ++n2;
            }
        }
        return false;
    }

    public static boolean printProblems(IASTNode root) {
        return ASTPrinter.printProblems(root, System.out);
    }

    private static void print(PrintStream out, int indentLevel, Object n) {
        ICArrayType at;
        int i = 0;
        while (i < indentLevel) {
            out.print("  ");
            ++i;
        }
        if (n == null) {
            out.println("NULL");
            return;
        }
        out.print(n.getClass().getName());
        if (n instanceof ASTNode) {
            ASTNode node = (ASTNode)n;
            out.print(" (" + node.getOffset() + "," + node.getLength() + ") ");
            if (node.getParent() == null && !(node instanceof IASTTranslationUnit)) {
                out.print("PARENT IS NULL ");
            }
            if (PRINT_PARENT_PROPERTIES) {
                out.print(node.getPropertyInParent());
            }
        }
        if (n instanceof ICArrayType && (at = (ICArrayType)n).isRestrict()) {
            out.print(" restrict");
        }
        if (n instanceof IASTName) {
            IASTName name = (IASTName)n;
            out.print(" " + ((IASTName)n).toString());
            if (RESOLVE_BINDINGS) {
                try {
                    IBinding binding = name.resolveBinding();
                    ASTPrinter.print(out, indentLevel, binding);
                }
                catch (Exception exception) {
                    System.out.println("Exception while resolving binding: " + name);
                }
            }
        } else if (n instanceof ICASTPointer) {
            ICASTPointer pointer = (ICASTPointer)n;
            if (pointer.isConst()) {
                out.print(" const");
            }
            if (pointer.isVolatile()) {
                out.print(" volatile");
            }
            if (pointer.isRestrict()) {
                out.print(" restrict");
            }
        } else if (n instanceof ICPointerType) {
            ICPointerType pointer = (ICPointerType)n;
            if (pointer.isConst()) {
                out.print(" const");
            }
            if (pointer.isVolatile()) {
                out.print(" volatile");
            }
            if (pointer.isRestrict()) {
                out.print(" restrict");
            }
            out.println();
            try {
                ASTPrinter.print(out, indentLevel, ((ITypeContainer)n).getType());
            }
            catch (Exception exception) {}
        } else if (n instanceof ICASTArrayModifier) {
            if (((ICASTArrayModifier)n).isRestrict()) {
                out.print(" restrict");
            }
        } else if (n instanceof IASTComment) {
            out.print("'" + new String(((IASTComment)n).getComment()) + "'");
        } else if (n instanceof ITypeContainer) {
            out.println();
            try {
                ASTPrinter.print(out, indentLevel, ((ITypeContainer)n).getType());
            }
            catch (Exception exception) {}
        } else if (n instanceof IVariable) {
            IVariable var = (IVariable)n;
            try {
                IType t = var.getType();
                out.println();
                ASTPrinter.print(out, indentLevel, t);
            }
            catch (DOMException dOMException) {}
        } else if (n instanceof IProblemBinding) {
            IProblemBinding problem = (IProblemBinding)n;
            out.print(problem.getMessage());
        }
        out.println();
    }

    private static class PrintProblemsVisitor
    extends PrintVisitor {
        public PrintProblemsVisitor(PrintStream out) {
            super(out);
        }

        protected int genericVisit(IASTNode node) {
            ++this.indentLevel;
            if (node instanceof IASTProblem) {
                ASTPrinter.print(this.out, this.indentLevel, node);
            }
            return 3;
        }
    }

    private static class PrintVisitor
    extends ASTGenericVisitor {
        final PrintStream out;
        int indentLevel = 0;

        public PrintVisitor(PrintStream out) {
            super(true);
            this.out = out;
            this.shouldVisitAmbiguousNodes = true;
        }

        protected int genericVisit(IASTNode node) {
            ASTPrinter.print(this.out, this.indentLevel++, node);
            return 3;
        }

        protected int genericLeave(IASTNode node) {
            --this.indentLevel;
            return 3;
        }

        public int visit(ASTAmbiguousNode node) {
            ASTPrinter.print(this.out, this.indentLevel++, node);
            IASTNode[] iASTNodeArray = node.getNodes();
            int n = iASTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode n3 = iASTNodeArray[n2];
                n3.accept(this);
                ++n2;
            }
            --this.indentLevel;
            return 3;
        }
    }
}

