/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPCompositeBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class LookupData {
    protected IASTName astName;
    protected CPPASTTranslationUnit tu;
    public Map<ICPPNamespaceScope, List<ICPPNamespaceScope>> usingDirectives = Collections.emptyMap();
    public ObjectSet<IScope> visited = new ObjectSet(1);
    public boolean checkWholeClassScope = false;
    public boolean ignoreUsingDirectives = false;
    public boolean usingDirectivesOnly = false;
    public boolean forceQualified = false;
    public boolean forAssociatedScopes = false;
    public boolean contentAssist = false;
    public boolean prefixLookup = false;
    public boolean typesOnly = false;
    public boolean checkPointOfDecl = true;
    public boolean usesEnclosingScope = true;
    public boolean firstArgIsImpliedMethodArg = false;
    public boolean ignoreMembers = false;
    public boolean fNoNarrowing = false;
    private ICPPASTParameterDeclaration[] functionParameters;
    private IASTInitializerClause[] functionArgs;
    private IType[] functionArgTypes;
    private BitSet functionArgLValues;
    public ICPPClassType skippedScope;
    public Object foundItems = null;
    public ProblemBinding problem;

    public LookupData(IASTName n) {
        this.astName = n;
        this.tu = (CPPASTTranslationUnit)this.astName.getTranslationUnit();
        this.typesOnly = LookupData.typesOnly(this.astName);
        this.checkWholeClassScope = LookupData.checkWholeClassScope(n);
    }

    public LookupData() {
        this.astName = null;
    }

    public final char[] getNameCharArray() {
        if (this.astName != null) {
            return this.astName.toCharArray();
        }
        return CharArrayUtils.EMPTY;
    }

    public boolean includeBlockItem(IASTNode item) {
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return true;
        }
        return this.astName != null && this.astName.getParent() instanceof IASTIdExpression || item instanceof ICPPASTNamespaceDefinition || item instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)item).getDeclSpecifier() instanceof IASTCompositeTypeSpecifier || item instanceof ICPPASTTemplateDeclaration;
    }

    static boolean typesOnly(IASTName name) {
        if (name == null) {
            return false;
        }
        if (name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode parent = name.getParent();
        if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTElaboratedTypeSpecifier || parent instanceof ICPPASTCompositeTypeSpecifier) {
            return true;
        }
        if (parent instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)parent).getNames();
            return name != ns[ns.length - 1];
        }
        return false;
    }

    public boolean forUsingDeclaration() {
        IASTNode p2;
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode p1 = this.astName.getParent();
        if (p1 instanceof ICPPASTUsingDeclaration) {
            return true;
        }
        if (p1 instanceof ICPPASTQualifiedName && (p2 = p1.getParent()) instanceof ICPPASTUsingDeclaration) {
            IASTName[] ns = ((ICPPASTQualifiedName)p1).getNames();
            return ns[ns.length - 1] == this.astName;
        }
        return false;
    }

    public boolean forFunctionDeclaration() {
        IASTNode p1;
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTName n = this.astName;
        if (n.getParent() instanceof ICPPASTTemplateId) {
            n = (IASTName)n.getParent();
        }
        if ((p1 = n.getParent()) instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)p1).getLastName() != n) {
                return false;
            }
            p1 = p1.getParent();
        }
        if (p1 instanceof IASTDeclarator) {
            IASTNode p2 = ASTQueries.findOutermostDeclarator((IASTDeclarator)p1).getParent();
            if (p2 instanceof IASTSimpleDeclaration) {
                if (p2.getParent() instanceof ICPPASTExplicitTemplateInstantiation) {
                    return false;
                }
                return !(this.astName instanceof ICPPASTTemplateId) || !((ICPPASTDeclSpecifier)((IASTSimpleDeclaration)p2).getDeclSpecifier()).isFriend();
            }
            return p2 instanceof IASTFunctionDefinition;
        }
        return false;
    }

    public boolean forExplicitFunctionSpecialization() {
        IASTNode p2;
        IASTNode p1;
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTName n = this.astName;
        if (n.getParent() instanceof ICPPASTTemplateId) {
            n = (IASTName)n.getParent();
        }
        if ((p1 = n.getParent()) instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)p1).getLastName() != n) {
                return false;
            }
            p1 = p1.getParent();
        }
        if (p1 instanceof IASTDeclarator && ((p2 = ASTQueries.findOutermostDeclarator((IASTDeclarator)p1).getParent()) instanceof IASTSimpleDeclaration || p2 instanceof IASTFunctionDefinition)) {
            ICPPASTTemplateDeclaration tmplDecl = CPPTemplates.getTemplateDeclaration(n);
            return tmplDecl instanceof ICPPASTTemplateSpecialization;
        }
        return false;
    }

    public boolean forExplicitFunctionInstantiation() {
        IASTNode p2;
        IASTNode p1;
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTName n = this.astName;
        if (n.getParent() instanceof ICPPASTTemplateId) {
            n = (IASTName)n.getParent();
        }
        if ((p1 = n.getParent()) instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)p1).getLastName() != n) {
                return false;
            }
            p1 = p1.getParent();
        }
        if (p1 instanceof IASTDeclarator && (p2 = ASTQueries.findOutermostDeclarator((IASTDeclarator)p1).getParent()) instanceof IASTDeclaration) {
            return p2.getParent() instanceof ICPPASTExplicitTemplateInstantiation;
        }
        return false;
    }

    public boolean qualified() {
        if (this.forceQualified) {
            return true;
        }
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode p1 = this.astName.getParent();
        if (p1 instanceof ICPPASTQualifiedName) {
            IASTName[] qnames = ((ICPPASTQualifiedName)p1).getNames();
            return qnames.length == 1 || qnames[0] != this.astName;
        }
        return p1 instanceof ICPPASTFieldReference;
    }

    public boolean isFunctionCall() {
        if (this.astName == null) {
            return false;
        }
        if (this.astName.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode p1 = this.astName.getParent();
        if (p1 instanceof ICPPASTQualifiedName) {
            p1 = p1.getParent();
        }
        return p1 instanceof IASTIdExpression && p1.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkWholeClassScope(IASTName name) {
        block8: {
            if (name == null) {
                return false;
            }
            lastProp = name.getPropertyInParent();
            if (lastProp == CPPSemantics.STRING_LOOKUP_PROPERTY) {
                return true;
            }
            inInitializer = false;
            parent = name.getParent();
            while (parent instanceof IASTName) {
                name = (IASTName)parent;
                parent = name.getParent();
            }
            while (parent != null && !(parent instanceof IASTFunctionDefinition)) {
                if (parent instanceof IASTInitializer) {
                    inInitializer = true;
                }
                lastProp = parent.getPropertyInParent();
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTFunctionDefinition)) break block8;
            if (lastProp != IASTFunctionDefinition.DECL_SPECIFIER && lastProp != IASTFunctionDefinition.DECLARATOR || inInitializer) ** GOTO lbl22
            return false;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
lbl22:
                // 2 sources

                ** while (parent.getParent() instanceof ICPPASTTemplateDeclaration)
            }
lbl23:
            // 1 sources

            if (parent.getPropertyInParent() != IASTCompositeTypeSpecifier.MEMBER_DECLARATION) {
                return false;
            }
            prop = name.getPropertyInParent();
            if (prop == IASTIdExpression.ID_NAME || prop == IASTFieldReference.FIELD_NAME || prop == ICASTFieldDesignator.FIELD_NAME || prop == ICPPASTUsingDirective.QUALIFIED_NAME || prop == ICPPASTUsingDeclaration.NAME || prop == IASTFunctionCallExpression.FUNCTION_NAME || prop == IASTNamedTypeSpecifier.NAME || prop == ICPPASTConstructorChainInitializer.MEMBER_ID) {
                return true;
            }
        }
        return false;
    }

    public boolean hasResults() {
        if (this.foundItems == null) {
            return false;
        }
        if (this.foundItems instanceof Object[]) {
            return ((Object[])this.foundItems).length != 0;
        }
        if (this.foundItems instanceof CharArrayObjectMap) {
            return ((CharArrayObjectMap)this.foundItems).size() != 0;
        }
        return false;
    }

    public boolean hasTypeOrMemberFunctionResult() {
        if (this.foundItems == null) {
            return false;
        }
        if (this.foundItems instanceof Object[]) {
            Object[] objectArray = (Object[])this.foundItems;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof ICPPMethod || item instanceof IType) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IType getImpliedObjectArgument() {
        IScope scope;
        ASTNodeProperty prop;
        IASTNode tempNameParent;
        IASTName tempName;
        block19: {
            if (this.astName == null) {
                return null;
            }
            tempName = this.astName;
            tempNameParent = tempName.getParent();
            while (tempNameParent instanceof IASTName) {
                tempName = (IASTName)tempNameParent;
                tempNameParent = tempName.getParent();
            }
            try {
                prop = tempName.getPropertyInParent();
                if (prop != CPPSemantics.STRING_LOOKUP_PROPERTY) break block19;
                if (tempNameParent instanceof ICPPASTUnaryExpression) {
                    ICPPASTUnaryExpression unaryExp = (ICPPASTUnaryExpression)tempNameParent;
                    IASTExpression oprd = unaryExp.getOperand();
                    return oprd.getExpressionType();
                }
                if (tempNameParent instanceof ICPPASTFieldReference) {
                    ICPPASTFieldReference fieldRef = (ICPPASTFieldReference)tempNameParent;
                    IType implied = fieldRef.getFieldOwner().getExpressionType();
                    if (fieldRef.isPointerDereference() && implied instanceof IPointerType) {
                        return ((IPointerType)implied).getType();
                    }
                    return implied;
                }
                if (tempNameParent instanceof IASTArraySubscriptExpression) {
                    IASTExpression exp = ((IASTArraySubscriptExpression)tempNameParent).getArrayExpression();
                    return exp.getExpressionType();
                }
                if (tempNameParent instanceof IASTFunctionCallExpression) {
                    return ((IASTFunctionCallExpression)tempNameParent).getFunctionNameExpression().getExpressionType();
                }
                if (tempNameParent instanceof IASTBinaryExpression) {
                    return ((IASTBinaryExpression)tempNameParent).getOperand1().getExpressionType();
                }
                if (tempNameParent instanceof ICPPASTDeleteExpression) {
                    IType implied = ((ICPPASTDeleteExpression)tempNameParent).getOperand().getExpressionType();
                    if (implied instanceof IPointerType) {
                        return ((IPointerType)implied).getType();
                    }
                    return implied;
                }
                return null;
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        if (prop == IASTFieldReference.FIELD_NAME) {
            ICPPASTFieldReference fieldRef = (ICPPASTFieldReference)tempNameParent;
            IType implied = CPPSemantics.getChainedMemberAccessOperatorReturnType(fieldRef);
            if (fieldRef.isPointerDereference() && (implied = SemanticUtil.getUltimateTypeUptoPointers(implied)) instanceof IPointerType) {
                return ((IPointerType)implied).getType();
            }
            return implied;
        }
        if (prop == IASTIdExpression.ID_NAME) {
            IScope scope2 = CPPVisitor.getContainingScope(tempName);
            if (scope2 instanceof ICPPClassScope) {
                return ((ICPPClassScope)scope2).getClassType();
            }
            IType implied = CPPVisitor.getThisType(scope2);
            if (implied instanceof IPointerType) {
                return ((IPointerType)implied).getType();
            }
            return implied;
        }
        if (prop == IASTDeclarator.DECLARATOR_NAME && this.forExplicitFunctionInstantiation() && (scope = CPPVisitor.getContainingScope(this.astName)) instanceof ICPPClassScope) {
            return ((ICPPClassScope)scope).getClassType();
        }
        return null;
    }

    public boolean forFriendship() {
        if (this.astName == null) {
            return false;
        }
        IASTNode node = this.astName.getParent();
        while (node instanceof IASTName) {
            node = node.getParent();
        }
        IASTDeclaration decl = null;
        IASTDeclarator dtor = null;
        if (node instanceof ICPPASTDeclSpecifier && node.getParent() instanceof IASTDeclaration) {
            decl = (IASTDeclaration)node.getParent();
        } else if (node instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)node;
            while (dtor.getParent() instanceof IASTDeclarator) {
                dtor = (IASTDeclarator)dtor.getParent();
            }
            if (!(dtor.getParent() instanceof IASTDeclaration)) {
                return false;
            }
            decl = (IASTDeclaration)dtor.getParent();
        } else {
            return false;
        }
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)decl;
            if (!((ICPPASTDeclSpecifier)simple.getDeclSpecifier()).isFriend()) {
                return false;
            }
            if (dtor != null) {
                return true;
            }
            return simple.getDeclarators().length == 0;
        }
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fnDef = (IASTFunctionDefinition)decl;
            if (!((ICPPASTDeclSpecifier)fnDef.getDeclSpecifier()).isFriend()) {
                return false;
            }
            return dtor != null;
        }
        return false;
    }

    public boolean checkAssociatedScopes() {
        IASTName name = this.astName;
        if (name == null || name instanceof ICPPASTQualifiedName) {
            return false;
        }
        IASTNode parent = name.getParent();
        if (name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            parent = parent.getParent();
        }
        if (parent instanceof ICPPASTQualifiedName) {
            return false;
        }
        return this.isFunctionCall();
    }

    public boolean checkClassContainingFriend() {
        if (this.astName == null || this.astName instanceof ICPPASTQualifiedName) {
            return false;
        }
        IASTNode p = this.astName.getParent();
        ASTNodeProperty prop = null;
        while (p != null) {
            prop = p.getPropertyInParent();
            if (prop == ICPPASTTemplateId.TEMPLATE_ID_ARGUMENT || prop == IASTDeclarator.DECLARATOR_NAME) {
                return false;
            }
            if (p instanceof IASTDeclarator && !(((IASTDeclarator)p).getName() instanceof ICPPASTQualifiedName)) {
                return false;
            }
            if (p instanceof IASTDeclaration) {
                if (prop == IASTCompositeTypeSpecifier.MEMBER_DECLARATION) {
                    if (p instanceof IASTSimpleDeclaration) {
                        ICPPASTDeclSpecifier declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)p).getDeclSpecifier();
                        return declSpec.isFriend();
                    }
                    if (p instanceof IASTFunctionDefinition) {
                        ICPPASTDeclSpecifier declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)p).getDeclSpecifier();
                        return declSpec.isFriend();
                    }
                } else {
                    return false;
                }
            }
            p = p.getParent();
        }
        return false;
    }

    public void setFunctionArguments(IASTInitializerClause ... exprs) {
        this.functionArgs = exprs;
        if (exprs.length != 0) {
            IASTNode node = exprs[0];
            boolean checkForDependentName = false;
            while (node != null) {
                if (node instanceof ICPPASTTemplateDeclaration) {
                    checkForDependentName = true;
                    break;
                }
                node = node.getParent();
            }
            if (checkForDependentName) {
                IType[] types;
                IType[] iTypeArray = types = this.getFunctionArgumentTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (CPPTemplates.isDependentType(type)) {
                        this.checkPointOfDecl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    public IType[] getFunctionArgumentTypes() {
        block5: {
            block6: {
                if (this.functionArgTypes != null) break block5;
                if (this.functionArgs == null) break block6;
                IASTInitializerClause[] exprs = this.functionArgs;
                this.functionArgTypes = new IType[exprs.length];
                int i = 0;
                while (i < exprs.length) {
                    IASTInitializerClause e = exprs[i];
                    if (e instanceof IASTExpression) {
                        IType etype = ((IASTExpression)e).getExpressionType();
                        this.functionArgTypes[i] = SemanticUtil.getSimplifiedType(etype);
                    } else if (e instanceof ICPPASTInitializerList) {
                        this.functionArgTypes[i] = new InitializerListType((ICPPASTInitializerList)e);
                    }
                    ++i;
                }
                break block5;
            }
            if (this.functionParameters == null) break block5;
            ICPPASTParameterDeclaration[] pdecls = this.functionParameters;
            this.functionArgTypes = new IType[pdecls.length];
            int i = 0;
            while (i < pdecls.length) {
                this.functionArgTypes[i] = SemanticUtil.getSimplifiedType(CPPVisitor.createParameterType(pdecls[i], true));
                ++i;
            }
        }
        return this.functionArgTypes;
    }

    public BitSet getFunctionArgumentLValues() {
        block4: {
            block5: {
                if (this.functionArgLValues != null) break block4;
                this.functionArgLValues = new BitSet();
                IASTInitializerClause[] args = this.getFunctionArguments();
                if (args == null) break block5;
                int i = 0;
                while (i < args.length) {
                    IASTInitializerClause arg = args[i];
                    if (arg instanceof IASTExpression) {
                        this.functionArgLValues.set(i, ((IASTExpression)arg).isLValue());
                    } else {
                        this.functionArgLValues.set(i, false);
                    }
                    ++i;
                }
                break block4;
            }
            IType[] argTypes = this.getFunctionArgumentTypes();
            if (argTypes == null) break block4;
            int i = 0;
            while (i < argTypes.length) {
                IType t = argTypes[i];
                this.functionArgLValues.set(i, t instanceof ICPPReferenceType && !((ICPPReferenceType)t).isRValueReference());
                ++i;
            }
        }
        return this.functionArgLValues;
    }

    public void setFunctionParameters(ICPPASTParameterDeclaration[] parameters) {
        this.functionParameters = parameters;
    }

    public IASTInitializerClause[] getFunctionArguments() {
        return this.functionArgs;
    }

    public int getFunctionArgumentCount() {
        if (this.functionArgs != null) {
            return this.functionArgs.length;
        }
        if (this.functionParameters != null) {
            return this.functionParameters.length;
        }
        return 0;
    }

    public boolean hasFunctionArguments() {
        return this.functionArgs != null || this.functionParameters != null;
    }

    public IBinding[] getFoundBindings() {
        Object[] items;
        if (this.foundItems instanceof Object[] && (items = (Object[])this.foundItems).length != 0) {
            IBinding[] bindings = new IBinding[items.length];
            int k = 0;
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IBinding && !(item instanceof ICPPUsingDeclaration) && !(item instanceof CPPCompositeBinding)) {
                    bindings[k++] = (IBinding)item;
                }
                ++n2;
            }
            if (k != 0) {
                return ArrayUtil.trimAt(IBinding.class, bindings, k - 1);
            }
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public int getFoundItemCount() {
        if (this.foundItems instanceof Object[]) {
            Object[] items = (Object[])this.foundItems;
            int len = items.length - 1;
            while (len >= 0) {
                if (items[len] != null) break;
                --len;
            }
            return len + 1;
        }
        return 0;
    }
}

