/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.data;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.rm.pbs.core.PBSJobAttributes;
import org.eclipse.ptp.rm.pbs.core.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.PBSUIPlugin;
import org.eclipse.ptp.rm.pbs.ui.data.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.utils.ConfigUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSBatchScriptTemplate {
    private static final int BUFFER_SIZE = 524288;
    private static final String EXECMD_PLACEHOLDER = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_execmdPlaceholder;
    private static final String MPICMD_PLACEHOLDER = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_mpicmdPlaceholder;
    private static final String MPICORES_FLAG = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_mpiCores_flag;
    private static final String MPIOPT_PLACEHOLDER = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_mpioptPlaceholder;
    private static final String PRECMD_PLACEHOLDER = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_precmdPlaceholder;
    private static final String PSTCMD_PLACEHOLDER = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_pstcmdPlaceholder;
    private static final String TAG_CHGDIR = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_chdirTag;
    private static final String TAG_ENV = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_envTag;
    private static final String TAG_EXECMD = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_execTag;
    private static final String TAG_EXPORT_ENV = Messages.PBSJobAttributeName_5;
    private static final String TAG_INTERNAL = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSAttributeInternalExtension;
    private static final String TAG_MPICMD = Messages.PBSJobAttributeName_39;
    private static final String TAG_MPIOPT = Messages.PBSJobAttributeName_37;
    private static final String TAG_NCPUS = Messages.PBSJobAttributeName_23;
    private static final String TAG_NODES = Messages.PBSJobAttributeName_25;
    private static final String TAG_PRARGS = org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_prargsTag;
    private static final String TAG_PRECMD = Messages.PBSJobAttributeName_40;
    private static final String TAG_PSTCMD = Messages.PBSJobAttributeName_41;
    private static final String TAG_SCRIPT = Messages.PBSJobAttributeName_38;
    private ILaunchConfiguration configuration;
    private final Map<String, AttributePlaceholder> internalAttributes;
    private String name;
    private final Map<String, AttributePlaceholder> pbsJobAttributes = new TreeMap<String, AttributePlaceholder>();
    private final StringBuffer text;
    private Properties toolTips;

    public PBSBatchScriptTemplate() {
        this.internalAttributes = new TreeMap<String, AttributePlaceholder>();
        this.text = new StringBuffer();
        this.loadToolTips();
    }

    public void configure() throws CoreException, IllegalValueException {
        Iterator<AttributePlaceholder> i = this.pbsJobAttributes.values().iterator();
        while (i.hasNext()) {
            this.maybeSetValue(i.next());
        }
        i = this.internalAttributes.values().iterator();
        while (i.hasNext()) {
            this.maybeSetValue(i.next());
        }
    }

    public IAttribute<?, ?, ?> createScriptAttribute() throws IllegalValueException, CoreException {
        Map defs = PBSJobAttributes.getAttributeDefinitionMap();
        IAttributeDefinition def = (IAttributeDefinition)defs.get(TAG_SCRIPT);
        IAttribute attr = def.create();
        String value = PBSBatchScriptTemplate.denormalize(this.realize());
        attr.setValueAsString(value);
        return attr;
    }

    public ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, AttributePlaceholder> getInternalAttributes() {
        return this.internalAttributes;
    }

    public AttributePlaceholder getMpiCommand() {
        return this.internalAttributes.get(TAG_MPICMD);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, AttributePlaceholder> getPbsJobAttributes() {
        return this.pbsJobAttributes;
    }

    public AttributePlaceholder getPostpendedBashCommands() {
        return this.internalAttributes.get(TAG_PSTCMD);
    }

    public AttributePlaceholder getPrependedBashCommands() {
        return this.internalAttributes.get(TAG_PRECMD);
    }

    public String getText() {
        return this.text.toString();
    }

    public void load(InputStream input) throws Throwable {
        this.clearAll();
        Map defs = PBSJobAttributes.getAttributeDefinitionMap();
        BufferedReader br = null;
        String line = null;
        AttributePlaceholder ap = null;
        boolean processedExecLine = false;
        String separator = System.getProperty("line.separator");
        try {
            br = new BufferedReader(new InputStreamReader(input), 524288);
            while (true) {
                ap = null;
                try {
                    line = br.readLine();
                }
                catch (EOFException eOFException) {}
                if (line == null) break;
                this.text.append(line).append(separator);
                if (line.startsWith("#PBS")) {
                    ap = this.handlePBSJobAttribute(line, defs);
                    if (ap != null) {
                        this.pbsJobAttributes.put(ap.getName(), ap);
                        continue;
                    }
                } else if (line.startsWith("#")) continue;
                if (processedExecLine) {
                    ap = this.handleInternalPlaceholder(line, PSTCMD_PLACEHOLDER, defs);
                    if (ap == null) continue;
                    this.internalAttributes.put(TAG_PSTCMD, ap);
                    continue;
                }
                ap = this.handleInternalPlaceholder(line, PRECMD_PLACEHOLDER, defs);
                if (ap != null) {
                    this.internalAttributes.put(TAG_PRECMD, ap);
                    continue;
                }
                ap = this.handleInternalPlaceholder(line, MPICMD_PLACEHOLDER, defs);
                if (ap != null) {
                    this.internalAttributes.put(TAG_MPICMD, ap);
                }
                if ((ap = this.handleInternalPlaceholder(line, MPIOPT_PLACEHOLDER, defs)) != null) {
                    this.internalAttributes.put(TAG_MPIOPT, ap);
                }
                if (!line.contains(EXECMD_PLACEHOLDER)) continue;
                processedExecLine = true;
            }
            if (this.configuration != null) {
                this.configure();
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String realize() throws CoreException {
        String value;
        String name;
        String template = this.text.toString();
        if (this.configuration != null) {
            template = this.captureEnvironment(template);
            template = this.maybeReplaceChdir(template);
            template = this.maybeReplaceExec(template);
            template = this.maybeReplaceArgs(template);
        }
        for (AttributePlaceholder ap : this.pbsJobAttributes.values()) {
            name = ap.getName();
            if (TAG_EXPORT_ENV.equals(name)) {
                if (((Boolean)ap.getAttribute().getValue()).booleanValue()) {
                    template = this.replaceWithValue(name, "", template);
                    continue;
                }
                template = this.removeLine(name, template);
                continue;
            }
            value = ap.getAttribute().getValueAsString();
            template = "".equals(value) ? this.removeLine(name, template) : this.replaceWithValue(name, value, template);
        }
        for (AttributePlaceholder ap : this.internalAttributes.values()) {
            name = ap.getName();
            value = ap.getAttribute().getValueAsString();
            template = "".equals(value) ? this.removePlaceholder(name, template) : this.replaceWithValue(name, value, template);
        }
        return template;
    }

    public void saveValues(ILaunchConfigurationWorkingCopy config) {
        Object value;
        String id;
        IAttribute<?, ?, ?> attr;
        for (AttributePlaceholder ap : this.pbsJobAttributes.values()) {
            attr = ap.getAttribute();
            if (attr == null) continue;
            id = attr.getDefinition().getId();
            value = attr.getValue();
            if (value instanceof Boolean) {
                config.setAttribute(id, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                config.setAttribute(id, ((Integer)value).intValue());
                continue;
            }
            if (!(value instanceof String)) continue;
            config.setAttribute(id, (String)value);
        }
        for (AttributePlaceholder ap : this.internalAttributes.values()) {
            attr = ap.getAttribute();
            if (attr == null) continue;
            id = attr.getDefinition().getId();
            value = attr.getValue();
            if (value instanceof Boolean) {
                config.setAttribute(id, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                config.setAttribute(id, ((Integer)value).intValue());
                continue;
            }
            if (!(value instanceof String)) continue;
            config.setAttribute(id, (String)value);
        }
        this.configuration = config;
    }

    public void setConfiguration(ILaunchConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setMPIAttributes(String command) throws IllegalValueException {
        AttributePlaceholder mpiExec = this.internalAttributes.get(TAG_MPICMD);
        AttributePlaceholder mpiOpt = this.internalAttributes.get(TAG_MPIOPT);
        Map defs = PBSJobAttributes.getAttributeDefinitionMap();
        if (mpiExec == null && (mpiExec = ConfigUtils.getAttributePlaceholder(TAG_MPICMD, "", org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSAttributeInternalExtension, defs)) != null) {
            this.internalAttributes.put(TAG_MPICMD, mpiExec);
        }
        mpiExec.getAttribute().setValueAsString(command);
        if (mpiOpt == null && (mpiOpt = ConfigUtils.getAttributePlaceholder(TAG_MPIOPT, "", org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSAttributeInternalExtension, defs)) != null) {
            this.internalAttributes.put(TAG_MPIOPT, mpiOpt);
        }
        String cores = null;
        if ("".equals(command)) {
            cores = "";
        } else {
            AttributePlaceholder ap = this.pbsJobAttributes.get(TAG_NCPUS);
            if (ap != null) {
                cores = ap.getAttribute().getValueAsString();
            } else {
                ap = this.pbsJobAttributes.get(TAG_NODES);
                if (ap != null) {
                    cores = PBSBatchScriptTemplate.computeMPICoresFromNodesString(ap.getAttribute().getValueAsString());
                }
            }
            cores = String.valueOf(MPICORES_FLAG) + " " + cores;
        }
        mpiOpt.getAttribute().setValueAsString(cores);
    }

    public void setName(String name) {
        this.name = name;
    }

    private String captureEnvironment(String template) throws CoreException {
        Map vars = this.configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        if (vars == null || vars.isEmpty()) {
            template = this.removeLine(TAG_ENV, template);
        } else {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : vars.entrySet()) {
                sb.append(org.eclipse.ptp.rm.pbs.ui.messages.Messages.BASH_EXPORT).append(" ").append(entry.getKey()).append("=").append(entry.getValue()).append(ConfigUtils.LINE_SEP);
            }
            template = this.replaceWithValue(TAG_ENV, sb.toString(), template);
        }
        return template;
    }

    private void clearAll() {
        this.pbsJobAttributes.clear();
        this.internalAttributes.clear();
        this.text.setLength(0);
    }

    private AttributePlaceholder handleInternalPlaceholder(String line, String marker, Map<String, IAttributeDefinition<?, ?, ?>> defs) throws IllegalValueException {
        AttributePlaceholder ap = this.internalAttributes.get(marker);
        if (ap != null) {
            return null;
        }
        if (line.contains(marker)) {
            String name = marker.substring(1, marker.length() - 1);
            ap = ConfigUtils.getAttributePlaceholder(name, "", TAG_INTERNAL, defs);
        }
        return ap;
    }

    private AttributePlaceholder handlePBSJobAttribute(String line, Map<String, IAttributeDefinition<?, ?, ?>> defs) throws IllegalValueException, ParseException {
        String name = PBSBatchScriptTemplate.extractPBSAttributeName(line);
        return ConfigUtils.getAttributePlaceholder(name, "", this.toolTips.getProperty(name), defs);
    }

    private void loadToolTips() {
        block12: {
            Bundle bundle = PBSUIPlugin.getDefault().getBundle();
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_tooltips), null);
            if (url == null) {
                return;
            }
            InputStream s = null;
            this.toolTips = new Properties();
            try {
                try {
                    s = url.openStream();
                    this.toolTips.load(s);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String maybeReplaceArgs(String template) throws CoreException {
        if (this.configuration == null) {
            return template;
        }
        String args = this.configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", "");
        if ("".equals(args)) {
            return this.removePlaceholder(TAG_PRARGS, template);
        }
        return this.replaceWithValue(TAG_PRARGS, args, template);
    }

    private String maybeReplaceChdir(String template) throws CoreException {
        String exec;
        if (this.configuration == null) {
            return template;
        }
        String wdir = this.configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", "");
        if ("".equals(wdir) && !"".equals(exec = this.configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", ""))) {
            wdir = new Path(exec).removeLastSegments(1).toString();
        }
        if ("".equals(wdir)) {
            return this.removeLine(TAG_CHGDIR, template);
        }
        return this.replaceWithValue(TAG_CHGDIR, wdir, template);
    }

    private String maybeReplaceExec(String template) throws CoreException {
        if (this.configuration == null) {
            return template;
        }
        String value = this.configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", "");
        if ("".equals(value)) {
            return this.removePlaceholder(TAG_EXECMD, template);
        }
        return this.replaceWithValue(TAG_EXECMD, value, template);
    }

    private void maybeSetValue(AttributePlaceholder ap) throws CoreException, IllegalValueException {
        if (this.configuration == null || ap == null) {
            return;
        }
        IAttribute<?, ?, ?> attr = ap.getAttribute();
        if (attr == null) {
            return;
        }
        String id = attr.getDefinition().getId();
        Object value = null;
        if (attr instanceof StringAttribute) {
            value = this.configuration.getAttribute(id, ap.getDefaultString());
            if ("".equals(value)) {
                value = null;
            }
        } else if (attr instanceof BooleanAttribute) {
            value = this.configuration.getAttribute(id, new Boolean(ap.getDefaultString()).booleanValue());
        } else if (attr instanceof IntegerAttribute) {
            value = this.configuration.getAttribute(id, new Integer(ap.getDefaultString()).intValue());
        }
        if (value != null) {
            attr.setValueAsString(value.toString());
        }
    }

    private String removeLine(String name, String script) {
        StringBuffer p = new StringBuffer();
        p.append(ConfigUtils.LINE_SEP).append(".*@").append(name).append(".*@").append(ConfigUtils.LINE_SEP);
        Matcher m = Pattern.compile(p.toString()).matcher(script);
        if (m.find()) {
            return m.replaceAll(ConfigUtils.LINE_SEP);
        }
        return script;
    }

    private String removePlaceholder(String name, String script) {
        Matcher m = Pattern.compile(name = "@" + name + "@ ").matcher(script);
        if (m.find()) {
            return m.replaceAll("");
        }
        m = Pattern.compile(name = name.trim()).matcher(script);
        if (m.find()) {
            return m.replaceAll("");
        }
        return script;
    }

    private String replaceWithValue(String name, String value, String script) {
        Matcher m = Pattern.compile("@" + name + "@").matcher(script);
        if (m.find()) {
            value = value.replaceAll("\\\\", "\\\\\\\\");
            value = value.replaceAll("\\$", "\\\\\\$");
            return m.replaceAll(value);
        }
        return script;
    }

    private static String computeMPICoresFromNodesString(String value) {
        int cores = 0;
        try {
            String[] nodeSpec = value.split("[+]");
            int i = 0;
            while (i < nodeSpec.length) {
                int nodes = 1;
                int ppn = 1;
                String[] part = nodeSpec[i].split(":");
                int j = 0;
                while (j < part.length) {
                    String[] ppnDef;
                    try {
                        nodes = Integer.parseInt(part[j]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (part[j].startsWith("ppn") && (ppnDef = part[j].split("=")).length > 1) {
                        ppn = Integer.parseInt(ppnDef[1]);
                    }
                    ++j;
                }
                cores += nodes * ppn;
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return "" + cores;
    }

    private static String denormalize(String content) {
        content = content.replaceAll("\\\\", "\\\\\\\\");
        content = content.replaceAll(ConfigUtils.LINE_SEP, "\\\\n");
        content = content.replaceAll("\\t", "\\\\t");
        content = content.replaceAll(" ", "\\\\s");
        return content;
    }

    private static String extractPBSAttributeName(String line) throws ParseException {
        StringBuffer name = new StringBuffer();
        boolean firstAt = false;
        boolean lastAt = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            switch (c) {
                case '@': {
                    if (firstAt) {
                        lastAt = true;
                    }
                    firstAt = true;
                    break;
                }
                default: {
                    if (!firstAt) break;
                    name.append(c);
                }
            }
            if (lastAt) break;
            ++i;
        }
        if (!firstAt || !lastAt) {
            throw new ParseException(String.valueOf(line) + org.eclipse.ptp.rm.pbs.ui.messages.Messages.PBSBatchScriptTemplate_parseError, 0);
        }
        return name.toString();
    }
}

