/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class WidgetUtils {
    public static final Color DKBL = Display.getDefault().getSystemColor(10);
    public static final Color DKMG = Display.getDefault().getSystemColor(12);
    public static final Color DKRD = Display.getDefault().getSystemColor(4);

    private WidgetUtils() {
    }

    public static TableColumn addTableColumn(TableViewer viewer, String columnName, int style, SelectionListener l) {
        Table t = viewer.getTable();
        TableColumn c = new TableColumn(t, style);
        c.setText(columnName);
        if (l != null) {
            c.addSelectionListener(l);
        }
        return c;
    }

    public static Group createAnonymousNonFillingGroup(Composite parent, int columns) {
        GridData data = new GridData(256);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        data.verticalAlignment = 16384;
        data.grabExcessVerticalSpace = false;
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.verticalSpacing = 1;
        Group group = new Group(parent, 40);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        return group;
    }

    public static Button createButton(Composite parent, String buttonText, Image image, int style, int colSpan, boolean fill, SelectionListener l) {
        Button button = new Button(parent, style);
        button.setText(buttonText);
        if (image != null) {
            button.setImage(image);
        }
        if (l != null) {
            button.addSelectionListener(l);
        }
        GridData data = new GridData();
        if (fill) {
            data.horizontalAlignment = 4;
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = colSpan;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Composite createComposite(Composite parent, int columns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.verticalSpacing = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static Group createFillingGroup(Composite parent, String text, int columns, int colSpan, boolean verticalFill) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = verticalFill;
        if (colSpan != -1) {
            data.horizontalSpan = colSpan;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.verticalSpacing = 9;
        Group group = new Group(parent, 40);
        if (text != null) {
            group.setText(text);
        }
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        return group;
    }

    public static Table createFillingTable(Composite parent, int numColumns, int suggestedWidth, int colSpan, int tableStyle) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 200;
        data.horizontalSpan = colSpan;
        data.heightHint = 150;
        Table t = new Table(parent, tableStyle);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        t.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < numColumns) {
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(suggestedWidth / numColumns));
            ++i;
        }
        t.setLayout((Layout)layout);
        return t;
    }

    public static Combo createItemCombo(Composite container, String labelString, String[] items, String initial, String tooltip, boolean fill, ModifyListener listener, int colSpan) {
        if (labelString != null) {
            Label label = new Label(container, 0);
            label.setText(labelString);
            if (tooltip != null) {
                label.setToolTipText(tooltip);
            }
        }
        GridData data = new GridData();
        if (fill) {
            data.horizontalAlignment = 4;
        }
        data.grabExcessHorizontalSpace = false;
        if (colSpan != -1) {
            data.horizontalSpan = colSpan;
        }
        data.widthHint = 100;
        Combo combo = new Combo(container, 2048);
        combo.setItems(items);
        combo.setLayoutData((Object)data);
        if (initial != null) {
            combo.setText(initial);
        }
        if (listener != null) {
            combo.addModifyListener(listener);
        }
        return combo;
    }

    public static Label createLabel(Composite container, String text, int style, int colSpan) {
        GridData data = new GridData();
        data.horizontalSpan = colSpan;
        Label label = new Label(container, style);
        if (text == null) {
            text = "";
        }
        label.setText(text.trim());
        label.setLayoutData((Object)data);
        return label;
    }

    public static Spinner createSpinner(Composite container, String labelString, int min, int max, int initial, int colSpan, boolean fill, ModifyListener listener) {
        GridData data;
        if (labelString != null) {
            data = new GridData();
            Label label = new Label(container, 0);
            label.setText(labelString);
            label.setLayoutData((Object)data);
        }
        data = new GridData();
        if (fill) {
            data.horizontalAlignment = 4;
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = colSpan;
        Spinner s = new Spinner(container, 0);
        s.setMaximum(max);
        s.setMinimum(min);
        s.setSelection(initial);
        s.setLayoutData((Object)data);
        if (listener != null) {
            s.addModifyListener(listener);
        }
        return s;
    }

    public static Text createText(Composite container, String initialValue, boolean fill, ModifyListener listener, Color color) {
        GridData data = new GridData();
        if (fill) {
            data.horizontalAlignment = 4;
        }
        data.grabExcessHorizontalSpace = true;
        Text text = new Text(container, 2048);
        if (color != null) {
            text.setBackground(color);
        }
        text.setLayoutData((Object)data);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static void errorMessage(Shell s, Throwable e, String message, String title, boolean causeTrace) {
        String append = e == null ? "" : e.getMessage();
        Throwable t = e == null ? null : e.getCause();
        String lineSep = System.getProperty("line.separator");
        if (causeTrace) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (t != null) {
                t.printStackTrace(pw);
                append = sw.toString();
            }
        } else if (t != null) {
            append = t.getMessage();
        }
        MessageDialog.openError((Shell)s, (String)title, (String)(String.valueOf(message) + lineSep + lineSep + append));
    }
}

