/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.navigation;

import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.navigation.INavigationService;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class RemoteNavigationService
extends AbstractRemoteService
implements INavigationService {
    public RemoteNavigationService(IConnectorService connectorService) {
        super(connectorService);
    }

    public RemoteNavigationService(ICIndexSubsystem subsystem) {
        super(subsystem);
    }

    public OpenDeclarationResult openDeclaration(Scope scope, ITranslationUnit unit, String selectedText, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        ICIndexSubsystem subsystem = this.getSubSystem();
        subsystem.checkProject(unit.getCProject().getProject(), monitor);
        if (unit instanceof TranslationUnit) {
            RemoteScannerInfo scannerInfo = unit.getResource() == null ? RemoteIndexerInfoProviderFactory.getScannerInfo((IResource)unit.getCProject().getProject()) : RemoteIndexerInfoProviderFactory.getScannerInfo(unit.getResource());
            Map<String, String> langaugeProperties = null;
            try {
                String languageId = unit.getLanguage().getId();
                IProject project = unit.getCProject().getProject();
                langaugeProperties = RemoteIndexerInfoProviderFactory.getLanguageProperties(languageId, project);
            }
            catch (Exception e) {
                RDTLog.logError(e);
            }
            ((TranslationUnit)unit).setASTContext(scannerInfo, langaugeProperties);
        }
        return subsystem.openDeclaration(scope, unit, selectedText, selectionStart, selectionLength, monitor);
    }
}

