/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.util.NoSuchElementException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;

public class LongString
implements IString {
    private final Database db;
    private final long record;
    private int hash;
    private static final int LENGTH = 0;
    private static final int NEXT1 = 4;
    private static final int CHARS1 = 8;
    private static final int NUM_CHARS1 = 2043;
    private static final int NEXTN = 0;
    private static final int CHARSN = 4;
    private static final int NUM_CHARSN = 2045;

    public LongString(Database db, long record) {
        this.db = db;
        this.record = record;
    }

    private long createString(int length, IWriter writer) throws CoreException {
        long firstRecord = this.db.malloc(4094);
        int start = 0;
        this.db.putInt(firstRecord, length);
        writer.writeChars(start, 2043, firstRecord + 8L);
        long lastNext = firstRecord + 4L;
        start += 2043;
        while (length - start > 2045) {
            long nextRecord = this.db.malloc(4094);
            this.db.putRecPtr(lastNext, nextRecord);
            writer.writeChars(start, 2045, nextRecord + 4L);
            start += 2045;
            lastNext = nextRecord + 0L;
        }
        long finalRecord = this.db.malloc(4 + (length -= start) * 2);
        this.db.putRecPtr(lastNext, finalRecord);
        writer.writeChars(start, length, finalRecord + 4L);
        return firstRecord;
    }

    public LongString(Database db, final String string) throws CoreException {
        this.db = db;
        this.record = this.createString(string.length(), new IWriter(){

            public void writeChars(int start, int length, long p) throws CoreException {
                int i = start;
                while (i < start + length) {
                    LongString.this.db.putChar(p, string.charAt(i));
                    p += 2L;
                    ++i;
                }
            }
        });
    }

    public LongString(Database db, final char[] chars) throws CoreException {
        this.db = db;
        this.record = this.createString(chars.length, new IWriter(){

            public void writeChars(int start, int length, long p) throws CoreException {
                int i = start;
                while (i < start + length) {
                    LongString.this.db.putChar(p, chars[i]);
                    p += 2L;
                    ++i;
                }
            }
        });
    }

    public long getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        int length = this.db.getInt(this.record + 0L) - 2043;
        long nextRecord = this.db.getRecPtr(this.record + 4L);
        this.db.free(this.record);
        while (length > 2045) {
            length -= 2045;
            long nextnext = this.db.getRecPtr(nextRecord + 0L);
            this.db.free(nextRecord);
            nextRecord = nextnext;
        }
        this.db.free(nextRecord);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof LongString) {
                LongString lstr = (LongString)obj;
                if (this.db == lstr.db && this.record == lstr.record) {
                    return true;
                }
                if (this.compare(lstr, true) != 0) return false;
                return true;
            }
            if (obj instanceof char[]) {
                if (this.compare((char[])obj, true) != 0) return false;
                return true;
            }
            if (!(obj instanceof String)) return false;
            if (this.compare((String)obj, true) != 0) return false;
            return true;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            try {
                int length = this.db.getInt(this.record + 0L);
                HashCodeComputer hcc = new HashCodeComputer();
                this.readChars(length, hcc);
                this.hash = h = hcc.getHashcode();
            }
            catch (CoreException coreException) {}
        }
        return h;
    }

    public int compare(IString string, boolean caseSensitive) throws CoreException {
        if (string instanceof LongString) {
            return this.compare((LongString)string, caseSensitive);
        }
        if (string instanceof ShortString) {
            return this.compare((ShortString)string, caseSensitive);
        }
        throw new IllegalArgumentException();
    }

    public int compare(char[] other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int i2 = 0;
        int n2 = other.length;
        while (i1.hasNext() && i2 < n2) {
            int cmp = ShortString.compareChars(i1.next(), other[i2], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i2;
        }
        if (!i1.hasNext() && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(ShortString other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int index2 = 0;
        int length2 = other.getLength();
        while (i1.hasNext() && index2 < length2) {
            int cmp = ShortString.compareChars(i1.next(), other.charAt(index2), caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++index2;
        }
        if (!i1.hasNext() && index2 != length2) {
            return -1;
        }
        if (index2 == length2 && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(LongString other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        CharIterator i2 = other.new CharIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int cmp = ShortString.compareChars(i1.next(), i2.next(), caseSensitive);
            if (cmp == 0) continue;
            return cmp;
        }
        if (!i1.hasNext() && i2.hasNext()) {
            return -1;
        }
        if (!i2.hasNext() && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(String other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int i2 = 0;
        int n2 = other.length();
        while (i1.hasNext() && i2 < n2) {
            int cmp = ShortString.compareChars(i1.next(), other.charAt(i2), caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i2;
        }
        if (!i1.hasNext() && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int comparePrefix(char[] other, boolean caseSensitive) throws CoreException {
        CharIterator i1 = new CharIterator();
        int i2 = 0;
        int n2 = other.length;
        while (i1.hasNext() && i2 < n2) {
            int cmp = ShortString.compareChars(i1.next(), other[i2], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i2;
        }
        if (!i1.hasNext() && i2 != n2) {
            return -1;
        }
        return 0;
    }

    private void readChars(int length, IReader reader) throws CoreException {
        int i;
        long p = this.record + 8L;
        int i2 = 0;
        while (i2 < 2043) {
            reader.appendChar(this.db.getChar(p));
            p += 2L;
            ++i2;
        }
        length -= 2043;
        long nextRecord = this.db.getRecPtr(this.record + 4L);
        while (length > 2045) {
            p = nextRecord + 4L;
            i = 0;
            while (i < 2045) {
                reader.appendChar(this.db.getChar(p));
                p += 2L;
                ++i;
            }
            length -= 2045;
            nextRecord = this.db.getRecPtr(nextRecord + 0L);
        }
        p = nextRecord + 4L;
        i = 0;
        while (i < length) {
            reader.appendChar(this.db.getChar(p));
            p += 2L;
            ++i;
        }
    }

    public char[] getChars() throws CoreException {
        int length = this.db.getInt(this.record + 0L);
        final char[] chars = new char[length];
        this.readChars(length, new IReader(){
            int cp = 0;

            public void appendChar(char c) {
                chars[this.cp++] = c;
            }
        });
        return chars;
    }

    public String getString() throws CoreException {
        int length = this.db.getInt(this.record + 0L);
        final StringBuffer buffer = new StringBuffer(length);
        this.readChars(length, new IReader(){

            public void appendChar(char c) {
                buffer.append(c);
            }
        });
        return buffer.toString();
    }

    public int compareCompatibleWithIgnoreCase(IString string) throws CoreException {
        int cmp = this.compare(string, false);
        return cmp == 0 ? this.compare(string, true) : cmp;
    }

    public int compareCompatibleWithIgnoreCase(char[] chars) throws CoreException {
        int cmp = this.compare(chars, false);
        return cmp == 0 ? this.compare(chars, true) : cmp;
    }

    private class CharIterator {
        long p;
        int count;
        int length;

        public CharIterator() throws CoreException {
            this.p = LongString.this.record + 8L;
            this.length = LongString.this.db.getInt(LongString.this.record + 0L);
        }

        public char next() throws CoreException {
            char result = LongString.this.db.getChar(this.p);
            this.p += 2L;
            ++this.count;
            if (this.count > this.length) {
                throw new NoSuchElementException();
            }
            if (this.count == 2043) {
                this.p = LongString.this.db.getRecPtr(LongString.this.record + 4L) + 4L;
            }
            if (this.count > 2043 && (this.count - 2043) % 2045 == 0) {
                this.p = LongString.this.db.getRecPtr(this.p - 4090L - 4L) + 4L;
            }
            return result;
        }

        public boolean hasNext() {
            return this.count < this.length;
        }
    }

    private class HashCodeComputer
    implements IReader {
        private int fHashcode = 0;

        private HashCodeComputer() {
        }

        public int getHashcode() {
            return this.fHashcode;
        }

        public void appendChar(char c) {
            this.fHashcode = 31 * this.fHashcode + c;
        }
    }

    private static interface IReader {
        public void appendChar(char var1);
    }

    private static interface IWriter {
        public void writeChars(int var1, int var2, long var3) throws CoreException;
    }
}

