/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.client;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.ptp.proxy.event.IProxyEvent;

public class ProxyEventQueue {
    private ConcurrentLinkedQueue<IProxyEvent> eventQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IProxyEvent> priorityEventQueue = new ConcurrentLinkedQueue();

    public void addPriorityProxyEvent(IProxyEvent e) {
        this.priorityEventQueue.add(e);
        this.notifyForEvent();
    }

    public void addProxyEvent(IProxyEvent e) {
        this.eventQueue.add(e);
        this.notifyForEvent();
    }

    public IProxyEvent getProxyEvent() {
        IProxyEvent event;
        if (this.priorityEventQueue.size() == 0 && this.eventQueue.size() == 0) {
            this.waitForEvent();
        }
        if ((event = this.priorityEventQueue.poll()) != null) {
            return event;
        }
        event = this.eventQueue.poll();
        if (event != null) {
            return event;
        }
        return null;
    }

    private synchronized void notifyForEvent() {
        this.notify();
    }

    public int size() {
        return this.priorityEventQueue.size() + this.eventQueue.size();
    }

    private synchronized void waitForEvent() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }
}

