/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteBuildServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RemoteProjectContentsLocationArea {
    private static final String FILE_SCHEME = "file";
    private IProject fExistingProject;
    private final IErrorMessageReporter fErrorReporter;
    private RemoteBuildServiceProvider fProvider;
    private final Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private IRemoteServices fSelectedProvider;
    private final Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private IRemoteConnection fSelectedConnection;
    private String fProjectName = "";
    private Button fBrowseButton;
    private Button fNewConnectionButton;
    private Combo fProviderCombo;
    private Combo fConnectionCombo;
    private Text fLocationText;

    public RemoteProjectContentsLocationArea(IErrorMessageReporter reporter, Composite composite) {
        this.fErrorReporter = reporter;
        this.createContents(composite);
    }

    public String checkValidLocation() {
        URI projectPath;
        String locationFieldContents = this.fLocationText.getText();
        if (locationFieldContents.length() == 0) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        URI newPath = this.getProjectLocationURI();
        if (newPath == null) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
        }
        if (this.fExistingProject != null && (projectPath = this.fExistingProject.getLocationURI()) != null && URIUtil.equals((URI)projectPath, (URI)newPath)) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationIsSelf;
        }
        return null;
    }

    public Button[] getButtons() {
        return new Button[]{this.fBrowseButton, this.fNewConnectionButton};
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    public String getProjectLocation() {
        return this.fLocationText.getText();
    }

    public URI getProjectLocationURI() {
        return this.fSelectedProvider.getFileManager(this.fSelectedConnection).toURI(this.fLocationText.getText());
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fSelectedConnection;
    }

    public IRemoteServices getRemoteServices() {
        return this.fSelectedProvider;
    }

    public boolean isDefault() {
        return false;
    }

    public void setExistingProject(IProject existingProject) {
        this.fProjectName = existingProject.getName();
        this.fExistingProject = existingProject;
    }

    public void updateProjectName(String newName) {
        this.fProjectName = newName;
        if (this.isDefault()) {
            this.fLocationText.setText(this.getDefaultPathDisplayString());
        }
    }

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fConnectionCombo.getShell(), this.fSelectedConnection);
        }
    }

    private String getDefaultPathDisplayString() {
        if (this.getRemoteConnection().isOpen()) {
            IRemoteFileManager fileMgr = this.getRemoteServices().getFileManager(this.getRemoteConnection());
            URI defaultURI = fileMgr.toURI(this.getRemoteConnection().getWorkingDirectory());
            if (defaultURI != null && defaultURI.getScheme().equals(FILE_SCHEME)) {
                return Platform.getLocation().append(this.fProjectName).toOSString();
            }
            if (defaultURI == null) {
                return "";
            }
            return new Path(defaultURI.getPath()).append(this.fProjectName).toOSString();
        }
        return "";
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedProvider).getUIConnectionManager();
        return connectionManager;
    }

    private void handleConnectionSelected() {
        int selectionIndex = this.fConnectionCombo.getSelectionIndex();
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.fLocationText.setText(this.getDefaultPathDisplayString());
    }

    private void handleServicesSelected() {
        int selectionIndex = this.fProviderCombo.getSelectionIndex();
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
        this.populateConnectionCombo(this.fConnectionCombo);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.handleConnectionSelected();
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        connectionCombo.removeAll();
        IRemoteConnection[] connections = this.fSelectedProvider.getConnectionManager().getConnections();
        int toSelect = 0;
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            ++k;
        }
        connectionCombo.select(toSelect);
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(toSelect);
    }

    private void updateNewConnectionButtonEnabled(Button button) {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        button.setEnabled(connectionManager != null);
    }

    protected Control createContents(Composite parent) {
        Group container = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        Label providerLabel = new Label((Composite)container, 16384);
        providerLabel.setText("Remote Provider:");
        this.fProviderCombo = new Combo((Composite)container, 12);
        this.fProviderCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteProjectContentsLocationArea.this.handleServicesSelected();
            }
        });
        IRemoteServices[] providers = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
        int toSelect = 0;
        int k = 0;
        while (k < providers.length) {
            this.fProviderCombo.add(providers[k].getName(), k);
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            ++k;
        }
        this.fProviderCombo.select(toSelect);
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(toSelect);
        Label connectionLabel = new Label((Composite)container, 16384);
        connectionLabel.setText("Connection:");
        this.fConnectionCombo = new Combo((Composite)container, 12);
        this.fConnectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fConnectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteProjectContentsLocationArea.this.handleConnectionSelected();
            }
        });
        this.populateConnectionCombo(this.fConnectionCombo);
        this.fNewConnectionButton = new Button((Composite)container, 8);
        this.fNewConnectionButton.setText("New...");
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.fNewConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = RemoteProjectContentsLocationArea.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(RemoteProjectContentsLocationArea.this.fNewConnectionButton.getShell());
                }
                RemoteProjectContentsLocationArea.this.populateConnectionCombo(RemoteProjectContentsLocationArea.this.fConnectionCombo);
            }
        });
        Label locationLabel = new Label((Composite)container, 16384);
        locationLabel.setText("Location:");
        this.fLocationText = new Text((Composite)container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fLocationText.setLayoutData((Object)gd);
        this.fLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteProjectContentsLocationArea.this.fErrorReporter.reportError(RemoteProjectContentsLocationArea.this.checkValidLocation(), false);
            }
        });
        this.fBrowseButton = new Button((Composite)container, 8);
        this.fBrowseButton.setText("Browse...");
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteProjectContentsLocationArea.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    RemoteProjectContentsLocationArea.this.checkConnection();
                    if (RemoteProjectContentsLocationArea.this.fSelectedConnection.isOpen() && (remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(RemoteProjectContentsLocationArea.this.fSelectedProvider)) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(RemoteProjectContentsLocationArea.this.fSelectedConnection);
                        String correctPath = RemoteProjectContentsLocationArea.this.fLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(RemoteProjectContentsLocationArea.this.fLocationText.getShell(), "Project Location (" + RemoteProjectContentsLocationArea.this.fSelectedConnection.getName() + ")", correctPath, 0);
                        if (selectedPath != null) {
                            RemoteProjectContentsLocationArea.this.fLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
        return container;
    }

    protected void okPressed() {
        this.fProvider.setRemoteToolsProviderID(this.fSelectedProvider.getId());
        this.fProvider.setRemoteToolsConnection(this.fSelectedConnection);
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1, boolean var2);
    }
}

