/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.util.List;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringSetAttributeDefinition;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringSetAttribute
extends AbstractAttribute<String, StringSetAttribute, StringSetAttributeDefinition> {
    private String value;

    public StringSetAttribute(StringSetAttributeDefinition definition) throws IllegalValueException {
        super(definition);
        this.setValueAsString(definition.getDefaultValue());
    }

    public StringSetAttribute(StringSetAttributeDefinition definition, String valueIn) throws IllegalValueException {
        super(definition);
        this.setValueAsString(valueIn);
    }

    @Override
    public String getValue() {
        return this.getValueAsString();
    }

    @Override
    public synchronized String getValueAsString() {
        return this.value;
    }

    public synchronized int getValueIndex() {
        return ((StringSetAttributeDefinition)this.getDefinition()).getValues().indexOf(this.value);
    }

    @Override
    public boolean isValid(String valueIn) {
        List<String> values = ((StringSetAttributeDefinition)this.getDefinition()).getValues();
        boolean isValid = values.contains(valueIn);
        return isValid;
    }

    @Override
    public void setValue(String value) throws IllegalValueException {
        this.setValueAsString(value);
    }

    @Override
    public synchronized void setValueAsString(String valueIn) throws IllegalValueException {
        if (!this.isValid(valueIn)) {
            throw new IllegalValueException(String.valueOf(Messages.StringSetAttribute_0) + valueIn + Messages.StringSetAttribute_1 + ((StringSetAttributeDefinition)this.getDefinition()).getName());
        }
        this.value = valueIn;
    }

    @Override
    protected StringSetAttribute doCopy() {
        try {
            return new StringSetAttribute((StringSetAttributeDefinition)this.getDefinition(), this.value);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int doCompareTo(StringSetAttribute other) {
        return this.getValueIndex() - other.getValueIndex();
    }

    @Override
    protected synchronized boolean doEquals(StringSetAttribute other) {
        return this.value.equals(other.value);
    }

    @Override
    protected synchronized int doHashCode() {
        return this.value.hashCode();
    }
}

