/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.Map;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;

public class ExecutionObserver
extends Thread {
    private final Connection fConnection;
    private boolean fCanceled = false;

    public ExecutionObserver(Connection connection) {
        super(Messages.ExecutionObserver_ExecutionObserver_RemoteCommandObserver);
        this.fConnection = connection;
    }

    public void cancel() {
        this.fCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.fCanceled) {
            Connection connection;
            KillableExecution finished = null;
            if (this.fConnection.isConnected() && this.fConnection.getActiveProcessTable() != null) {
                connection = this.fConnection;
                synchronized (connection) {
                    for (Map.Entry<Integer, KillableExecution> entry : this.fConnection.getActiveProcessTable().entrySet()) {
                        if (entry.getValue().isRunning()) continue;
                        finished = entry.getValue();
                        break;
                    }
                }
            }
            if (finished != null) {
                finished.notifyFinish();
                finished = null;
                continue;
            }
            connection = this.fConnection;
            synchronized (connection) {
                try {
                    this.fConnection.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

