/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.SyntaxException;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.ASTLexerFactory;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.sourceform.ISourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorVPGTask;
import org.eclipse.photran.internal.ui.editor_vpg.Messages;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGJob;

public class FortranEditorTasks {
    private Parser parser = new Parser();
    private FortranEditor editor;
    private Runner runner;
    private final Set<IFortranEditorASTTask> astTasks = new HashSet<IFortranEditorASTTask>();
    private final Set<IFortranEditorVPGTask> vpgTasks = new HashSet<IFortranEditorVPGTask>();

    public static FortranEditorTasks instance(FortranEditor editor) {
        if (editor.reconcilerTasks == null) {
            editor.reconcilerTasks = new FortranEditorTasks(editor);
        }
        return (FortranEditorTasks)editor.reconcilerTasks;
    }

    private FortranEditorTasks(FortranEditor editor) {
        this.editor = editor;
        editor.reconcilerTasks = this;
        this.runner = new Runner();
    }

    public synchronized void addASTTask(IFortranEditorASTTask task) {
        this.astTasks.add(task);
    }

    public synchronized void addVPGTask(IFortranEditorVPGTask task) {
        this.vpgTasks.add(task);
    }

    public synchronized void removeASTTask(IFortranEditorASTTask task) {
        this.astTasks.remove(task);
    }

    public synchronized void removeVPGTask(IFortranEditorVPGTask task) {
        this.vpgTasks.remove(task);
    }

    public Runner getRunner() {
        return this.runner;
    }

    public class Runner {
        protected DefinitionMap<Definition> defMap = null;
        protected PhotranVPG vpg = PhotranVPG.getInstance();
        protected Job dispatchASTTasksJob = null;
        protected VPGJob<IFortranAST, Token> updateVPGJob = null;
        protected Job dispatchVPGTasksJob = null;
        protected IFortranAST vpgAST = null;

        public void runTasks() {
            this.runTasks(true);
        }

        public void runTasks(boolean runVPGTasks) {
            if (FortranEditorTasks.this.editor == null) {
                return;
            }
            String vpgEnabledProperty = new SearchPathProperties().getProperty(FortranEditorTasks.this.editor.getIFile(), "EnableVPG");
            if (vpgEnabledProperty != null && vpgEnabledProperty.equals("true")) {
                this.runASTTasks();
                if (runVPGTasks) {
                    this.runVPGTasks();
                }
            }
        }

        private void runASTTasks() {
            if (this.dispatchASTTasksJob != null) {
                return;
            }
            this.dispatchASTTasksJob = new DispatchASTTasksJob();
            this.dispatchASTTasksJob.setPriority(50);
            this.dispatchASTTasksJob.schedule();
        }

        private void runVPGTasks() {
            if (this.updateVPGJob != null || this.dispatchVPGTasksJob != null) {
                return;
            }
            this.vpgAST = null;
            this.updateVPGJob = new UpdateVPGJob();
            this.updateVPGJob.setPriority(50);
            this.updateVPGJob.schedule();
        }

        private final class DispatchASTTasksJob
        extends Job {
            private DispatchASTTasksJob() {
                super(Messages.FortranEditorTasks_UpdatingFortranEditorWithNewParseInfo);
            }

            private ISourceForm determineSourceForm() {
                ISourceForm sourceForm = SourceForm.of((IFile)FortranEditorTasks.this.editor.getIFile());
                if (FortranEditorTasks.this.editor.getIFile() == null || FortranEditorTasks.this.editor.getIFile().getProject() == null) {
                    return sourceForm.configuredWith((Object)new IncludeLoaderCallback(FortranEditorTasks.this.editor.getIFile().getProject()));
                }
                return sourceForm;
            }

            protected IStatus run(IProgressMonitor monitor) {
                this.parseThenRunASTTasks();
                Runner.this.dispatchASTTasksJob = null;
                return Status.OK_STATUS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void parseThenRunASTTasks() {
                block9: {
                    try {
                        if (FortranEditorTasks.this.editor.getDocumentProvider() == null) break block9;
                        this.debug("DispatchASTTasksJob#parseThenRunASTTasks():");
                        String editorContents = FortranEditorTasks.this.editor.getDocumentProvider().getDocument((Object)FortranEditorTasks.this.editor.getEditorInput()).get();
                        long start = System.currentTimeMillis();
                        ISourceForm sourceForm = this.determineSourceForm();
                        IAccumulatingLexer lexer = new ASTLexerFactory().createLexer((Reader)new StringReader(editorContents), FortranEditorTasks.this.editor.getIFile(), FortranEditorTasks.this.editor.getIFile().getName(), sourceForm);
                        this.debug("    createLexer:\t" + (System.currentTimeMillis() - start) + " ms");
                        start = System.currentTimeMillis();
                        ASTExecutableProgramNode astRootNode = FortranEditorTasks.this.parser.parse(lexer);
                        this.debug("    parse:\t" + (System.currentTimeMillis() - start) + " ms");
                        if (astRootNode == null) {
                            return;
                        }
                        HashSet<IFortranEditorASTTask> tasksToRemove = new HashSet<IFortranEditorASTTask>();
                        FortranEditorTasks fortranEditorTasks = FortranEditorTasks.instance(FortranEditorTasks.this.editor);
                        synchronized (fortranEditorTasks) {
                            start = System.currentTimeMillis();
                            for (IFortranEditorASTTask task : FortranEditorTasks.instance(FortranEditorTasks.this.editor).astTasks) {
                                long start2 = System.currentTimeMillis();
                                if (!task.handle(astRootNode, lexer.getTokenList(), Runner.this.defMap)) {
                                    tasksToRemove.add(task);
                                }
                                this.debug("        Task " + task.getClass().getSimpleName() + ":\t" + (System.currentTimeMillis() - start2) + " ms");
                            }
                            this.debug("    Total Running Tasks:\t" + (System.currentTimeMillis() - start) + " ms");
                        }
                        FortranEditorTasks.instance(FortranEditorTasks.this.editor).astTasks.removeAll(tasksToRemove);
                    }
                    catch (SyntaxException syntaxException) {
                    }
                    catch (Throwable e) {
                        FortranUIPlugin.log((String)Messages.FortranEditorTasks_ErrorRunningASTTasks, (Throwable)e);
                    }
                }
            }

            private void debug(String string) {
                PhotranVPG.getInstance().debug(string, null);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class UpdateVPGJob
        extends VPGJob<IFortranAST, Token> {
            private UpdateVPGJob() {
                super(Messages.FortranEditorTasks_UpdatingFortranEditorWithNewAnalysisInfo);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                Runner.this.vpgAST = (IFortranAST)Runner.this.vpg.acquireTransientAST(PhotranVPG.getFilenameForIFile((IFile)FortranEditorTasks.this.editor.getIFile()));
                Runner.this.updateVPGJob = null;
                if (Runner.this.vpgAST != null) {
                    HashSet vpgTasks;
                    FortranEditorTasks fortranEditorTasks = FortranEditorTasks.instance(FortranEditorTasks.this.editor);
                    synchronized (fortranEditorTasks) {
                        vpgTasks = new HashSet(FortranEditorTasks.instance(FortranEditorTasks.this.editor).vpgTasks);
                    }
                    Runner.this.defMap = this.createDefMap();
                    for (IFortranEditorVPGTask task : vpgTasks) {
                        task.handle(FortranEditorTasks.this.editor.getIFile(), Runner.this.vpgAST, Runner.this.defMap);
                    }
                }
                return Status.OK_STATUS;
            }

            private DefinitionMap<Definition> createDefMap() {
                return new DefinitionMap<Definition>(Runner.this.vpgAST){

                    @Override
                    protected Definition map(String qualifiedName, Definition def) {
                        return def;
                    }
                };
            }
        }
    }
}

