/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.feedback;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.etfw.feedback.messages.Messages;
import org.eclipse.ptp.etfw.feedback.obj.IFeedbackItem;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerManager {
    private static final boolean traceOn = false;
    String srcTempPathname = "/Users/beth/ews/runtime-compiler-xform-test/MyHPCSTproject/src";
    static String path;
    static String filename;
    private static MarkerManager instance;
    private static final String SLASH;
    private static int counter;

    static {
        SLASH = System.getProperty("file.separator");
        counter = 0;
    }

    public void removeMarkers(IResource res, String markerID) {
        try {
            res.deleteMarkers(markerID, true, 2);
        }
        catch (CoreException e) {
            System.out.println("Error deleting markers on " + res.getName());
            e.printStackTrace();
        }
    }

    public String getSrcPath(File file) {
        String docpath = null;
        try {
            docpath = file.getAbsolutePath();
            int indx = docpath.lastIndexOf(SLASH);
            String pathname = docpath.substring(0, indx);
            indx = pathname.lastIndexOf(SLASH);
            pathname = pathname.substring(0, indx);
            pathname = String.valueOf(pathname) + SLASH + "src";
            return pathname;
        }
        catch (Exception exception) {
            System.out.println("Exception parsing src path from " + docpath);
            return null;
        }
    }

    public String stripFileNameOnly(String filename) {
        int indx = filename.lastIndexOf(SLASH);
        if (indx >= 0) {
            filename = filename.substring(indx + 1);
        } else {
            String otherSlash = "/";
            if (SLASH.equals(otherSlash)) {
                otherSlash = "\\";
            }
            StringBuffer newf = new StringBuffer();
            int len = filename.length();
            try {
                int i = 0;
                while (i < len) {
                    String next = filename.substring(i, i + 1);
                    if (next.equals(otherSlash)) {
                        newf.append(SLASH);
                    } else {
                        newf.append(next);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            indx = newf.lastIndexOf(SLASH);
            if (indx >= 0) {
                filename = newf.substring(indx + 1);
            }
        }
        return filename;
    }

    String getStrAttr(NamedNodeMap attribs, String attrName) {
        Node node = attribs.getNamedItem(attrName);
        if (node == null) {
            return "";
        }
        String val = node.getNodeValue();
        return val;
    }

    int getIntAttr(NamedNodeMap attribs, String attrName) {
        Node node = attribs.getNamedItem(attrName);
        String val = node.getNodeValue();
        int intVal = this.toInt(val);
        return intVal;
    }

    public int toInt(String str) {
        int value = 0;
        try {
            value = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            System.out.println("NumberFormatException(" + str + "): " + e.getMessage());
            value = 0;
        }
        return value;
    }

    public IResource getResource(String pathname, String filename) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(String.valueOf(pathname) + SLASH + filename));
        return file;
    }

    public IResource getResource(String filename) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(filename));
        return file;
    }

    public Map<String, Object> createCommonMarkers(String itemID, String name, String parentID, String filename, String pathname, int lineNo, String desc) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("itemID", itemID);
        attrs.put("priority", new Integer(1));
        attrs.put("name", name);
        attrs.put("filename", filename);
        attrs.put("parent", parentID);
        attrs.put("functionCallee", "");
        attrs.put("pathname", pathname);
        attrs.put("lineNumber", new Integer(lineNo));
        attrs.put("description", desc);
        attrs.put("LoopId", "");
        return attrs;
    }

    public void createMarker(IResource resource, Map<String, Object> attrs, String markerID) {
        try {
            MarkerUtilities.createMarker((IResource)resource, attrs, (String)markerID);
        }
        catch (CoreException e) {
            System.out.println("Error creating Xform marker: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void createMarkers(List<IFeedbackItem> itemlist, String markerID) {
        boolean dbgTags = true;
        String f1 = itemlist.get(0).getFile();
        IResource res1 = this.getResource(f1);
        try {
            this.removeMarkers(res1, markerID);
        }
        catch (Exception e) {
            System.out.println("Error deleting markers on file: " + res1);
            e.printStackTrace();
        }
        String parentID = "";
        itemlist.get(0);
        itemlist.size();
        for (IFeedbackItem item : itemlist) {
            String filename = item.getFile();
            String name = item.getName();
            int lineNo = item.getLineNoStart();
            String desc = item.getDescription();
            String itemID = item.getID();
            parentID = item.getParentID();
            String pathname = "";
            if (filename.contains("/")) {
                Path path = new Path(filename);
                pathname = path.removeLastSegments(1).toString();
                filename = path.segment(path.segmentCount() - 1);
            }
            Map<String, Object> attrs = this.createCommonMarkers(itemID, name, parentID, filename, pathname, lineNo, desc);
            IResource resource = this.getResource(pathname, filename);
            this.createMarker(resource, attrs, markerID);
            if (!item.hasChildren()) continue;
            List<IFeedbackItem> kids = item.getChildren();
            for (IFeedbackItem kid : kids) {
                int uid;
                String parentid = item.getID();
                String namePrefix = "";
                String kname = kid.getName();
                if (dbgTags) {
                    kname = String.valueOf(namePrefix) + kname;
                }
                if (dbgTags) {
                    kname = String.valueOf(kname) + " parent=" + parentid;
                }
                ++counter;
                String uidStr = Integer.toString(uid);
                attrs = this.createCommonMarkers(uidStr, kname, parentid, filename, pathname, lineNo, kid.getDescription());
                this.createMarker(resource, attrs, markerID);
                boolean gkids = kid.hasChildren();
                if (!gkids) continue;
                List<IFeedbackItem> gkidItems = kid.getChildren();
                Iterator<IFeedbackItem> iterator = gkidItems.iterator();
                while (iterator.hasNext()) {
                    IFeedbackItem gkid;
                    IFeedbackItem gki = gkid = iterator.next();
                    String gkNamePrefix = Messages.MarkerManager_solution;
                    attrs = this.createCommonMarkers(gki.getID(), String.valueOf(gkNamePrefix) + gki.getName(), uidStr, filename, this.srcTempPathname, lineNo, gki.getDescription());
                    this.createMarker(resource, attrs, markerID);
                }
            }
        }
    }
}

