/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.AbstractPDOMIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMRebuildTask;
import org.eclipse.ptp.internal.rdt.core.index.IRemoteFastIndexerListener;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerTask;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFastIndexer
extends AbstractPDOMIndexer {
    public static final String ID = "org.eclipse.ptp.rdt.core.RemoteFastIndexer";
    private static List<IRemoteFastIndexerListener> listeners = new LinkedList<IRemoteFastIndexerListener>();

    public IPDOMIndexerTask createTask(ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(this.getProject().getProject());
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (serviceProvider instanceof IIndexServiceProvider) {
            boolean update = !RemoteFastIndexer.isReindex();
            return new RemoteIndexerTask(this, (IIndexServiceProvider)serviceProvider, added, changed, removed, update);
        }
        return null;
    }

    protected static boolean isReindex() {
        StackTraceElement[] stackTrace;
        String pdomRebuildTask = PDOMRebuildTask.class.getName();
        StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            if (frame.getClassName().equals(pdomRebuildTask)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getID() {
        return ID;
    }

    public static void addRemoteFastIndexerListener(IRemoteFastIndexerListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    static Collection<IRemoteFastIndexerListener> getRemoteFastIndexerListeners() {
        return Collections.unmodifiableCollection(listeners);
    }
}

