/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.core.runtime.Assert;

public class CPPASTAmbiguousTemplateArgument
extends ASTAmbiguousNode
implements ICPPASTAmbiguousTemplateArgument {
    private List<IASTNode> fNodes = new ArrayList<IASTNode>(2);

    public CPPASTAmbiguousTemplateArgument(IASTNode ... nodes) {
        IASTNode[] iASTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            if (node instanceof IASTTypeId || node instanceof IASTIdExpression) {
                this.fNodes.add(node);
            } else if (node instanceof ICPPASTPackExpansionExpression) {
                IASTExpression pattern = ((ICPPASTPackExpansionExpression)node).getPattern();
                if (pattern instanceof IASTIdExpression) {
                    this.fNodes.add(node);
                } else {
                    Assert.isLegal((boolean)false, (String)(pattern == null ? "null" : pattern.getClass().getName()));
                }
            } else {
                Assert.isLegal((boolean)false, (String)(node == null ? "null" : node.getClass().getName()));
            }
            ++n2;
        }
    }

    public IASTNode copy() {
        throw new UnsupportedOperationException();
    }

    public IASTNode[] getNodes() {
        return this.fNodes.toArray(new IASTNode[this.fNodes.size()]);
    }

    public void addTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.addNode(typeId);
    }

    public void addIdExpression(IASTIdExpression idExpression) {
        this.assertNotFrozen();
        this.addNode(idExpression);
    }

    public void addIdExpression(IASTExpression idExpression) {
        this.assertNotFrozen();
        this.addNode(idExpression);
    }

    private void addNode(IASTNode node) {
        this.fNodes.add(node);
        node.setParent(this);
        node.setPropertyInParent(ICPPASTTemplateId.TEMPLATE_ID_ARGUMENT);
    }
}

