/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPUnknownScope
implements ICPPInternalUnknownScope {
    private final ICPPUnknownBinding binding;
    private final IASTName scopeName;
    private CharArrayObjectMap map;

    public CPPUnknownScope(ICPPUnknownBinding binding, IASTName name) {
        this.scopeName = name;
        this.binding = binding;
    }

    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    public IName getScopeName() {
        return this.scopeName;
    }

    public IScope getParent() throws DOMException {
        return this.binding.getScope();
    }

    public IBinding[] find(String name) {
        return null;
    }

    public IASTNode getPhysicalNode() {
        return this.scopeName;
    }

    public void addName(IASTName name) {
    }

    public final IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        int idx;
        IBinding result;
        char[] c;
        IBinding[] o;
        boolean type = false;
        boolean function = false;
        if (name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            type = true;
        } else {
            IASTName n = name;
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTTemplateId) {
                n = (IASTName)parent;
                parent = n.getParent();
            }
            if (parent instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
                if (qname.getLastName() != n) {
                    type = true;
                } else {
                    parent = qname.getParent();
                }
            }
            if (!type) {
                if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTConstructorChainInitializer) {
                    type = true;
                } else if (parent instanceof ICPPASTNamedTypeSpecifier) {
                    ICPPASTNamedTypeSpecifier nts = (ICPPASTNamedTypeSpecifier)parent;
                    type = nts.isTypename();
                } else if (parent instanceof ICPPASTUsingDeclaration) {
                    ICPPASTUsingDeclaration ud = (ICPPASTUsingDeclaration)parent;
                    type = ud.isTypename();
                }
                if (!type && parent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                    function = true;
                }
            }
        }
        if (this.map == null) {
            this.map = new CharArrayObjectMap(2);
        }
        if ((o = (IBinding[])this.map.get(c = name.getLookupKey())) == null) {
            o = new IBinding[3];
            this.map.put(c, o);
        }
        if ((result = o[idx = type ? 0 : (function ? 1 : 2)]) == null) {
            result = type ? new CPPUnknownClass(this.binding, name.getSimpleID()) : (function ? new CPPUnknownFunction(this.binding, name.getSimpleID()) : new CPPUnknownBinding(this.binding, name.getSimpleID()));
            o[idx] = result;
        }
        return result;
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(name, resolve, prefixLookup, fileSet, true);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet acceptLocalBindings, boolean checkPointOfDecl) {
        if (prefixLookup) {
            if (this.binding instanceof ICPPDeferredClassInstance) {
                try {
                    ICPPDeferredClassInstance instance = (ICPPDeferredClassInstance)this.binding;
                    IScope scope = instance.getClassTemplate().getCompositeScope();
                    if (scope != null) {
                        return scope.getBindings(name, resolve, prefixLookup, acceptLocalBindings);
                    }
                }
                catch (DOMException exc) {
                    CCorePlugin.log((Throwable)exc);
                }
            }
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        return new IBinding[]{this.getBinding(name, resolve, acceptLocalBindings)};
    }

    public void addBinding(IBinding binding) {
    }

    public ICPPBinding getScopeBinding() {
        return this.binding;
    }

    public String toString() {
        return this.scopeName.toString();
    }

    public void populateCache() {
    }
}

