/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.core.Messages;
import org.eclipse.ptp.remotetools.environment.launcher.data.ISynchronizationRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.RuleFactory;
import org.eclipse.ptp.remotetools.environment.launcher.internal.integration.NullLaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.internal.macros.LaunchVariableManager;
import org.eclipse.ptp.remotetools.environment.launcher.preferences.LaunchPreferences;

public abstract class RemoteLaunchDelegate
extends AbstractCLaunchDelegate {
    protected static final String EMPTY_STRING = "";

    public String getPluginID() {
        return RemoteLauncherPlugin.getUniqueIdentifier();
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    @Deprecated
    protected IPath getLocalDirectoryWithFallback(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.LOCAL_DIRECTORY", null);
        if (location != null && location.length() == 0) {
            ICProject cp = RemoteLaunchDelegate.getCProject((ILaunchConfiguration)configuration);
            if (cp != null) {
                IProject p = cp.getProject();
                return p.getLocation();
            }
            return null;
        }
        Path path = new Path(location);
        if (!path.isAbsolute()) {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
            return folder.getLocation();
        }
        return new Path(location);
    }

    @Deprecated
    public File getValidatedLocalDirectory(ILaunchConfiguration configuration) throws CoreException {
        File directory;
        IPath path = this.getLocalDirectoryWithFallback(configuration);
        if (path == null) {
            this.abort(Messages.RemoteLaunchDelegate_LocalDirectory_Missing, null, 0);
        }
        if (!path.isAbsolute()) {
            this.abort(Messages.RemoteLaunchDelegate_LocalDirectory_MustBeAbsolute, null, 0);
        }
        if (!(directory = path.toFile()).exists()) {
            this.abort(Messages.RemoteLaunchDelegate_LocalDirectory_DoesNotExist, null, 0);
        }
        if (!directory.isDirectory()) {
            this.abort(Messages.RemoteLaunchDelegate_LocalDirectory_IsNotADirectory, null, 0);
        }
        return directory;
    }

    @Deprecated
    public IPath getLocalDirectory(ILaunchConfiguration config) throws CoreException {
        return this.getLocalDirectoryWithFallback(config);
    }

    public IPath getRemoteDirectory(ILaunchConfiguration configuration) throws CoreException {
        String location = null;
        location = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AUTO_REMOTE_DIRECTORY", false) ? LaunchPreferences.getPreferenceStore().getString("org.eclipse.ptp.remotetools.environment.launcher.preferences-working-directory") : configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.REMOTE_DIRECTORY", null);
        if (location == null) {
            return null;
        }
        try {
            location = LaunchVariableManager.getDefault().resolveValue(location, EMPTY_STRING, EMPTY_STRING, 9, configuration);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (location == null) {
            return null;
        }
        return LinuxPath.fromString(location);
    }

    public IPath getValidatedRemoteDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path;
        String location = null;
        if (configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AUTO_REMOTE_DIRECTORY", false)) {
            location = LaunchPreferences.getPreferenceStore().getString("org.eclipse.ptp.remotetools.environment.launcher.preferences-working-directory");
            if (location == null || location.length() == 0) {
                this.abort(Messages.RemoteLaunchDelegate_RemoteDirectory_MissingInPreferences, null, 0);
            }
        } else {
            location = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.REMOTE_DIRECTORY", null);
            if (location == null || location.length() == 0) {
                this.abort(Messages.RemoteLaunchDelegate_RemoteDirectory_Missing, null, 0);
            }
        }
        try {
            location = LaunchVariableManager.getDefault().resolveValue(location, EMPTY_STRING, EMPTY_STRING, 9, configuration);
        }
        catch (CoreException e) {
            this.abort(NLS.bind((String)Messages.RemoteLaunchDelegate_RemoteDirectory_MacroFailed, (Object)e.getMessage()), e, 0);
        }
        if (location == null) {
            this.abort(Messages.RemoteLaunchDelegate_RemoteDirectory_MacroFailed_Unknown, null, 0);
        }
        if (!(path = LinuxPath.fromString(location)).isAbsolute()) {
            this.abort(Messages.RemoteLaunchDelegate_RemoteDirectory_MustBeAbsolute, null, 0);
        }
        return path;
    }

    public boolean getSynchronizeBefore(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_BEFORE", true);
    }

    public boolean getSynchronizeAfter(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_AFTER", true);
    }

    public boolean getUseForwardedX11(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.FORWARD_X11", false);
    }

    public ILaunchObserver getOutputObserver(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.OUTPUT_OBSERVER", null);
        if (id == null) {
            return new NullLaunchObserver();
        }
        ILaunchObserver launchObserver = RemoteLauncherPlugin.getLaunchObserverByID(id);
        if (launchObserver == null) {
            return new NullLaunchObserver();
        }
        return launchObserver;
    }

    public String getBeforeCommand(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.BEFORE_COMMAND", null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String getAfterCommand(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AFTER_COMMAND", null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected boolean getSynchronizeCleanup(ILaunchConfiguration configuration) {
        try {
            boolean result = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_CLEANUP", true);
            return result;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected static boolean getAllocateTerminal(ILaunchConfiguration configuration) {
        try {
            boolean result = configuration.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            return result;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected ISynchronizationRule[] getSynchronizeRules(ILaunchConfiguration configuration) throws CoreException {
        List ruleStrings = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_RULES", new ArrayList());
        ArrayList<ISynchronizationRule> result = new ArrayList<ISynchronizationRule>();
        for (String element : ruleStrings) {
            try {
                ISynchronizationRule rule = RuleFactory.createRuleFromString(element);
                result.add(rule);
            }
            catch (RuntimeException e) {
                this.abort(Messages.RemoteLaunchDelegate_SynchronizationRules_InternalError, e, 3);
            }
        }
        return result.toArray(new ISynchronizationRule[result.size()]);
    }
}

