/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.CopyThread;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class CopySingleThread
extends CopyThread {
    private DataElement nameObj;

    public CopySingleThread(DataElement targetFolder, DataElement theElement, DataElement nameObj, UniversalFileSystemMiner miner, boolean isWindows, DataElement status) {
        super(targetFolder, theElement, miner, isWindows, status);
        this.nameObj = nameObj;
    }

    public void run() {
        super.run();
        try {
            this.handleCopy();
        }
        catch (SystemMessageException systemMessageException) {
            this.status.setAttribute(4, "failed");
            this.miner.statusDone(this.status);
        }
        this._isDone = true;
    }

    private DataElement handleCopy() throws SystemMessageException {
        DataElement sourceFile = this.theElement;
        String newName = this.nameObj.getName();
        String targetType = this.targetFolder.getType();
        String srcType = sourceFile.getType();
        File srcFile = null;
        VirtualChild child = null;
        this.systemOperationMonitor = new SystemOperationMonitor();
        if ("universal.FilterObject" == srcType && ArchiveHandlerManager.isVirtual((String)sourceFile.getValue())) {
            String goodFullName = ArchiveHandlerManager.cleanUpVirtualPath((String)sourceFile.getValue());
            child = ArchiveHandlerManager.getInstance().getVirtualObject(goodFullName);
            if (child.exists()) {
                srcType = child.isDirectory ? "universal.VirtualFolderObject" : "universal.VirtualFileObject";
            }
        }
        if (targetType.equals("universal.ArchiveFileObject") || targetType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath vpath = this.miner.getAbsoluteVirtualPath(this.targetFolder);
            ISystemArchiveHandler handler = this.miner.getArchiveHandlerFor(vpath.getContainingArchiveString());
            if (handler == null) {
                this.status.setAttribute(4, "failed");
                return this.miner.statusDone(this.status);
            }
            if (srcType.equals("universal.FileObject") || srcType.equals("universal.FolderObject") || srcType.equals("universal.ArchiveFileObject")) {
                srcFile = this.getFileFor(sourceFile);
            } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                ISystemArchiveHandler shandler = null;
                if (child == null) {
                    AbsoluteVirtualPath svpath = this.miner.getAbsoluteVirtualPath(sourceFile);
                    shandler = this.miner.getArchiveHandlerFor(svpath.getContainingArchiveString());
                    if (shandler == null) {
                        this.status.setAttribute(4, "failed");
                        return this.miner.statusDone(this.status);
                    }
                    child = shandler.getVirtualFile(svpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
                } else {
                    shandler = child.getHandler();
                }
                srcFile = child.getExtractedFile();
            }
            String virtualContainer = "";
            if (targetType.equals("universal.VirtualFolderObject")) {
                virtualContainer = vpath.getVirtualPart();
            }
            handler.add(srcFile, virtualContainer, newName, (ISystemOperationMonitor)this.systemOperationMonitor);
        } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
            ISystemArchiveHandler shandler = null;
            AbsoluteVirtualPath svpath = null;
            if (child == null) {
                svpath = this.miner.getAbsoluteVirtualPath(sourceFile);
                shandler = this.miner.getArchiveHandlerFor(svpath.getContainingArchiveString());
                if (shandler == null) {
                    this.status.setAttribute(4, "failed");
                    return this.miner.statusDone(this.status);
                }
                child = shandler.getVirtualFile(svpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
            } else {
                shandler = child.getHandler();
                svpath = this.miner.getAbsoluteVirtualPath(sourceFile.getValue());
            }
            File parentDir = this.getFileFor(this.targetFolder);
            File destination = new File(parentDir, newName);
            if (child.isDirectory) {
                shandler.extractVirtualDirectory(svpath.getVirtualPart(), parentDir, destination, (ISystemOperationMonitor)this.systemOperationMonitor);
            } else {
                shandler.extractVirtualFile(svpath.getVirtualPart(), destination, (ISystemOperationMonitor)this.systemOperationMonitor);
            }
        } else {
            File tgtFolder = this.getFileFor(this.targetFolder);
            srcFile = this.getFileFor(sourceFile);
            boolean folderCopy = srcFile.isDirectory();
            String src = srcFile.getAbsolutePath();
            String tgt = String.valueOf(tgtFolder.getAbsolutePath()) + File.separatorChar + newName;
            File tgtFile = new File(tgt);
            if (tgtFile.exists() && tgtFile.isDirectory() && newName.equals(srcFile.getName()) && !this.isWindows) {
                tgt = tgtFolder.getAbsolutePath();
            }
            this.doCopyCommand(this.enQuote(src), this.enQuote(tgt), folderCopy, this.status);
        }
        return this.miner.statusDone(this.status);
    }
}

