/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.packet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.messages.Messages;
import org.eclipse.ptp.proxy.util.ProtocolUtil;

public class ProxyPacket {
    public static final int PACKET_LENGTH_SIZE = 8;
    public static final int PACKET_CHANNEL_SIZE = 2;
    public static final int PACKET_ID_SIZE = 4;
    public static final int PACKET_TRANS_ID_SIZE = 8;
    public static final int PACKET_NARGS_SIZE = 8;
    public static final int PACKET_ARG_LEN_SIZE = 8;
    private boolean debug = false;
    private int packetID;
    private int packetTransID;
    private String[] packetArgs;
    private Charset charset = Charset.forName("US-ASCII");
    private CharsetEncoder encoder = this.charset.newEncoder();
    private CharsetDecoder decoder = this.charset.newDecoder();

    public ProxyPacket() {
    }

    public ProxyPacket(IProxyCommand cmd) {
        this.packetID = cmd.getCommandID();
        this.packetTransID = cmd.getTransactionID();
        this.packetArgs = cmd.getArguments();
    }

    public ProxyPacket(IProxyEvent event) {
        this.packetID = event.getEventID();
        this.packetTransID = event.getTransactionID();
        this.packetArgs = event.getAttributes();
        if (this.packetArgs == null) {
            this.packetArgs = new String[0];
        }
    }

    public CharsetDecoder decoder() {
        return this.decoder;
    }

    public CharsetEncoder encoder() {
        return this.encoder;
    }

    private void fullRead(ReadableByteChannel channel, ByteBuffer buf) throws IOException {
        buf.clear();
        while (buf.hasRemaining()) {
            int n = channel.read(buf);
            if (n >= 0) continue;
            throw new IOException(Messages.ProxyPacket_2);
        }
        buf.flip();
    }

    private void fullWrite(WritableByteChannel channel, ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            int n = channel.write(buf);
            if (n >= 0) continue;
            throw new IOException(Messages.ProxyPacket_3);
        }
    }

    public String[] getArgs() {
        return this.packetArgs;
    }

    public int getID() {
        return this.packetID;
    }

    public int getTransID() {
        return this.packetTransID;
    }

    public boolean read(ReadableByteChannel channel) throws IOException {
        int len;
        ByteBuffer lengthBytes = ByteBuffer.allocate(8);
        this.fullRead(channel, lengthBytes);
        CharBuffer len_str = this.decoder.decode(lengthBytes);
        try {
            len = Integer.parseInt(len_str.subSequence(0, 8).toString(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.debug) {
                System.out.println("] BAD PACKET LENGTH");
            } else {
                System.out.println("BAD PACKET LENGTH: \"" + len_str + "\"");
            }
            throw new IOException(Messages.ProxyPacket_0);
        }
        ByteBuffer packetBytes = ByteBuffer.allocate(len);
        this.fullRead(channel, packetBytes);
        CharBuffer packetBuf = this.decoder.decode(packetBytes);
        if (this.debug) {
            System.out.println("RECEIVE:[" + len_str + " -> " + packetBuf + "] -> " + Thread.currentThread().getName());
        }
        int idStart = 1;
        int idEnd = idStart + 4;
        int transStart = idEnd + 1;
        int transEnd = transStart + 8;
        int numArgsStart = transEnd + 1;
        int numArgsEnd = numArgsStart + 8;
        try {
            this.packetID = Integer.parseInt(packetBuf.subSequence(idStart, idEnd).toString(), 16);
            this.packetTransID = Integer.parseInt(packetBuf.subSequence(transStart, transEnd).toString(), 16);
            int packetNumArgs = Integer.parseInt(packetBuf.subSequence(numArgsStart, numArgsEnd).toString(), 16);
            this.packetArgs = new String[packetNumArgs];
            int argPos = numArgsEnd + 1;
            int i = 0;
            while (i < packetNumArgs) {
                this.packetArgs[i] = ProtocolUtil.decodeString(packetBuf, argPos);
                argPos += this.packetArgs[i].length() + 8 + 2;
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("BAD PACKET FORMAT: \"" + packetBuf + "\"");
            throw new IOException(Messages.ProxyPacket_1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    public void send(WritableByteChannel channel) throws IOException {
        String body = String.valueOf(ProtocolUtil.encodeIntVal(this.packetID, 4)) + ":" + ProtocolUtil.encodeIntVal(this.packetTransID, 8) + ":" + ProtocolUtil.encodeIntVal(this.packetArgs.length, 8);
        String[] stringArray = this.packetArgs;
        int n = this.packetArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            body = String.valueOf(body) + " " + ProtocolUtil.encodeString(arg);
            ++n2;
        }
        String packet = String.valueOf(ProtocolUtil.encodeIntVal(body.length() + 1, 8)) + " " + body;
        if (this.debug) {
            System.out.println("SEND:[" + packet + "] -> " + Thread.currentThread().getName());
        }
        this.fullWrite(channel, this.encoder.encode(CharBuffer.wrap(packet)));
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

