/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.remotetools.preferences.events.IPreferencesChangeListener;
import org.eclipse.ptp.remotetools.preferences.events.PreferencesChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PreferencesPlugin
extends AbstractUIPlugin {
    private static PreferencesPlugin plugin;
    private final List propertiesListeners;
    private Preferences.IPropertyChangeListener propertyListener;

    public PreferencesPlugin() {
        plugin = this;
        this.propertiesListeners = new ArrayList();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.propertyListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                PreferencesPlugin.this.fireValueChanged(event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        };
        this.getPluginPreferences().addPropertyChangeListener(this.propertyListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPluginPreferences().removePropertyChangeListener(this.propertyListener);
        this.savePluginPreferences();
        plugin = null;
    }

    public static PreferencesPlugin getDefault() {
        return plugin;
    }

    public void addListener(IPreferencesChangeListener listener) {
        this.propertiesListeners.add(listener);
    }

    public void removeListener(IPreferencesChangeListener listener) {
        this.propertiesListeners.remove(listener);
    }

    public void fireValueChanged(String property, Object oldValue, Object newValue) {
        if (this.propertiesListeners.size() == 0) {
            return;
        }
        for (IPreferencesChangeListener listener : this.propertiesListeners) {
            listener.propertyChange(new PreferencesChangeEvent((Object)this, property, oldValue, newValue));
        }
    }
}

