/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.preferences;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.ui.preferences.IndexerPreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.AbstractIndexerPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionContainerExtension;
import org.eclipse.cdt.ui.dialogs.NullIndexerBlock;
import org.eclipse.cdt.ui.dialogs.PreferenceScopeBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.PropertyPage;

public class IndexerBlock
extends AbstractCOptionPage {
    private static final String NODE_INDEXERUI = "indexerUI";
    private static final String ATTRIB_CLASS = "class";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_INDEXERID = "indexerID";
    private static final String ATTRIB_ID = "id";
    private static final String PREF_PAGE_ID = "org.eclipse.cdt.ui.preferences.IndexerPreferencePage";
    private static final String INDEXER_LABEL = CUIPlugin.getResourceString((String)"BaseIndexerBlock.label");
    private static final String INDEXER_DESCRIPTION = CUIPlugin.getResourceString((String)"BaseIndexerBlock.desc");
    private static final String INDEXER_COMBO_LABEL = CUIPlugin.getResourceString((String)"BaseIndexerBlock.comboLabel");
    private PreferenceScopeBlock fPrefScopeBlock;
    private Combo fIndexersComboBox;
    private HashMap<String, IndexerConfig> fIndexerConfigMap;
    private Composite fIndexerPageComposite;
    private AbstractIndexerPage fCurrentPage;
    private Properties fCurrentProperties;
    private Composite fPreferenceContent;
    private Composite fParent;
    private Button fUseActiveBuildButton;
    private Button fUseFixedBuildConfig;
    private Combo fBuildConfigComboBox;
    private ControlEnableState fEnableState;

    public IndexerBlock() {
        super(INDEXER_LABEL);
        this.setDescription(INDEXER_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeIndexerConfigMap();
        this.fParent = parent;
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 0;
        GridData gd = (GridData)composite.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.setControl((Control)composite);
        if (this.getProject() != null || this.getContainer() instanceof ICOptionContainerExtension) {
            this.fPrefScopeBlock = new PreferenceScopeBlock(PREF_PAGE_ID){

                protected void onPreferenceScopeChange() {
                    IndexerBlock.this.onPreferenceScopeChange();
                }
            };
            this.fPrefScopeBlock.createControl(composite);
        }
        this.fPreferenceContent = ControlFactory.createComposite((Composite)composite, (int)1);
        layout = (GridLayout)this.fPreferenceContent.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        gd = (GridData)this.fPreferenceContent.getLayoutData();
        gd.horizontalIndent = 0;
        Group group = ControlFactory.createGroup((Composite)this.fPreferenceContent, (String)INDEXER_COMBO_LABEL, (int)1);
        gd = (GridData)group.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.fIndexersComboBox = ControlFactory.createSelectCombo((Composite)group, (String)"", (String)"");
        this.fIndexersComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexerBlock.this.onIndexerChange();
            }
        });
        this.fIndexerPageComposite = ControlFactory.createComposite((Composite)group, (int)1);
        this.fIndexerPageComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fIndexerPageComposite.setLayout((Layout)new TabFolderLayout());
        if (this.needBuildConfigOptions()) {
            group = ControlFactory.createGroup((Composite)composite, (String)DialogsMessages.IndexerStrategyBlock_buildConfigGroup, (int)1);
            gd = (GridData)group.getLayoutData();
            gd.grabExcessHorizontalSpace = true;
            this.fUseActiveBuildButton = ControlFactory.createRadioButton((Composite)group, (String)DialogsMessages.IndexerStrategyBlock_activeBuildConfig, null, null);
            this.fUseFixedBuildConfig = ControlFactory.createRadioButton((Composite)group, (String)DialogsMessages.IndexerBlock_fixedBuildConfig, null, null);
            this.fBuildConfigComboBox = ControlFactory.createSelectCombo((Composite)group, (String)"", (String)"");
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IndexerBlock.this.setUseActiveBuildConfig(IndexerBlock.this.fUseActiveBuildButton.getSelection());
                }
            };
            this.fUseActiveBuildButton.addSelectionListener((SelectionListener)listener);
            this.fUseFixedBuildConfig.addSelectionListener((SelectionListener)listener);
        }
        this.initializeScope();
        this.initializeIndexerCombo();
        this.initializeBuildConfigs();
        this.onPreferenceScopeChange();
        this.fParent.layout(true);
    }

    protected boolean needBuildConfigOptions() {
        ICProjectDescriptionManager prjDescMgr;
        if (this.fPrefScopeBlock == null || !(this.getContainer() instanceof PropertyPage)) {
            return false;
        }
        IProject prj = this.getProject();
        return prj != null && IndexerPreferencePage.showBuildConfiguration() && (prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager()).isNewStyleProject(prj);
    }

    private void updateBuildConfigForScope(int scope) {
        if (this.fBuildConfigComboBox != null && scope == 0) {
            ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescriptionWorkspacePreferences prefs = prjDescMgr.getProjectDescriptionWorkspacePreferences(false);
            boolean useActive = prefs.getConfigurationRelations() == 2;
            this.setUseActiveBuildConfig(useActive);
        }
    }

    protected void setUseActiveBuildConfig(boolean useActive) {
        if (this.fBuildConfigComboBox != null) {
            if (useActive) {
                ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
                ICProjectDescription prefs = prjDescMgr.getProjectDescription(this.getProject(), false);
                this.selectBuildConfigInCombo(prefs.getActiveConfiguration().getName());
                this.fBuildConfigComboBox.setEnabled(false);
            } else {
                this.fBuildConfigComboBox.setEnabled(true);
            }
            this.fUseActiveBuildButton.setSelection(useActive);
            this.fUseFixedBuildConfig.setSelection(!useActive);
        }
    }

    private void enablePreferenceContent(boolean enable) {
        if (this.fEnableState != null) {
            this.fEnableState.restore();
            if (this.fUseActiveBuildButton != null) {
                this.fUseActiveBuildButton.setEnabled(true);
                this.fUseFixedBuildConfig.setEnabled(true);
            }
        }
        if (enable) {
            this.fEnableState = null;
        } else {
            this.fEnableState = ControlEnableState.disable((Control)this.fPreferenceContent);
            if (this.fUseActiveBuildButton != null) {
                this.fUseActiveBuildButton.setEnabled(false);
                this.fUseFixedBuildConfig.setEnabled(false);
            }
        }
    }

    private void initializeScope() {
        IProject proj = this.getProject();
        if (this.fPrefScopeBlock == null) {
            return;
        }
        int scope = proj == null ? 0 : IndexerPreferences.getScope((IProject)proj);
        switch (scope) {
            case 1: {
                this.fPrefScopeBlock.setProjectLocalScope();
                break;
            }
            case 2: {
                this.fPrefScopeBlock.setProjectScope();
                break;
            }
            default: {
                this.fPrefScopeBlock.setInstanceScope();
            }
        }
    }

    private void initializeIndexerCombo() {
        String[] names = new String[this.fIndexerConfigMap.size()];
        int j = 0;
        for (IndexerConfig config : this.fIndexerConfigMap.values()) {
            names[j++] = config.getName();
        }
        Collator collator = Collator.getInstance();
        Arrays.sort(names, collator);
        this.fIndexersComboBox.setItems(names);
    }

    private void initializeBuildConfigs() {
        if (this.fBuildConfigComboBox != null) {
            ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescription prefs = prjDescMgr.getProjectDescription(this.getProject(), false);
            this.setUseActiveBuildConfig(prefs.getConfigurationRelations() == 2);
            ICConfigurationDescription[] configs = prefs.getConfigurations();
            String[] names = new String[configs.length];
            int i = 0;
            while (i < configs.length) {
                ICConfigurationDescription config = configs[i];
                names[i] = config.getName();
                ++i;
            }
            Collator collator = Collator.getInstance();
            Arrays.sort(names, collator);
            this.fBuildConfigComboBox.setItems(names);
            this.selectBuildConfigInCombo(prefs.getDefaultSettingConfiguration().getName());
        }
    }

    private void selectBuildConfigInCombo(String useName) {
        String[] names = this.fBuildConfigComboBox.getItems();
        int selectedIndex = 0;
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(useName)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.fBuildConfigComboBox.select(selectedIndex);
    }

    protected void onPreferenceScopeChange() {
        int scope = this.computeScope();
        this.updateBuildConfigForScope(scope);
        if (this.fCurrentProperties == null || scope != 1) {
            Properties props = IndexerPreferences.getProperties((IProject)this.getProject(), (int)scope);
            String indexerId = props.getProperty("indexerId");
            if (this.getIndexerName(indexerId) == null) {
                props = this.fCurrentProperties != null ? this.fCurrentProperties : IndexerPreferences.getProperties((IProject)this.getProject(), (int)0);
            }
            this.fCurrentProperties = props;
        }
        this.updateForNewProperties(scope);
    }

    private void updateForNewProperties(int scope) {
        String indexerId = this.fCurrentProperties.getProperty("indexerId");
        String indexerName = this.getIndexerName(indexerId);
        String[] indexerList = this.fIndexersComboBox.getItems();
        int selectedIndex = 0;
        int i = 0;
        while (i < indexerList.length) {
            if (indexerList[i].equals(indexerName)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.fIndexersComboBox.select(selectedIndex);
        this.setPage();
        if (this.fPrefScopeBlock != null) {
            this.enablePreferenceContent(scope != 0);
        }
    }

    protected void onIndexerChange() {
        Properties props;
        if (this.fCurrentPage != null && (props = this.fCurrentPage.getProperties()) != null) {
            this.fCurrentProperties.putAll((Map<?, ?>)props);
        }
        this.setPage();
    }

    private int computeScope() {
        if (this.fPrefScopeBlock != null) {
            if (this.fPrefScopeBlock.isProjectLocalScope()) {
                return 1;
            }
            if (this.fPrefScopeBlock.isProjectScope()) {
                return 2;
            }
        }
        return 0;
    }

    private void setPage() {
        String indexerID = this.getSelectedIndexerID();
        AbstractIndexerPage page = this.getIndexerPage(indexerID);
        if (page != null && page.getControl() == null) {
            page.setContainer(this.getContainer());
            page.createControl(this.fIndexerPageComposite);
            this.fIndexerPageComposite.layout(true);
            this.fParent.layout(true);
        }
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(false);
        }
        if (page != null) {
            page.setProperties(this.fCurrentProperties);
            page.setVisible(true);
        }
        this.fCurrentPage = page;
    }

    private void initializeIndexerConfigMap() {
        IConfigurationElement[] infos;
        this.fIndexerConfigMap = new HashMap(5);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CUIPlugin.getPluginId(), "IndexerPage");
        IConfigurationElement[] iConfigurationElementArray = infos = extensionPoint.getConfigurationElements();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IndexerConfig config;
            String id;
            IConfigurationElement info = iConfigurationElementArray[n2];
            if (info.getName().equals(NODE_INDEXERUI) && (id = info.getAttribute(ATTRIB_INDEXERID)) != null && (config = new IndexerConfig(info)).getName() != null && !WorkbenchActivityHelper.filterItem((Object)config)) {
                IProject proj = this.getProject();
                if (proj != null && RemoteNature.hasRemoteNature((IProject)proj)) {
                    if (id.startsWith("org.eclipse.ptp.rdt.core.RemoteFastIndexer") || id.equalsIgnoreCase("org.eclipse.cdt.core.nullindexer")) {
                        this.fIndexerConfigMap.put(id, config);
                    }
                } else {
                    this.fIndexerConfigMap.put(id, config);
                }
            }
            ++n2;
        }
    }

    private String getIndexerName(String indexerID) {
        IndexerConfig configElement = this.fIndexerConfigMap.get(indexerID);
        if (configElement != null) {
            return configElement.getName();
        }
        return null;
    }

    private String getIndexerID(String indexerName) {
        for (Map.Entry<String, IndexerConfig> entry : this.fIndexerConfigMap.entrySet()) {
            String id = entry.getKey();
            IndexerConfig config = entry.getValue();
            if (!indexerName.equals(config.getName())) continue;
            return id;
        }
        return null;
    }

    private AbstractIndexerPage getIndexerPage(String indexerID) {
        IndexerConfig configElement = this.fIndexerConfigMap.get(indexerID);
        if (configElement != null) {
            try {
                return configElement.getPage();
            }
            catch (CoreException e) {
                CUIPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        int scope = this.computeScope();
        IProject project = this.getProject();
        String indexerID = this.getSelectedIndexerID();
        if (indexerID == null) {
            return;
        }
        if (scope != 0 || project == null) {
            Properties p1;
            Properties props = new Properties();
            props.setProperty("indexerId", indexerID);
            if (this.fCurrentPage != null && (p1 = this.fCurrentPage.getProperties()) != null) {
                props.putAll((Map<?, ?>)p1);
            }
            IndexerPreferences.setProperties((IProject)project, (int)scope, (Properties)props);
        }
        if (project != null) {
            IndexerPreferences.setScope((IProject)project, (int)scope);
        }
        if (this.fBuildConfigComboBox != null) {
            ICConfigurationDescription config;
            boolean useActive = this.fUseActiveBuildButton.getSelection();
            ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescription prefs = prjDescMgr.getProjectDescription(this.getProject(), true);
            if (scope == 0) {
                prefs.useDefaultConfigurationRelations();
            } else {
                prefs.setConfigurationRelations(useActive ? 2 : 1);
            }
            if (!useActive && (config = prefs.getConfigurationByName(this.fBuildConfigComboBox.getText())) != null) {
                prefs.setDefaultSettingConfiguration(config);
            }
            prjDescMgr.setProjectDescription(this.getProject(), prefs);
        }
        CCoreInternals.savePreferences((IProject)project, (scope == 2 ? 1 : 0) != 0);
    }

    public void performDefaults() {
        this.fCurrentProperties = null;
        if (this.fPrefScopeBlock != null) {
            this.fPrefScopeBlock.setInstanceScope();
            this.onPreferenceScopeChange();
        } else {
            this.fCurrentProperties = IndexerPreferences.getDefaultIndexerProperties();
            this.updateForNewProperties(0);
        }
    }

    @Deprecated
    public boolean isIndexEnabled() {
        return false;
    }

    private String getSelectedIndexerID() {
        return this.getIndexerID(this.fIndexersComboBox.getText());
    }

    public IProject getProject() {
        ICOptionContainer container = this.getContainer();
        if (container != null) {
            if (container instanceof ICOptionContainerExtension) {
                try {
                    return ((ICOptionContainerExtension)container).getProjectHandle();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return container.getProject();
        }
        return null;
    }

    private static class IndexerConfig
    implements IPluginContribution {
        private AbstractIndexerPage fPage;
        private IConfigurationElement fElement;

        public IndexerConfig(IConfigurationElement element) {
            this.fElement = element;
        }

        public AbstractIndexerPage getPage() throws CoreException {
            if (this.fPage == null) {
                try {
                    this.fPage = (AbstractIndexerPage)this.fElement.createExecutableExtension(IndexerBlock.ATTRIB_CLASS);
                }
                catch (Exception e) {
                    CUIPlugin.log((Throwable)e);
                }
                if (this.fPage == null) {
                    this.fPage = new NullIndexerBlock();
                }
            }
            return this.fPage;
        }

        public String getName() {
            return this.fElement.getAttribute(IndexerBlock.ATTRIB_NAME);
        }

        public String getIndexerID() {
            return this.fElement.getAttribute(IndexerBlock.ATTRIB_INDEXERID);
        }

        public String getLocalId() {
            return this.fElement.getAttribute(IndexerBlock.ATTRIB_ID);
        }

        public String getPluginId() {
            return this.fElement.getContributor().getName();
        }
    }
}

