/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.ui.launch;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.ui.launch.OpenMPILaunchConfigurationDefaults;

public class OpenMPILaunchConfiguration {
    public static final String ATTR_BASE = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes";
    public static final String ATTR_NUMPROCS = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.numProcs";
    public static final String ATTR_BYNODE = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.byNode";
    public static final String ATTR_BYSLOT = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.bySlot";
    public static final String ATTR_NOOVERSUBSCRIBE = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.noOversubscribe";
    public static final String ATTR_NOLOCAL = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.noLocal";
    public static final String ATTR_PREFIX = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.prefix";
    public static final String ATTR_USEPREFIX = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.usePrefix";
    public static final String ATTR_HOSTFILE = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.hostFile";
    public static final String ATTR_USEHOSTFILE = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.useHostFile";
    public static final String ATTR_HOSTLIST = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.hostList";
    public static final String ATTR_USEHOSTLIST = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.useHostList";
    public static final String ATTR_ARGUMENTS = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.arguments";
    public static final String ATTR_USEDEFAULTARGUMENTS = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.useDefaultArguments";
    public static final String ATTR_PARAMETERS = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.parameters";
    public static final String ATTR_USEDEFAULTPARAMETERS = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.useDefaultParameters";

    static String calculateArguments(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute(ATTR_USEDEFAULTARGUMENTS, OpenMPILaunchConfigurationDefaults.ATTR_USEDEFAULTARGUMENTS)) {
            String launchArgs = "-np " + Integer.toString(configuration.getAttribute(ATTR_NUMPROCS, OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS));
            if (configuration.getAttribute(ATTR_BYNODE, OpenMPILaunchConfigurationDefaults.ATTR_BYNODE)) {
                launchArgs = String.valueOf(launchArgs) + " -bynode";
            }
            if (configuration.getAttribute(ATTR_BYSLOT, OpenMPILaunchConfigurationDefaults.ATTR_BYSLOT)) {
                launchArgs = String.valueOf(launchArgs) + " -byslot";
            }
            if (configuration.getAttribute(ATTR_NOOVERSUBSCRIBE, OpenMPILaunchConfigurationDefaults.ATTR_NOOVERSUBSCRIBE)) {
                launchArgs = String.valueOf(launchArgs) + " -nooversubscribe";
            }
            if (configuration.getAttribute(ATTR_NOLOCAL, OpenMPILaunchConfigurationDefaults.ATTR_NOLOCAL)) {
                launchArgs = String.valueOf(launchArgs) + " -nolocal";
            }
            if (configuration.getAttribute(ATTR_USEPREFIX, OpenMPILaunchConfigurationDefaults.ATTR_USEPREFIX)) {
                launchArgs = String.valueOf(launchArgs) + " --prefix " + OpenMPILaunchConfiguration.fixString(configuration.getAttribute(ATTR_PREFIX, OpenMPILaunchConfigurationDefaults.ATTR_PREFIX));
            }
            if (configuration.getAttribute(ATTR_USEHOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTFILE)) {
                launchArgs = String.valueOf(launchArgs) + " -hostfile " + OpenMPILaunchConfiguration.fixString(configuration.getAttribute(ATTR_HOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_HOSTFILE));
            }
            if (configuration.getAttribute(ATTR_USEHOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTLIST)) {
                launchArgs = String.valueOf(launchArgs) + " -host " + OpenMPILaunchConfiguration.fixString(configuration.getAttribute(ATTR_HOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_HOSTLIST));
            }
            if (!configuration.getAttribute(ATTR_USEDEFAULTPARAMETERS, OpenMPILaunchConfigurationDefaults.ATTR_USEDEFAULTPARAMETERS)) {
                Map params = configuration.getAttribute(ATTR_PARAMETERS, OpenMPILaunchConfigurationDefaults.ATTR_PARAMETERS);
                for (Map.Entry param : params.entrySet()) {
                    launchArgs = String.valueOf(launchArgs) + " -mca " + (String)param.getKey() + " " + OpenMPILaunchConfiguration.fixString((String)param.getValue());
                }
            }
            return launchArgs;
        }
        return configuration.getAttribute(ATTR_ARGUMENTS, OpenMPILaunchConfigurationDefaults.ATTR_ARGUMENTS);
    }

    private static String fixString(String s) {
        if (s == null) {
            return "\"\"";
        }
        return "\"" + s + "\"";
    }
}

