/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttributeDefinition;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.attributes.AttributeIndexSet;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.IJobListener;
import org.eclipse.ptp.core.util.ProcessOutput;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.JobChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.NewProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveProcessEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PJob
extends Parent
implements IPJobControl {
    private final ListenerList childListeners = new ListenerList();
    private ILaunchConfiguration configuration;
    private final BitSet currentProcessJobRanks = new BitSet();
    private final ListenerList elementListeners = new ListenerList();
    private final ProcessOutput processOutput;
    private final Map<IAttributeDefinition<?, ?, ?>, AttributeIndexSet<?>> processAttributesMap = new HashMap();

    public PJob(String id, IPQueueControl queue, IAttribute<?, ?, ?>[] attrs) {
        super(id, queue, 13, attrs);
        BooleanAttribute debugFlag;
        IAttribute jobState = (EnumeratedAttribute)this.getAttribute(JobAttributes.getStateAttributeDefinition());
        if (jobState == null) {
            jobState = JobAttributes.getStateAttributeDefinition().create();
            this.addAttribute(jobState);
        }
        if ((debugFlag = (BooleanAttribute)this.getAttribute(JobAttributes.getDebugFlagAttributeDefinition())) == null) {
            debugFlag = JobAttributes.getDebugFlagAttributeDefinition().create();
            this.addAttribute(debugFlag);
        }
        this.processOutput = new ProcessOutput(this);
    }

    @Override
    public void addChildListener(IJobChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(IJobListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addProcessAttributes(BitSet processIds, AttributeManager attributes) {
        processIds = (BitSet)processIds.clone();
        processIds.and(this.currentProcessJobRanks);
        this.addAttributesForJobRanks(processIds, attributes);
        this.fireChangedProcesses(processIds, attributes);
    }

    @Override
    public void addProcessesByJobRanks(BitSet newProcessJobRanks, AttributeManager attrs) {
        StringAttribute signalName;
        IntegerAttribute exitCode;
        this.currentProcessJobRanks.or(newProcessJobRanks);
        this.addAttributesForJobRanks(newProcessJobRanks, attrs);
        ArrayList<AbstractAttribute> requiredAttributes = new ArrayList<AbstractAttribute>(5);
        IAttribute procState = (EnumeratedAttribute)this.getAttribute(attrs, ProcessAttributes.getStateAttributeDefinition());
        if (procState == null) {
            procState = ProcessAttributes.getStateAttributeDefinition().create();
            requiredAttributes.add((AbstractAttribute)procState);
        }
        if ((exitCode = (IntegerAttribute)this.getAttribute(attrs, ProcessAttributes.getExitCodeAttributeDefinition())) == null) {
            try {
                exitCode = ProcessAttributes.getExitCodeAttributeDefinition().create();
                requiredAttributes.add(exitCode);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if ((signalName = (StringAttribute)this.getAttribute(attrs, ProcessAttributes.getSignalNameAttributeDefinition())) == null) {
            signalName = ProcessAttributes.getSignalNameAttributeDefinition().create();
            requiredAttributes.add(signalName);
        }
        IAttribute[] requiredAttrs = requiredAttributes.toArray(new IAttribute[0]);
        this.addAttributesForJobRanks(newProcessJobRanks, new AttributeManager(requiredAttrs));
        this.fireNewProcesses(newProcessJobRanks);
    }

    @Override
    public synchronized ILaunchConfiguration getLaunchConfiguration() {
        return this.configuration;
    }

    @Override
    public <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> A getProcessAttribute(D attributeDefinition, int processJobRank) {
        BitSet processJobRanks = new BitSet();
        processJobRanks.set(processJobRank);
        Set<A> attrs = this.getProcessAttributes(attributeDefinition, processJobRanks);
        if (attrs.isEmpty()) {
            return null;
        }
        return (A)((IAttribute)attrs.iterator().next());
    }

    @Override
    public IAttribute<?, ?, ?> getProcessAttribute(String attrDefId, int processJobRank) {
        BitSet processJobRanks = new BitSet();
        processJobRanks.set(processJobRank);
        Set<IAttribute<?, ?, ?>> attrs = this.getProcessAttributes(attrDefId, processJobRanks);
        if (attrs.isEmpty()) {
            return null;
        }
        return attrs.iterator().next();
    }

    @Override
    public synchronized Set<IAttributeDefinition<?, ?, ?>> getProcessAttributeKeys(BitSet processJobRanks) {
        HashSet results = new HashSet();
        for (AttributeIndexSet<?> ais : this.processAttributesMap.values()) {
            Set<?> attrs = ais.getSubset(processJobRanks).getAttributes();
            for (IAttribute attr : attrs) {
                results.add((IAttributeDefinition<?, ?, ?>)attr.getDefinition());
            }
        }
        return results;
    }

    @Override
    public synchronized Set<IAttribute<?, ?, ?>> getProcessAttributes(BitSet processJobRanks) {
        HashSet results = new HashSet();
        for (AttributeIndexSet<?> ais : this.processAttributesMap.values()) {
            Set<?> attrs = ais.getSubset(processJobRanks).getAttributes();
            results.addAll(attrs);
        }
        return results;
    }

    @Override
    public <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> Set<A> getProcessAttributes(D attributeDefinition, BitSet processJobRanks) {
        AttributeIndexSet<A> jobRanksForAttr = this.getAttributeIndexSet(attributeDefinition);
        AttributeIndexSet<A> subSet = jobRanksForAttr.getSubset(processJobRanks);
        return subSet.getAttributes();
    }

    @Override
    public synchronized Set<IAttribute<?, ?, ?>> getProcessAttributes(String attrDefId, BitSet processJobRanks) {
        HashSet results = new HashSet();
        for (Map.Entry<IAttributeDefinition<?, ?, ?>, AttributeIndexSet<?>> entry : this.processAttributesMap.entrySet()) {
            IAttributeDefinition<?, ?, ?> def = entry.getKey();
            if (!def.getId().equals(attrDefId)) continue;
            AttributeIndexSet<?> jobRanksForAttr = entry.getValue();
            AttributeIndexSet<?> subSet = jobRanksForAttr.getSubset(processJobRanks);
            results.addAll(subSet.getAttributes());
            return results;
        }
        return null;
    }

    public <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> T getProcessAttributeValue(int processJobRank, D def) {
        AttributeIndexSet<A> attrIndexSet = this.getAttributeIndexSet(def);
        A attr = attrIndexSet.getAttribute(processJobRank);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public BitSet getProcessJobRanks() {
        return (BitSet)this.currentProcessJobRanks.clone();
    }

    @Override
    public <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> BitSet getProcessJobRanks(A attribute) {
        D def = attribute.getDefinition();
        AttributeIndexSet<A> attrJobRanks = this.getAttributeIndexSet(def);
        return attrJobRanks.getIndexSet(attribute);
    }

    @Override
    public String getProcessName(int processJobRank) {
        return String.valueOf(this.getName()) + "." + processJobRank;
    }

    @Override
    public String getProcessNodeId(int processJobRank) {
        StringAttributeDefinition def = ProcessAttributes.getNodeIdAttributeDefinition();
        return (String)this.getProcessAttributeValue(processJobRank, def);
    }

    @Override
    public ProcessAttributes.State getProcessState(int processJobRank) {
        EnumeratedAttributeDefinition<ProcessAttributes.State> def = ProcessAttributes.getStateAttributeDefinition();
        return (ProcessAttributes.State)((Object)this.getProcessAttributeValue(processJobRank, def));
    }

    @Override
    public IPQueue getQueue() {
        return this.getQueueControl();
    }

    @Override
    public IPQueueControl getQueueControl() {
        return (IPQueueControl)this.getParent();
    }

    @Override
    public String getSavedOutput(int processJobRank) {
        return this.processOutput.getSavedOutput(processJobRank);
    }

    @Override
    public JobAttributes.State getState() {
        return (JobAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(JobAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public boolean hasProcessByJobRank(int processJobRank) {
        return this.currentProcessJobRanks.get(processJobRank);
    }

    @Override
    public boolean hasProcessesByJobRanks(BitSet processJobRanks) {
        BitSet intersection = (BitSet)this.currentProcessJobRanks.clone();
        intersection.and(processJobRanks);
        boolean containsAll = intersection.equals(processJobRanks);
        return containsAll;
    }

    @Override
    public boolean isDebug() {
        return ((BooleanAttribute)this.getAttribute(JobAttributes.getDebugFlagAttributeDefinition())).getValue();
    }

    @Override
    public void removeChildListener(IJobChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(IJobListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public synchronized void removeProcessesByJobRanks(BitSet processJobRanks) {
        this.currentProcessJobRanks.andNot(processJobRanks);
        ArrayList values = new ArrayList(this.processAttributesMap.values());
        for (AttributeIndexSet attributeIndexSet : values) {
            attributeIndexSet.clearIndices(processJobRanks);
        }
        this.clearOutput(processJobRanks);
        this.fireRemoveProcesses(processJobRanks);
    }

    @Override
    public void setDebug() {
        BooleanAttribute debug = (BooleanAttribute)this.getAttribute(JobAttributes.getDebugFlagAttributeDefinition());
        debug.setValue(true);
    }

    @Override
    public synchronized void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.configuration = configuration;
    }

    private void addAttributesForJobRanks(BitSet processJobRanks, AttributeManager attrs) {
        StringAttribute stdOutAttr = (StringAttribute)attrs.getAttribute(ProcessAttributes.getStdoutAttributeDefinition());
        if (stdOutAttr != null) {
            this.addOutput(stdOutAttr.getValue(), processJobRanks);
        }
        IAttribute<?, ?, ?>[] iAttributeArray = attrs.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute<?, ?, ?> attr = iAttributeArray[n2];
            AttributeIndexSet<IAttribute<?, ?, ?>> attrIds = this.getAttributeIndexSet((IAttributeDefinition)attr.getDefinition());
            attrIds.addIndicesToAttribute(attr, processJobRanks);
            ++n2;
        }
    }

    private void addOutput(String output, BitSet processJobRanks) {
        this.processOutput.addOutput(output, processJobRanks);
    }

    private void clearOutput(BitSet processJobRanks) {
        AttributeIndexSet outAttrs = this.getAttributeIndexSet(ProcessAttributes.getStdoutAttributeDefinition());
        outAttrs.clearIndices(processJobRanks);
        if (outAttrs.isEmpty()) {
            this.processOutput.delete();
        }
    }

    private void fireChangedJob(AttributeManager attrs) {
        JobChangeEvent e = new JobChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedProcesses(BitSet processes, AttributeManager attributes) {
        ChangedProcessEvent e = new ChangedProcessEvent(this, this, processes, attributes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewProcesses(BitSet processes) {
        NewProcessEvent e = new NewProcessEvent(this, this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveProcesses(BitSet processes) {
        RemoveProcessEvent e = new RemoveProcessEvent(this, this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> A getAttribute(AttributeManager attrs, D def) {
        return attrs.getAttribute(def);
    }

    private synchronized <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> AttributeIndexSet<A> getAttributeIndexSet(D def) {
        AttributeIndexSet<Object> attributeIndexSet = this.processAttributesMap.get(def);
        if (attributeIndexSet == null) {
            attributeIndexSet = new AttributeIndexSet();
            this.processAttributesMap.put(def, attributeIndexSet);
        }
        return attributeIndexSet;
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attribs) {
        this.fireChangedJob(attribs);
    }
}

