/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.Session;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMEventFactory;
import org.eclipse.ptp.debug.sdm.core.SDMManagerFactory;
import org.eclipse.ptp.debug.sdm.core.SDMModelFactory;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.core.SDMRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMRunner;
import org.eclipse.ptp.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.debug.sdm.core.pdi.PDIDebugger;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.utils.core.BitSetIterable;

public class SDMDebugger
implements IPDebugger {
    private IPDIDebugger fPdiDebugger = null;
    private IPDIModelFactory fModelFactory = null;
    private IPDIManagerFactory fManagerFactory = null;
    private IPDIEventFactory fEventFactory = null;
    private IPDIRequestFactory fRequestFactory = null;
    private IFileStore fRoutingFileStore = null;
    private SDMRunner fSdmRunner = null;

    public synchronized void cleanup(IPLaunch launch) {
        if (this.fSdmRunner != null) {
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_8);
            new Thread(Messages.SDMDebugger_7){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMDebugger_9);
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (SDMDebugger.this.fSdmRunner.getSdmState() == SDMRunner.SDMMasterState.RUNNING) {
                            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_11);
                            SDMDebugger.this.fSdmRunner.cancel();
                            try {
                                SDMDebugger.this.fSdmRunner.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_13);
                        }
                        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMDebugger_14);
                        SDMDebugger.this.fSdmRunner = null;
                    }
                }
            }.start();
        }
        this.fModelFactory = null;
        this.fManagerFactory = null;
        this.fEventFactory = null;
        this.fRequestFactory = null;
        this.fPdiDebugger = null;
        this.fRoutingFileStore = null;
    }

    public synchronized IPDISession createDebugSession(long timeout, IPLaunch launch, IPath corefile, IProgressMonitor monitor) throws CoreException {
        if (this.fModelFactory == null) {
            this.fModelFactory = new SDMModelFactory();
        }
        if (this.fManagerFactory == null) {
            this.fManagerFactory = new SDMManagerFactory();
        }
        if (this.fEventFactory == null) {
            this.fEventFactory = new SDMEventFactory();
        }
        if (this.fRequestFactory == null) {
            this.fRequestFactory = new SDMRequestFactory();
        }
        Session session = this.createSession(timeout, launch, corefile);
        if (this.fRoutingFileStore != null) {
            this.writeRoutingFile(launch, monitor);
            this.fSdmRunner.setJob(launch.getPJob());
            this.fSdmRunner.schedule();
        }
        return session;
    }

    public synchronized void initialize(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        String dbgExtraArgs;
        ArrayAttribute dbgArgsAttr;
        Preferences store = SDMDebugCorePlugin.getDefault().getPluginPreferences();
        if (store.getBoolean(SDMPreferenceConstants.SDM_DEBUG_CLIENT_ENABLED)) {
            int level = store.getInt(SDMPreferenceConstants.SDM_DEBUG_CLIENT_LEVEL);
            if ((level & 1) == 1) {
                DebugUtil.SDM_MASTER_TRACING = true;
            }
            if ((level & 2) == 2) {
                DebugUtil.SDM_MASTER_TRACING_MORE = true;
            }
            if ((level & 4) == 4) {
                DebugUtil.SDM_MASTER_OUTPUT_TRACING = true;
            }
        }
        if ((dbgArgsAttr = (ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerArgumentsAttributeDefinition())) == null) {
            dbgArgsAttr = JobAttributes.getDebuggerArgumentsAttributeDefinition().create();
            attrMgr.addAttribute((IAttribute)dbgArgsAttr);
        }
        List dbgArgs = dbgArgsAttr.getValue();
        try {
            this.getPDIDebugger().initialize(configuration, dbgArgs, monitor);
        }
        catch (PDIException e) {
            throw this.newCoreException(e.getLocalizedMessage());
        }
        String localAddress = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", "localhost");
        dbgArgs.add("--host=" + localAddress);
        dbgArgs.add("--debugger=" + store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE));
        String dbgPath = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH);
        if (dbgPath.length() > 0) {
            dbgArgs.add("--debugger_path=" + dbgPath);
        }
        if ((dbgExtraArgs = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS)).length() > 0) {
            dbgArgs.addAll(Arrays.asList(dbgExtraArgs.split(" ")));
        }
        if (store.getBoolean(SDMPreferenceConstants.SDM_DEBUG_ENABLED)) {
            dbgArgs.add("--debug=" + store.getInt(SDMPreferenceConstants.SDM_DEBUG_LEVEL));
        }
        String dbgExePath = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", "");
        IPath path = this.verifyResource(dbgExePath, configuration);
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerExecutableNameAttributeDefinition().create(path.lastSegment()));
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerExecutablePathAttributeDefinition().create(path.removeLastSegments(1).toString()));
        StringAttribute wdAttr = (StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition());
        String dbgWD = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
        if (dbgWD != null) {
            if (wdAttr != null) {
                wdAttr.setValueAsString(dbgWD);
            } else {
                wdAttr = JobAttributes.getWorkingDirectoryAttributeDefinition().create(dbgWD);
                attrMgr.addAttribute((IAttribute)wdAttr);
            }
        }
        IResourceManagerControl rm = null;
        rm = (IResourceManagerControl)this.getResourceManager(configuration);
        if (rm.getConfiguration().needsDebuggerLaunchHelp()) {
            this.prepareRoutingFile(configuration, attrMgr, monitor);
            this.fSdmRunner = new SDMRunner(rm);
            ArrayList<String> sdmCommand = new ArrayList<String>();
            sdmCommand.add(dbgExePath);
            sdmCommand.add("--master");
            sdmCommand.addAll(dbgArgs);
            this.fSdmRunner.setCommand(sdmCommand);
            if (wdAttr != null) {
                this.fSdmRunner.setWorkDir(wdAttr.getValue());
            }
        }
    }

    public IPath verifyResource(String path, ILaunchConfiguration configuration) throws CoreException {
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(configuration);
        if (rm == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_4));
        }
        IResourceManagerConfiguration conf = rm.getConfiguration();
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId());
        if (remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_0));
        }
        IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
        if (connMgr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_1));
        }
        IRemoteConnection conn = connMgr.getConnection(conf.getConnectionName());
        if (conn == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_2));
        }
        IRemoteFileManager fileManager = remoteServices.getFileManager(conn);
        if (fileManager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.debug.sdm.core", Messages.SDMDebugger_3));
        }
        if (!fileManager.getResource(path).fetchInfo().exists()) {
            throw new CoreException((IStatus)new Status(1, "org.eclipse.ptp.debug.sdm.core", NLS.bind((String)Messages.SDMDebugger_5, (Object[])new Object[]{path})));
        }
        return new Path(path);
    }

    private int getJobSize(IPJob job) {
        int nprocs = job.getProcessJobRanks().cardinality();
        if (nprocs == 0) {
            nprocs = 1;
        }
        return nprocs;
    }

    private IPDIDebugger getPDIDebugger() {
        if (this.fPdiDebugger == null) {
            this.fPdiDebugger = new PDIDebugger();
        }
        return this.fPdiDebugger;
    }

    private IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] rms = universe.getResourceManagers();
        String rmUniqueName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED && rm.getUniqueName().equals(rmUniqueName)) {
                return rm;
            }
            ++n2;
        }
        return null;
    }

    private CoreException newCoreException(String message) {
        Status status = new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), message, null);
        return new CoreException((IStatus)status);
    }

    private void prepareRoutingFile(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        Path routingFilePath = new Path(((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValue());
        routingFilePath = routingFilePath.append("routing_file");
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(configuration);
        IResourceManagerConfiguration conf = rm.getConfiguration();
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId());
        IRemoteConnectionManager rconnMgr = remoteServices.getConnectionManager();
        IRemoteConnection rconn = rconnMgr.getConnection(conf.getConnectionName());
        IRemoteFileManager remoteFileManager = remoteServices.getFileManager(rconn);
        this.fRoutingFileStore = remoteFileManager.getResource(routingFilePath.toString());
        if (this.fRoutingFileStore.fetchInfo(0, monitor).exists()) {
            try {
                this.fRoutingFileStore.delete(0, monitor);
            }
            catch (CoreException e) {
                throw this.newCoreException(e.getLocalizedMessage());
            }
            this.fRoutingFileStore.fetchInfo();
        }
    }

    private void writeRoutingFile(IPLaunch launch, IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMDebugger_12);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            OutputStream os = null;
            try {
                os = this.fRoutingFileStore.openOutputStream(0, (IProgressMonitor)subMon.newChild(10));
            }
            catch (CoreException e) {
                throw this.newCoreException(e.getLocalizedMessage());
            }
            subMon.subTask(Messages.SDMDebugger_6);
            PrintWriter pw = new PrintWriter(os);
            IPJob pJob = launch.getPJob();
            BitSet processJobRanks = pJob.getProcessJobRanks();
            pw.format("%d\n", processJobRanks.cardinality());
            int base = 50000;
            int range = 10000;
            Random random = new Random();
            for (Integer processIndex : new BitSetIterable(processJobRanks)) {
                String nodeId = pJob.getProcessNodeId(processIndex.intValue());
                IPNode node = pJob.getQueue().getResourceManager().getNodeById(nodeId);
                if (node == null) {
                    subMon.subTask(Messages.SDMDebugger_10);
                }
                while (node == null && !subMon.isCanceled()) {
                    try {
                        this.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    node = pJob.getQueue().getResourceManager().getNodeById(nodeId);
                }
                if (node == null) {
                    throw this.newCoreException(Messages.SDMDebugger_15);
                }
                String nodeName = node.getName();
                int portNumber = base + random.nextInt(range);
                pw.format("%s %s %d\n", processIndex, nodeName, portNumber);
                subMon.setWorkRemaining(100);
                subMon.worked(1);
            }
            pw.close();
            try {
                os.close();
            }
            catch (IOException e) {
                throw this.newCoreException(e.getLocalizedMessage());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected Session createSession(long timeout, IPLaunch launch, IPath corefile) throws CoreException {
        IPJob job = launch.getPJob();
        int job_size = this.getJobSize(job);
        try {
            return new Session(this.fManagerFactory, this.fRequestFactory, this.fEventFactory, this.fModelFactory, launch.getLaunchConfiguration(), timeout, this.getPDIDebugger(), job.getID(), job_size);
        }
        catch (PDIException e) {
            throw this.newCoreException(e.getLocalizedMessage());
        }
    }
}

