/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredFileStore
implements IDeferredWorkbenchAdapter {
    private IFileStore fileStore;
    private IFileInfo fileInfo = null;
    private ImageDescriptor image = null;

    public DeferredFileStore(IFileStore store) {
        this(store, null);
    }

    public DeferredFileStore(IFileStore store, IFileInfo info) {
        this.fileStore = store;
        this.fileInfo = info;
    }

    public Object[] getChildren(Object o) {
        try {
            IFileStore[] stores = this.fileStore.childStores(0, null);
            Object[] def = new DeferredFileStore[stores.length];
            int i = 0;
            while (i < stores.length) {
                def[i] = new DeferredFileStore(stores[i]);
                ++i;
            }
            return def;
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        FileSystemElement element;
        IWorkbenchAdapter adapter;
        if (this.fileInfo == null) {
            this.fileInfo = this.fileStore.fetchInfo();
        }
        if (this.image == null && (adapter = this.getAdapter(element = new FileSystemElement(this.fileStore.getName(), null, this.fileInfo.isDirectory()))) != null) {
            this.image = adapter.getImageDescriptor(object);
        }
        return this.image;
    }

    protected IWorkbenchAdapter getAdapter(Object element) {
        return (IWorkbenchAdapter)PTPRemoteCorePlugin.getAdapter((Object)element, IWorkbenchAdapter.class);
    }

    public String getLabel(Object o) {
        return this.fileStore.getName();
    }

    public Object getParent(Object o) {
        return this.fileStore.getParent();
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        ArrayList<DeferredFileStore> children = new ArrayList<DeferredFileStore>();
        try {
            IFileInfo[] childInfos;
            IFileInfo[] iFileInfoArray = childInfos = this.fileStore.childInfos(0, monitor);
            int n = childInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo info = iFileInfoArray[n2];
                children.add(new DeferredFileStore(this.fileStore.getChild(info.getName()), info));
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        collector.add(children.toArray(), monitor);
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        if (this.fileInfo == null) {
            this.fileInfo = this.fileStore.fetchInfo();
        }
        return this.fileInfo.isDirectory();
    }

    public IFileStore getFileStore() {
        return this.fileStore;
    }
}

