/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteOperation;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.IRemotePortForwardingTools;
import org.eclipse.ptp.remotetools.core.IRemoteStatusTools;
import org.eclipse.ptp.remotetools.core.IRemoteTunnel;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.RemoteTunnel;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.CopyTools;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionTools;
import org.eclipse.ptp.remotetools.internal.ssh.FileTools;
import org.eclipse.ptp.remotetools.internal.ssh.PathTools;
import org.eclipse.ptp.remotetools.internal.ssh.PortForwardingTools;
import org.eclipse.ptp.remotetools.internal.ssh.StatusTools;

public class ExecutionManager
implements IRemoteExecutionManager {
    Set<IRemoteTunnel> tunnels = new HashSet<IRemoteTunnel>();
    Set<IRemoteOperation> executions = new HashSet<IRemoteOperation>();
    protected final Connection connection;
    protected IRemoteExecutionTools executionTools = null;
    protected IRemoteFileTools fileTools = null;
    protected IRemoteCopyTools copyTools = null;
    protected IRemotePathTools pathTools = null;
    protected IRemoteStatusTools statusTools = null;
    protected IRemotePortForwardingTools portForwardingTools = null;
    private static final int minPort = 10000;
    private static final int maxPort = 65000;
    private static int autoActualPort = 10000;
    private boolean cancelFlag = false;

    private static synchronized int getNewPortNumber() {
        if (autoActualPort == 65000) {
            autoActualPort = 10000;
        }
        return autoActualPort++;
    }

    protected ExecutionManager(Connection connection) throws RemoteConnectionException {
        this.connection = connection;
    }

    public synchronized void cancel() {
        ArrayList<IRemoteOperation> operations = new ArrayList<IRemoteOperation>(this.executions);
        for (IRemoteOperation operation : operations) {
            operation.cancel();
        }
        this.cancelFlag = true;
    }

    public synchronized void resetCancel() {
        this.cancelFlag = false;
    }

    public synchronized void close() {
        this.cancel();
        while (this.tunnels.size() > 0) {
            Iterator<IRemoteTunnel> iterator = this.tunnels.iterator();
            IRemoteTunnel tunnel = iterator.next();
            try {
                this.releaseTunnel(tunnel);
            }
            catch (RemoteConnectionException remoteConnectionException) {}
        }
        this.connection.getForwardingPool().disconnect(this);
        ArrayList<IRemoteOperation> operations = new ArrayList<IRemoteOperation>(this.executions);
        for (IRemoteOperation operation : operations) {
            operation.close();
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public IRemoteExecutionTools getExecutionTools() throws RemoteConnectionException {
        if (this.executionTools == null) {
            this.executionTools = new ExecutionTools(this);
        }
        return this.executionTools;
    }

    public IRemoteFileTools getRemoteFileTools() throws RemoteConnectionException {
        if (this.fileTools == null) {
            this.fileTools = new FileTools(this);
        }
        return this.fileTools;
    }

    public IRemoteCopyTools getRemoteCopyTools() throws RemoteConnectionException {
        if (this.copyTools == null) {
            this.copyTools = new CopyTools(this);
        }
        return this.copyTools;
    }

    public IRemotePathTools getRemotePathTools() {
        if (this.pathTools == null) {
            this.pathTools = new PathTools(this);
        }
        return this.pathTools;
    }

    public IRemoteStatusTools getRemoteStatusTools() throws RemoteConnectionException {
        if (this.statusTools == null) {
            this.statusTools = new StatusTools(this);
        }
        return this.statusTools;
    }

    public synchronized IRemoteTunnel createTunnel(int localPort, String addressOnRemoteHost, int portOnRemoteHost) throws RemoteConnectionException, LocalPortBoundException, CancelException {
        this.test();
        this.testCancel();
        RemoteTunnel tunnel = this.connection.createTunnel(localPort, addressOnRemoteHost, portOnRemoteHost);
        this.tunnels.add(tunnel);
        return tunnel;
    }

    public synchronized IRemoteTunnel createTunnel(String addressOnRemoteHost, int portOnRemoteHost) throws RemoteConnectionException, LocalPortBoundException, CancelException {
        int storedPort;
        this.test();
        this.testCancel();
        int newGeneratedPort = storedPort = ExecutionManager.getNewPortNumber();
        while (true) {
            try {
                IRemoteTunnel tunnel = this.createTunnel(newGeneratedPort, addressOnRemoteHost, portOnRemoteHost);
                return tunnel;
            }
            catch (LocalPortBoundException localPortBoundException) {
                if ((newGeneratedPort = ExecutionManager.getNewPortNumber()) != storedPort) continue;
                throw new LocalPortBoundException(Messages.ExecutionManager_CreateTunnel_AllLocalPortsBusy);
            }
            break;
        }
    }

    public synchronized void releaseTunnel(IRemoteTunnel tunnel) throws RemoteConnectionException {
        this.test();
        this.connection.releaseTunnel((RemoteTunnel)tunnel);
        this.tunnels.remove(tunnel);
    }

    protected synchronized void registerOperation(IRemoteOperation operation) {
        this.executions.add(operation);
    }

    protected synchronized void unregisterOperation(IRemoteOperation operation) {
        this.executions.remove(operation);
    }

    protected void test() throws RemoteConnectionException {
        this.connection.test();
    }

    protected void testCancel() throws CancelException {
        if (this.cancelFlag) {
            throw new CancelException();
        }
    }

    public IRemotePortForwardingTools getPortForwardingTools() throws RemoteConnectionException {
        if (this.portForwardingTools == null) {
            this.portForwardingTools = new PortForwardingTools(this);
        }
        return this.portForwardingTools;
    }
}

