/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.views.vpgproblems.CopyMarkedFileAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.ErrorWarningFilterAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.Messages;
import org.eclipse.photran.internal.ui.views.vpgproblems.OpenMarkedFileAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.SelectedResourceFilterAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.ShowFullMessageAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.TableSorter;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemContentProvider;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemContextMenu;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemLabelProvider;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGSchedulingRule;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPGProblemView
extends ViewPart
implements VPGLog.ILogListener {
    private static RecreateMarkers markersTask = null;
    private TableViewer tableViewer = null;
    private TableSorter tableSorter = null;
    private Clipboard clipboard = null;
    private CopyMarkedFileAction copyAction = null;
    private OpenMarkedFileAction openAction = null;
    private ShowFullMessageAction showAction = null;
    private ErrorWarningFilterAction warningsFilterAction = null;
    private ErrorWarningFilterAction errorsFilterAction = null;
    private SelectedResourceFilterAction selectionFilterAction = null;
    public int[] markerCount = new int[3];

    public void createPartControl(Composite parent) {
        GridLayout overallLayout = new GridLayout(1, false);
        parent.setLayout((Layout)overallLayout);
        this.createTableViewer(parent);
        this.createTableColumns(this.tableViewer);
        this.setTableGridData();
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        MenuManager manager = this.createMenuManager();
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new VPGProblemContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new VPGProblemLabelProvider());
        PhotranVPG.getInstance().log.addLogListener((VPGLog.ILogListener)this);
        this.createToolbarButtons();
        this.initEvents();
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 66306);
        this.tableSorter = new TableSorter();
        this.tableViewer.setComparator((ViewerComparator)this.tableSorter);
    }

    private MenuManager createMenuManager() {
        VPGProblemContextMenu manager = new VPGProblemContextMenu(this.getViewSite());
        this.tableViewer.getTable().setMenu(manager.createContextMenu((Control)this.tableViewer.getTable()));
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogChange() {
        VPGProblemView vPGProblemView = this;
        synchronized (vPGProblemView) {
            if (markersTask != null) {
                return;
            }
            markersTask = new RecreateMarkers();
            markersTask.setRule(MultiRule.combine((ISchedulingRule)VPGSchedulingRule.getInstance(), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            markersTask.schedule();
        }
    }

    void setErrorWarningFilterButtonText() {
        if (this.warningsFilterAction != null && this.errorsFilterAction != null) {
            if (!this.selectionFilterAction.isChecked()) {
                this.warningsFilterAction.setText(Messages.bind((String)Messages.VPGProblemView_nWarnings, (Object)this.markerCount[1]));
                this.errorsFilterAction.setText(Messages.bind((String)Messages.VPGProblemView_nErrors, (Object)this.markerCount[2]));
            } else {
                this.warningsFilterAction.setText(Messages.VPGProblemView_Warnings);
                this.errorsFilterAction.setText(Messages.VPGProblemView_Errors);
            }
        }
    }

    TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void setTableGridData() {
        GridData tableData = new GridData();
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        this.tableViewer.getTable().setLayoutData((Object)tableData);
    }

    private void resetMarkerCount() {
        int i = 0;
        while (i < this.markerCount.length) {
            this.markerCount[i] = 0;
            ++i;
        }
    }

    private void countMarkers(List<IMarker> markers) {
        this.resetMarkerCount();
        for (IMarker marker : markers) {
            int sev = MarkerUtilities.getSeverity((IMarker)marker);
            if (sev != 2 && sev != 1) continue;
            int n = sev;
            this.markerCount[n] = this.markerCount[n] + 1;
        }
    }

    public void createActions() {
        this.copyAction = new CopyMarkedFileAction(this);
        this.openAction = new OpenMarkedFileAction((IWorkbenchSite)this.getSite());
        this.showAction = new ShowFullMessageAction((IWorkbenchSite)this.getSite());
        this.warningsFilterAction = new ErrorWarningFilterAction((StructuredViewer)this.tableViewer, 1);
        this.errorsFilterAction = new ErrorWarningFilterAction((StructuredViewer)this.tableViewer, 2);
        this.selectionFilterAction = new SelectedResourceFilterAction(this);
    }

    private void addActionsToToolbar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.errorsFilterAction);
        toolBarManager.add((IAction)this.warningsFilterAction);
        toolBarManager.add((IAction)this.selectionFilterAction);
        toolBarManager.add((IAction)this.openAction);
        toolBarManager.add((IAction)this.copyAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.showAction);
    }

    private void addTableViewerSelectionChangeListener() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                boolean isEnabled = !e.getSelection().isEmpty();
                VPGProblemView.this.openAction.setEnabled(isEnabled);
                VPGProblemView.this.copyAction.setEnabled(isEnabled);
                VPGProblemView.this.showAction.setEnabled(isEnabled);
            }
        });
    }

    private void createToolbarButtons() {
        this.createActions();
        this.openAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.showAction.setEnabled(false);
        this.addActionsToToolbar();
        this.addTableViewerSelectionChangeListener();
    }

    private TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        VPGViewColumn[] vPGViewColumnArray = VPGViewColumn.values();
        int n = vPGViewColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPGViewColumn col = vPGViewColumnArray[n2];
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(col.width, true));
            ++n2;
        }
        return layout;
    }

    private void createTableColumns(TableViewer viewer) {
        Table table = viewer.getTable();
        TableLayout layout = this.createTableLayout();
        table.setLayout((Layout)layout);
        VPGViewColumn[] vPGViewColumnArray = VPGViewColumn.values();
        int n = vPGViewColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPGViewColumn vpgCol = vPGViewColumnArray[n2];
            TableColumn viewerCol = new TableViewerColumn(viewer, 0).getColumn();
            viewerCol.setText(vpgCol.name);
            viewerCol.setToolTipText(vpgCol.name);
            viewerCol.setAlignment(16384);
            viewerCol.setResizable(true);
            viewerCol.setMoveable(true);
            viewerCol.addSelectionListener((SelectionListener)new ColumnSelectionListener(viewerCol, vpgCol, viewer));
            ++n2;
        }
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private void initEvents() {
        this.tableViewer.getTable().addMouseListener((MouseListener)new DoubleClickListener());
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getDisplay());
        }
        return this.clipboard;
    }

    private Display getDisplay() {
        return this.getSite().getWorkbenchWindow().getWorkbench().getDisplay();
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        if (this.selectionFilterAction != null) {
            this.selectionFilterAction.dispose();
        }
        super.dispose();
    }

    private final class ColumnSelectionListener
    extends SelectionAdapter {
        private final TableColumn column;
        private final VPGViewColumn col;
        private final TableViewer viewer;

        private ColumnSelectionListener(TableColumn column, VPGViewColumn col, TableViewer viewer) {
            this.column = column;
            this.col = col;
            this.viewer = viewer;
        }

        public void widgetSelected(SelectionEvent e) {
            VPGProblemView.this.tableSorter.setColumn(this.col.ordinal());
            int dir = this.viewer.getTable().getSortDirection();
            dir = this.viewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 1024;
            this.viewer.getTable().setSortDirection(dir);
            this.viewer.getTable().setSortColumn(this.column);
            this.viewer.refresh();
        }
    }

    private final class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        public void mouseDoubleClick(MouseEvent dblClick) {
            Table t = (Table)dblClick.getSource();
            TableItem[] tableItemArray = t.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() instanceof IMarker) {
                    this.openMarker((IMarker)item.getData());
                }
                ++n2;
            }
        }

        private void openMarker(IMarker marker) {
            if (marker.getResource() != null) {
                new OpenMarkedFileAction((IWorkbenchSite)VPGProblemView.this.getViewSite()).run(marker);
            }
        }
    }

    private class RecreateMarkers
    extends WorkspaceJob {
        private RecreateMarkers() {
            super(Messages.VPGProblemView_UpdatingProblemsViewMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) {
            VPGProblemView.this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    List markers = PhotranVPG.getInstance().recomputeErrorLogMarkers();
                    Table t = VPGProblemView.this.tableViewer.getTable();
                    t.removeAll();
                    t.update();
                    VPGProblemView.this.tableViewer.setInput((Object)markers);
                    VPGProblemView.this.countMarkers(markers);
                    VPGProblemView.this.setErrorWarningFilterButtonText();
                }
            });
            VPGProblemView vPGProblemView = VPGProblemView.this;
            synchronized (vPGProblemView) {
                markersTask = null;
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VPGViewColumn {
        DESCRIPTION(Messages.VPGProblemView_DescriptionColumnHeader, 44),
        RESOURCE(Messages.VPGProblemView_ResourceColumnHeader, 10),
        PATH(Messages.VPGProblemView_PathColumnHeader, 20);

        public final String name;
        public final int width;

        private VPGViewColumn(String name, int widthInPixels) {
            this.name = name;
            this.width = widthInPixels;
        }
    }
}

