/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTFieldReference
extends ASTNode
implements ICPPASTFieldReference,
IASTAmbiguityParent,
IASTCompletionContext {
    private boolean isTemplate;
    private IASTExpression owner;
    private IASTName name;
    private boolean isDeref;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTFieldReference() {
    }

    public CPPASTFieldReference(IASTName name, IASTExpression owner) {
        this.setFieldName(name);
        this.setFieldOwner(owner);
    }

    public CPPASTFieldReference copy() {
        CPPASTFieldReference copy = new CPPASTFieldReference();
        copy.setFieldName(this.name == null ? null : this.name.copy());
        copy.setFieldOwner(this.owner == null ? null : this.owner.copy());
        copy.isTemplate = this.isTemplate;
        copy.isDeref = this.isDeref;
        copy.setOffsetAndLength(this);
        return copy;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(boolean value) {
        this.assertNotFrozen();
        this.isTemplate = value;
    }

    public IASTExpression getFieldOwner() {
        return this.owner;
    }

    public void setFieldOwner(IASTExpression expression) {
        this.assertNotFrozen();
        this.owner = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FIELD_OWNER);
        }
    }

    public IASTName getFieldName() {
        return this.name;
    }

    public void setFieldName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(FIELD_NAME);
        }
    }

    public boolean isPointerDereference() {
        return this.isDeref;
    }

    public void setIsPointerDereference(boolean value) {
        this.assertNotFrozen();
        this.isDeref = value;
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            if (!this.isDeref) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            ArrayList<ICPPFunction> functionBindings = new ArrayList<ICPPFunction>();
            try {
                CPPSemantics.getChainedMemberAccessOperatorReturnType(this, functionBindings);
            }
            catch (DOMException dOMException) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            if (functionBindings.isEmpty()) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            this.implicitNames = new IASTImplicitName[functionBindings.size()];
            int i = 0;
            int n = functionBindings.size();
            while (i < n) {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(OverloadableOperator.ARROW, (IASTNode)this);
                operatorName.setBinding((IBinding)functionBindings.get(i));
                operatorName.computeOperatorOffsets(this.owner, true);
                this.implicitNames[i] = operatorName;
                ++i;
            }
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.owner != null && !this.owner.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.owner) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.owner = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IASTName name = this.getFieldName();
        IBinding binding = name.resolvePreBinding();
        try {
            if (binding instanceof IVariable) {
                IType e2 = ((IVariable)binding).getType();
                if (binding instanceof ICPPField && !((ICPPField)binding).isStatic()) {
                    IType e1 = this.getFieldOwner().getExpressionType();
                    if (this.isPointerDereference() && (e1 = SemanticUtil.getNestedType(e1, 7)) instanceof IPointerType) {
                        e1 = ((IPointerType)e1).getType();
                    }
                    CVQualifier cvq1 = SemanticUtil.getCVQualifier(e1);
                    if (((ICPPField)binding).isMutable()) {
                        CVQualifier cvq2 = SemanticUtil.getCVQualifier(e2);
                        if (cvq2.isConst()) {
                            e2 = SemanticUtil.getNestedType(e2, 11);
                        }
                        e2 = SemanticUtil.addQualifiers(e2, false, cvq1.isVolatile() || cvq2.isVolatile());
                    } else {
                        e2 = SemanticUtil.addQualifiers(e2, cvq1.isConst(), cvq1.isVolatile());
                    }
                }
                return SemanticUtil.mapToAST(e2, this);
            }
            if (binding instanceof IEnumerator) {
                return ((IEnumerator)binding).getType();
            }
            if (binding instanceof IFunction) {
                return SemanticUtil.mapToAST(((IFunction)binding).getType(), this);
            }
            if (binding instanceof ICPPUnknownBinding) {
                return CPPUnknownClass.createUnnamedInstance();
            }
            if (binding instanceof IProblemBinding) {
                return (IType)((Object)binding);
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }

    public boolean isLValue() {
        block6: {
            block7: {
                IBinding b;
                block5: {
                    if (this.isPointerDereference()) {
                        return true;
                    }
                    b = this.getFieldName().resolveBinding();
                    try {
                        if (!(b instanceof ICPPMember) || !((ICPPMember)b).isStatic()) break block5;
                        return true;
                    }
                    catch (DOMException dOMException) {}
                }
                if (!(b instanceof IVariable)) break block6;
                if (!(SemanticUtil.getNestedType(((IVariable)b).getType(), 1) instanceof ICPPReferenceType)) break block7;
                return true;
            }
            return this.getFieldOwner().isLValue();
        }
        return false;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            ICPPMethod method;
            IBinding binding = iBindingArray[n3];
            if (!(binding instanceof ICPPMethod) || !(method = (ICPPMethod)binding).isImplicit()) {
                filtered.add(binding);
            }
            ++n3;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }
}

