/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.actions.AnalysisDropdownHandler;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandler;
import org.eclipse.ptp.pldt.common.util.ViewActivator;
import org.eclipse.ptp.pldt.mpi.analysis.actions.MPIAnalysisManager;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIResourceCollector;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.messages.Messages;

public class RunAnalyseMPIAnalysiscommandHandler
extends RunAnalyseHandler {
    protected MPICallGraph callGraph_ = null;
    boolean traceOn = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean foundError = false;
        this.getSelection(event);
        AnalysisDropdownHandler.setLastHandledAnalysis((RunAnalyseHandler)this, (IStructuredSelection)this.selection);
        if (this.selection == null || this.selection.isEmpty()) {
            MessageDialog.openWarning(null, (String)Messages.RunAnalyseMPIAnalysiscommandHandler_noFilesSelectedForAnalysis, (String)Messages.RunAnalyseMPIAnalysiscommandHandler_pleaseSelect);
            return null;
        }
        foundError = this.analyseBarriers(this.selection, true);
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIBarrierMatchingSetTableView");
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIBarrierTableView");
        if (foundError) {
            ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIErrorView");
        }
        return null;
    }

    public boolean analyseBarriers(IStructuredSelection selection, boolean reportErrors) {
        this.callGraph_ = new MPICallGraph();
        for (Object obj : selection) {
            if (!(obj instanceof IAdaptable)) continue;
            IResource res = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            if (this.traceOn) {
                System.out.println("resourceCollector on " + res.getName());
            }
            if (res == null) continue;
            this.resourceCollector(res);
        }
        MPIAnalysisManager manager = new MPIAnalysisManager(this.callGraph_);
        boolean foundError = manager.run(reportErrors);
        return foundError;
    }

    protected boolean resourceCollector(IResource resource) {
        boolean foundError = false;
        if (resource instanceof IFile) {
            try {
                resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException coreException) {}
            IFile file = (IFile)resource;
            String filename = file.getName();
            if (filename.endsWith(".c")) {
                if (this.traceOn) {
                    System.out.println("resourceCollector on c file: " + file.getName());
                }
                MPIResourceCollector rc = new MPIResourceCollector((ICallGraph)this.callGraph_, file);
                rc.run();
            }
            return true;
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                IResource[] mems = container.members();
                int i = 0;
                while (i < mems.length) {
                    if (this.traceOn) {
                        System.out.println("descend to " + mems[i].getName());
                    }
                    boolean err = this.resourceCollector(mems[i]);
                    foundError = foundError || err;
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            String name = "";
            if (resource instanceof IResource) {
                IResource res = resource;
                IPath path = res.getProjectRelativePath();
                name = path.toString();
            }
            System.out.println("Cancelled by User, aborting analysis on subsequent files... " + name);
        }
        return foundError;
    }
}

