/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.utils.stream.ILineStreamListener;
import org.eclipse.ptp.remotetools.utils.stream.TextStreamObserver;

public class ControlChannel
implements ILineStreamListener {
    private static final String markerPID = "PID=";
    private static final String markerPIID = "PIID=";
    private static final String markerSSH = "SSH_TTY=";
    private final Pattern pidPattern = Pattern.compile("PID=(\\p{Digit}+) PIID=(\\p{Digit}+)");
    private final Pattern terminalPathPattern = Pattern.compile("SSH_TTY=(/.+)");
    private OutputStream outputToControlTerminalInput;
    private InputStream inputFromControlTerminalOutput;
    private ChannelExec shell;
    private String controlTerminalPath;
    private TextStreamObserver controlTerminalObserver;
    private final Connection connection;

    public ControlChannel(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            this.shell = this.connection.createExecChannel(false);
            this.shell.setPty(true);
            this.shell.setCommand("/bin/sh");
            this.inputFromControlTerminalOutput = this.shell.getInputStream();
            this.outputToControlTerminalInput = this.shell.getOutputStream();
            this.shell.connect();
        }
        catch (JSchException e) {
            this.close();
            throw new RemoteConnectionException(Messages.ControlChannel_Open_FailedCreateAuxiliaryShell, e);
        }
        catch (IOException e) {
            this.close();
            throw new RemoteConnectionException(Messages.ControlChannel_Open_FailedCreateIOStream, e);
        }
        this.controlTerminalObserver = new TextStreamObserver(this.inputFromControlTerminalOutput, (ILineStreamListener)this);
        this.controlTerminalObserver.start();
        try {
            this.outputToControlTerminalInput.write("export PS1=\n".getBytes());
            String command = "/bin/sh -c 'echo \"SSH_TTY=$SSH_TTY\"'\n";
            this.outputToControlTerminalInput.write(command.getBytes());
            this.outputToControlTerminalInput.flush();
        }
        catch (IOException e) {
            throw new RemoteConnectionException(Messages.ControlChannel_Open_FailedSendInitCommands, e);
        }
        Debug.println2(Messages.ControlChannel_Debug_StartedWaitingControlTerminalPath);
        ControlChannel controlChannel = this;
        synchronized (controlChannel) {
            while (!monitor.isCanceled() && this.controlTerminalPath == null) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException e) {
                    throw new RemoteConnectionException(Messages.ControlChannel_Open_WaitControlTerminalPathInterrupted, e);
                }
            }
        }
        if (monitor.isCanceled()) {
            this.close();
            throw new RemoteConnectionException(Messages.ControlChannel_Open_WaitControlTerminalPathInterrupted);
        }
        Debug.println2(String.valueOf(Messages.ControlChannel_Debug_ReceivedControlTerminalPath) + this.controlTerminalPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine(String line) {
        Debug.println2(String.valueOf(Messages.ControlChannel_Debug_ControlConnectionReceived) + line);
        Matcher pidmatch = this.pidPattern.matcher(line);
        if (pidmatch.find()) {
            String pid = pidmatch.group(1);
            String piid = pidmatch.group(2);
            this.connection.setPID(Integer.parseInt(piid), Integer.parseInt(pid));
            return;
        }
        Matcher terminalPathMatcher = this.terminalPathPattern.matcher(line);
        if (terminalPathMatcher.find()) {
            ControlChannel controlChannel = this;
            synchronized (controlChannel) {
                this.controlTerminalPath = terminalPathMatcher.group(1);
                Debug.println2(String.valueOf(Messages.ControlChannel_0) + this.controlTerminalPath);
                this.notifyAll();
            }
        }
    }

    public void streamClosed() {
    }

    public void streamError(Exception e) {
        Debug.println2(String.valueOf(Messages.ControlChannel_Debug_ControlConnectionReceived) + e);
    }

    public synchronized String getControlTerminalPath() {
        return this.controlTerminalPath;
    }

    public void killRemoteProcess(int pid) {
        if (pid > 0) {
            try {
                this.outputToControlTerminalInput.write(new String("kill -9 " + pid + "\n").getBytes());
                this.outputToControlTerminalInput.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized String getKillablePrefix(int internaID) {
        return "echo \"PID=$$ PIID=" + Integer.toString(internaID) + "\" > " + this.controlTerminalPath;
    }

    public void close() {
        if (this.controlTerminalObserver != null) {
            this.controlTerminalObserver.kill();
        }
        this.controlTerminalObserver = null;
        this.outputToControlTerminalInput = null;
        this.inputFromControlTerminalOutput = null;
        if (this.shell != null) {
            this.shell.disconnect();
        }
        this.shell = null;
    }

    public boolean isConnected() {
        return this.shell != null && this.shell.isConnected();
    }
}

