/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.TypeInfoSearchElement;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchElement;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchListContentProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchListLabelProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchMatchAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchTreeContentProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchTreeLabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoteSearchViewPage
extends AbstractTextSearchViewPage {
    private IPDOMSearchContentProvider contentProvider;

    public RemoteSearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public RemoteSearchViewPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new RemoteSearchTreeContentProvider();
        viewer.setComparator((ViewerComparator)new SearchViewerComparator());
        viewer.setContentProvider((IContentProvider)((RemoteSearchTreeContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new RemoteSearchTreeLabelProvider(this));
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new RemoteSearchListContentProvider();
        viewer.setComparator((ViewerComparator)new SearchViewerComparator());
        viewer.setContentProvider((IContentProvider)((RemoteSearchListContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new RemoteSearchListLabelProvider(this));
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (!(match instanceof RemoteSearchMatchAdapter)) {
            return;
        }
        try {
            Object element = ((RemoteSearchMatchAdapter)match).getElement();
            IIndexFileLocation ifl = ((RemoteSearchElement)element).getLocation();
            IPath path = IndexLocationFactory.getPath((IIndexFileLocation)ifl);
            IEditorPart editor = null;
            editor = path != null ? EditorUtility.openInEditor((IPath)path, null) : EditorUtility.openInEditor((URI)ifl.getURI(), null);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private class SearchViewerComparator
    extends ViewerComparator {
        private SearchViewerComparator() {
        }

        public int category(Object element) {
            if (element instanceof IStatus) {
                return -1000;
            }
            if (element instanceof TypeInfoSearchElement) {
                TypeInfoSearchElement searchElement = (TypeInfoSearchElement)element;
                int type = searchElement.getTypeInfo().getCElementType();
                if (type < 0) {
                    type = 0;
                }
                return type;
            }
            if (element instanceof ICElement) {
                int type = ((ICElement)element).getElementType();
                if (type < 0) {
                    type = 0;
                }
                return Math.min(Math.max(0, type), 900);
            }
            if (element instanceof IPath || element instanceof IIndexFileLocation) {
                return 999;
            }
            if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
                return 1000;
            }
            return 2000;
        }
    }
}

