/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.messages.Messages;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PldtAstVisitor
extends CASTVisitor {
    public static String ARTIFACT_CALL = "Artifact Call";
    public static String ARTIFACT_CONSTANT = "Artifact Constant";
    protected static String ARTIFACT_NAME = "Artifact Name";
    protected static String PREFIX = "";
    private static boolean traceOn = false;
    private static boolean dontAskToModifyIncludePathAgain = false;
    protected boolean allowPrefixOnlyMatch = false;
    private List<String> includes_;
    private final String fileName;
    private final ScanReturn scanReturn;

    public PldtAstVisitor(List<String> includes, String fileName, boolean prefixOnlyMatch, ScanReturn scanReturn) {
        this.includes_ = includes;
        this.fileName = fileName;
        this.scanReturn = scanReturn;
        dontAskToModifyIncludePathAgain = false;
        this.allowPrefixOnlyMatch = prefixOnlyMatch;
        if (!traceOn) {
            traceOn = CommonPlugin.getTraceOn();
        }
        if (traceOn) {
            System.out.println("PldtAstVisitor, traceOn=" + traceOn);
        }
    }

    public PldtAstVisitor(List<String> includes, String fileName, ScanReturn scanReturn) {
        this(includes, fileName, false, scanReturn);
    }

    public int visit(IASTStatement statement) {
        if (this.preprocessorIncluded((IASTNode)statement)) {
            return 1;
        }
        return 3;
    }

    public int visit(IASTDeclaration declaration) {
        if (this.preprocessorIncluded((IASTNode)declaration)) {
            return 1;
        }
        return 3;
    }

    public void processFuncName(IASTName funcName, IASTExpression astExpr) {
        SourceInfo sourceInfo;
        String strName = funcName.toString();
        if ((this.allowPrefixOnlyMatch && this.matchesPrefix(strName) || this.isArtifact(funcName)) && (sourceInfo = this.getSourceInfo(astExpr, 1)) != null) {
            String rawName;
            String artName;
            if (traceOn) {
                System.out.println("found artifact: " + funcName.toString());
            }
            if (!(artName = funcName.toString()).equals(rawName = funcName.getRawSignature())) {
                if (rawName.length() == 0) {
                    rawName = "  ";
                }
                artName = String.valueOf(artName) + "  (" + rawName + ")";
            }
            this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, artName, sourceInfo));
        }
    }

    public void processExprWithConstant(IASTExpression astExpr) {
        SourceInfo sourceInfo;
        IASTName funcName = ((IASTIdExpression)astExpr).getName();
        String strName = funcName.toString();
        if ((this.allowPrefixOnlyMatch && this.matchesPrefix(strName) || this.isArtifact(funcName)) && (sourceInfo = this.getSourceInfo(astExpr, 1)) != null) {
            this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, funcName.toString(), sourceInfo));
        }
    }

    protected boolean isArtifact(IASTName funcName) {
        IBinding binding = funcName.resolveBinding();
        String name = binding.getName();
        String rawSig = funcName.getRawSignature();
        name = this.chooseName(name, rawSig);
        IASTTranslationUnit tu = funcName.getTranslationUnit();
        IName[] names = tu.getDeclarations(binding);
        int i = 0;
        while (i < names.length) {
            boolean addit;
            IName name2 = names[i];
            IASTFileLocation floc = name2.getFileLocation();
            if (floc == null) {
                if (traceOn) {
                    System.out.println("PldtAstVisitor  IASTFileLocn null for " + name2 + " (" + funcName + ")");
                }
                return false;
            }
            String filename = floc.getFileName();
            Path path = new Path(filename);
            if (this.isInIncludePath((IPath)path)) {
                return true;
            }
            if (traceOn) {
                System.out.println(String.valueOf(name) + " was found in " + path + " but  PLDT preferences have been set to only include: " + this.includes_.toString());
            }
            if (this.allowIncludePathAdd() && (addit = this.addIncludePath((IPath)path, name, dontAskToModifyIncludePathAgain))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String chooseName(String bindingName, String rawSignature) {
        String name = bindingName;
        if (bindingName.length() == 0) {
            name = rawSignature;
        }
        return name;
    }

    public void processMacroLiteral(IASTLiteralExpression expression) {
        IASTNodeLocation[] locations = expression.getNodeLocations();
        if (locations.length == 1 && locations[0] instanceof IASTMacroExpansion) {
            SourceInfo sourceInfo;
            IASTMacroExpansion astMacroExpansion = (IASTMacroExpansion)locations[0];
            IASTPreprocessorMacroDefinition preprocessorMacroDefinition = astMacroExpansion.getMacroDefinition();
            String shortName = preprocessorMacroDefinition.getName().toString();
            IASTNodeLocation[] preprocessorLocations = preprocessorMacroDefinition.getNodeLocations();
            while (preprocessorLocations.length == 1 && preprocessorLocations[0] instanceof IASTMacroExpansion) {
                preprocessorLocations = ((IASTMacroExpansion)preprocessorLocations[0]).getMacroDefinition().getNodeLocations();
            }
            if (preprocessorLocations.length == 1 && this.isInIncludePath((IPath)new Path(preprocessorLocations[0].asFileLocation().getFileName())) && (sourceInfo = this.getSourceInfo(astMacroExpansion)) != null) {
                this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, shortName, sourceInfo));
            }
        }
    }

    private boolean isInIncludePath(IPath includeFilePath) {
        if (includeFilePath == null) {
            return false;
        }
        for (String includeDir : this.includes_) {
            Path includePath = new Path(includeDir);
            if (traceOn) {
                System.out.println("PldtAstVisitor: is " + includeFilePath + " found in " + includeDir + "?");
            }
            if (!includePath.isPrefixOf(includeFilePath)) continue;
            return true;
        }
        return false;
    }

    private SourceInfo getSourceInfo(IASTExpression astExpr, int constructType) {
        SourceInfo sourceInfo = null;
        IASTNodeLocation[] locations = astExpr.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
            } else if (locations[0] instanceof IASTMacroExpansion) {
                IASTMacroExpansion me = (IASTMacroExpansion)locations[0];
                astFileLocation = me.asFileLocation();
            }
            if (astFileLocation != null) {
                sourceInfo = new SourceInfo();
                sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                sourceInfo.setStart(astFileLocation.getNodeOffset());
                sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                sourceInfo.setConstructType(constructType);
            }
        }
        return sourceInfo;
    }

    private SourceInfo getSourceInfo(IASTMacroExpansion iASTMacroExpansion) {
        SourceInfo sourceInfo = null;
        IASTFileLocation iASTFileLocation = iASTMacroExpansion.asFileLocation();
        sourceInfo = new SourceInfo();
        sourceInfo.setStartingLine(iASTFileLocation.getStartingLineNumber());
        sourceInfo.setStart(iASTFileLocation.getNodeOffset());
        sourceInfo.setEnd(iASTFileLocation.getNodeOffset() + iASTFileLocation.getNodeLength());
        sourceInfo.setConstructType(2);
        return sourceInfo;
    }

    private boolean preprocessorIncluded(IASTNode astNode) {
        String tuFilePath;
        if (astNode.getFileLocation() == null) {
            return false;
        }
        String location = astNode.getFileLocation().getFileName();
        return !location.equals(tuFilePath = astNode.getTranslationUnit().getFilePath());
    }

    public void processIdExprAsLiteral(IASTIdExpression expression) {
        SourceInfo sourceInfo;
        IASTName name = expression.getName();
        String strName = name.toString();
        if ((this.allowPrefixOnlyMatch && this.matchesPrefix(strName) || this.isArtifact(name)) && (sourceInfo = this.getSourceInfo((IASTExpression)expression, 2)) != null) {
            this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, name.toString(), sourceInfo));
        }
    }

    public boolean allowIncludePathAdd() {
        return !dontAskToModifyIncludePathAgain;
    }

    protected void replaceIncludes(String includes) {
        this.includes_ = this.convertToList(includes);
    }

    public List convertToList(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> dirs = new ArrayList<String>();
        while (st.hasMoreElements()) {
            dirs.add(st.nextToken());
        }
        return dirs;
    }

    public boolean addIncludePath(IPath path, String name, boolean dontAskAgain) {
        IPreferenceStore store = this.getPreferenceStore();
        String id = this.getIncludesPrefID();
        String type = this.getTypeName();
        boolean doitThisTime = false;
        if (store == null || id == null) {
            CommonPlugin.log(4, "PLDT: Visitor subclass does not implement getPreferenceStore() or getIncludesPrefID() to return non-null values.");
            return false;
        }
        try {
            String value = store.getString(id);
            if (traceOn) {
                System.out.println("value: " + value);
            }
            if (!dontAskAgain) {
                String msg = String.valueOf(Messages.PldtAstVisitor_20) + name + Messages.PldtAstVisitor_21 + path.toString() + Messages.PldtAstVisitor_22 + type + Messages.PldtAstVisitor_23 + value + Messages.PldtAstVisitor_24;
                String title = String.valueOf(Messages.PldtAstVisitor_25) + type + Messages.PldtAstVisitor_26;
                boolean[] twoAnswers = this.askUI(title, msg, dontAskToModifyIncludePathAgain);
                doitThisTime = twoAnswers[0];
                dontAskToModifyIncludePathAgain = dontAskAgain = twoAnswers[1];
            }
            if (doitThisTime) {
                String s = File.pathSeparator;
                String parent = path.toFile().getParent();
                if (!value.endsWith(s)) {
                    value = String.valueOf(value) + s;
                }
                value = String.valueOf(value) + parent + s;
                store.putValue(id, value);
                this.replaceIncludes(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doitThisTime;
    }

    protected String getTypeName() {
        return "";
    }

    protected String getIncludesPrefID() {
        return null;
    }

    protected IPreferenceStore getPreferenceStore() {
        return null;
    }

    public boolean[] askUI(String title, String message, boolean dontAskAgain) {
        boolean[] twoAnswers = new boolean[2];
        RunGetAnswer runner = new RunGetAnswer(title, message, dontAskAgain);
        Display.getDefault().syncExec((Runnable)runner);
        boolean answer = runner.getAnswer();
        dontAskAgain = runner.getDontAskAgain();
        twoAnswers[0] = answer;
        twoAnswers[1] = dontAskAgain;
        return twoAnswers;
    }

    public boolean matchesPrefix(String name) {
        return true;
    }

    class RunGetAnswer
    implements Runnable {
        boolean answer;
        boolean dontAskAgain;
        String title;
        String message;

        RunGetAnswer(String title, String message, boolean initialToggleState) {
            this.title = title;
            this.message = message;
            this.dontAskAgain = initialToggleState;
        }

        public void run() {
            String key;
            IPreferenceStore store;
            String toggleMessage;
            MessageDialogWithToggle md;
            int retCode;
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow w = wb.getActiveWorkbenchWindow();
            Shell shell = w.getShell();
            if (shell == null) {
                Display display = CommonPlugin.getStandardDisplay();
                shell = display.getActiveShell();
            }
            this.answer = (retCode = (md = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)this.title, (String)this.message, (String)(toggleMessage = Messages.PldtAstVisitor_28), (boolean)this.dontAskAgain, store = null, key = null)).getReturnCode()) == 2;
            this.dontAskAgain = md.getToggleState();
        }

        public boolean getAnswer() {
            return this.answer;
        }

        public boolean getDontAskAgain() {
            return this.dontAskAgain;
        }
    }
}

