/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteBuildServiceProvider;
import org.eclipse.ptp.rdt.ui.wizards.IIndexFilePathChangeListener;
import org.eclipse.ptp.rdt.ui.wizards.RemoteBuildServiceFileLocationWidget;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteServicesServiceProviderContributor
implements IServiceProviderContributor {
    private IServiceProviderWorkingCopy fProviderWorkingCopy;
    private Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private IRemoteServices fSelectedProvider;
    private Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private IRemoteConnection fSelectedConnection;
    private RemoteBuildServiceFileLocationWidget fBuildConfigLocationWidget;

    public void configureServiceProvider(IServiceProvider provider, final Composite container) {
        this.fProviderWorkingCopy = null;
        if (provider instanceof IServiceProviderWorkingCopy) {
            this.fProviderWorkingCopy = (IServiceProviderWorkingCopy)provider;
            provider = ((IServiceProviderWorkingCopy)provider).getOriginal();
        }
        if (!(provider instanceof RemoteBuildServiceProvider)) {
            throw new IllegalArgumentException();
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Label providerLabel = new Label(container, 16384);
        providerLabel.setText(Messages.getString("RemoteServicesProviderSelectionDialog_1"));
        final Combo providerCombo = new Combo(container, 12);
        providerCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        String providerSelected = this.fProviderWorkingCopy.getString("RemoteBuildServiceProvider.remoteToolsProviderID", "");
        IRemoteServices[] providers = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
        int toSelect = 0;
        int k = 0;
        while (k < providers.length) {
            providerCombo.add(providers[k].getName(), k);
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            if (providerSelected.length() > 0 && providerSelected.compareTo(providers[k].getId()) == 0) {
                toSelect = k;
            }
            ++k;
        }
        providerCombo.select(toSelect);
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(toSelect);
        Label connectionLabel = new Label(container, 16384);
        connectionLabel.setText(Messages.getString("RemoteServicesProviderSelectionDialog.0"));
        final Combo connectionCombo = new Combo(container, 12);
        connectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.populateConnectionCombo(connectionCombo);
        String configPath = this.fProviderWorkingCopy.getString("RemoteBuildServiceProvider.configLocation", "");
        if (configPath.length() <= 0) {
            configPath = RemoteBuildServiceFileLocationWidget.getDefaultPath(this.fSelectedProvider, this.fSelectedConnection);
        }
        this.fBuildConfigLocationWidget = new RemoteBuildServiceFileLocationWidget(container, 0, this.fSelectedProvider, this.fSelectedConnection, configPath);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        this.fBuildConfigLocationWidget.setLayoutData(data);
        this.fBuildConfigLocationWidget.addPathListener(new IIndexFilePathChangeListener(){

            public void pathChanged(String newPath) {
                RemoteServicesServiceProviderContributor.this.updateProvider();
            }
        });
        final Button newConnectionButton = new Button(container, 8);
        newConnectionButton.setText(Messages.getString("RemoteServicesProviderSelectionDialog.1"));
        this.updateNewConnectionButtonEnabled(newConnectionButton);
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = RemoteServicesServiceProviderContributor.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(container.getShell());
                }
                RemoteServicesServiceProviderContributor.this.populateConnectionCombo(connectionCombo);
                RemoteServicesServiceProviderContributor.this.updateProvider();
            }
        });
        providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = providerCombo.getSelectionIndex();
                RemoteServicesServiceProviderContributor.this.fSelectedProvider = (IRemoteServices)RemoteServicesServiceProviderContributor.this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
                RemoteServicesServiceProviderContributor.this.populateConnectionCombo(connectionCombo);
                RemoteServicesServiceProviderContributor.this.updateNewConnectionButtonEnabled(newConnectionButton);
                RemoteServicesServiceProviderContributor.this.updateProvider();
                RemoteServicesServiceProviderContributor.this.fBuildConfigLocationWidget.update(RemoteServicesServiceProviderContributor.this.fSelectedProvider, RemoteServicesServiceProviderContributor.this.fSelectedConnection);
            }
        });
        connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = connectionCombo.getSelectionIndex();
                RemoteServicesServiceProviderContributor.this.fSelectedConnection = (IRemoteConnection)RemoteServicesServiceProviderContributor.this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
                RemoteServicesServiceProviderContributor.this.updateNewConnectionButtonEnabled(newConnectionButton);
                RemoteServicesServiceProviderContributor.this.updateProvider();
                RemoteServicesServiceProviderContributor.this.fBuildConfigLocationWidget.update(RemoteServicesServiceProviderContributor.this.fSelectedProvider, RemoteServicesServiceProviderContributor.this.fSelectedConnection);
            }
        });
        this.updateProvider();
    }

    private void updateNewConnectionButtonEnabled(Button button) {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        button.setEnabled(connectionManager != null);
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedProvider).getUIConnectionManager();
        return connectionManager;
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        connectionCombo.removeAll();
        String connection = this.fProviderWorkingCopy.getString("RemoteBuildServiceProvider.remoteToolsConnectionName", "");
        IRemoteConnection[] connections = this.fSelectedProvider.getConnectionManager().getConnections();
        int toSelect = 0;
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            if (connection.length() > 0 && connection.equals(connections[k].getName())) {
                toSelect = k;
            }
            ++k;
        }
        connectionCombo.select(toSelect);
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(toSelect);
    }

    protected void updateProvider() {
        this.fProviderWorkingCopy.putString("RemoteBuildServiceProvider.remoteToolsProviderID", this.fSelectedProvider.getId());
        String name = "";
        if (this.fSelectedConnection != null) {
            name = this.fSelectedConnection.getName();
        }
        this.fProviderWorkingCopy.putString("RemoteBuildServiceProvider.remoteToolsConnectionName", name);
        this.fProviderWorkingCopy.putString("RemoteBuildServiceProvider.configLocation", this.fBuildConfigLocationWidget.getConfigLocationPath());
    }

    public IWizard getWizard(IServiceProvider provider, IWizardPage page) {
        return null;
    }

    public WizardPage[] getWizardPages(IWizard wizard, IServiceProvider provider) {
        return null;
    }
}

