/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class TypeReference
implements ITypeReference {
    private IPath fPath;
    private IProject fProject;
    private IResource fResource;
    private IWorkingCopy fWorkingCopy;
    private int fOffset;
    private int fLength;
    public boolean offsetIsLineNumber = false;

    public TypeReference(IPath path, IProject project, int offset, int length) {
        this.fPath = path;
        this.fProject = project;
        this.fWorkingCopy = null;
        this.fResource = null;
        this.fOffset = offset;
        this.fLength = length;
    }

    public TypeReference(IResource resource, IProject project, int offset, int length) {
        this.fPath = null;
        this.fProject = project;
        this.fWorkingCopy = null;
        this.fResource = resource;
        this.fOffset = offset;
        this.fLength = length;
    }

    public TypeReference(IWorkingCopy workingCopy, IProject project, int offset, int length) {
        this.fPath = null;
        this.fProject = project;
        this.fWorkingCopy = workingCopy;
        this.fResource = null;
        this.fOffset = offset;
        this.fLength = length;
    }

    public TypeReference(IPath path, IProject project) {
        this(path, project, 0, 0);
    }

    public TypeReference(IResource resource, IProject project) {
        this(resource, project, 0, 0);
    }

    public TypeReference(IWorkingCopy workingCopy, IProject project) {
        this(workingCopy, project, 0, 0);
    }

    public IPath getPath() {
        if (this.fWorkingCopy != null) {
            return this.fWorkingCopy.getPath();
        }
        if (this.fResource != null) {
            return this.fResource.getFullPath();
        }
        return this.fPath;
    }

    public IPath getLocation() {
        if (this.fWorkingCopy != null) {
            IResource resource = this.fWorkingCopy.getUnderlyingResource();
            if (resource != null) {
                return resource.getLocation();
            }
            return null;
        }
        if (this.fResource != null) {
            return this.fResource.getLocation();
        }
        if (this.fPath != null) {
            return this.fPath;
        }
        if (this.fProject != null) {
            return this.fProject.getLocation();
        }
        return null;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public IWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public IProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fWorkingCopy != null) {
            ICProject cProject = this.fWorkingCopy.getCProject();
            if (cProject != null) {
                return cProject.getProject();
            }
            return null;
        }
        if (this.fResource != null) {
            return this.fResource.getProject();
        }
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        ITranslationUnit unit = null;
        if (this.fWorkingCopy != null) {
            unit = this.fWorkingCopy.getTranslationUnit();
        } else if (this.fResource != null) {
            ICElement elem = CoreModel.getDefault().create(this.fResource);
            if (elem instanceof ITranslationUnit) {
                unit = (ITranslationUnit)elem;
            }
        } else {
            IPath path = this.getLocation();
            ICElement elem = CoreModel.getDefault().create(path);
            if (elem instanceof ITranslationUnit) {
                unit = (ITranslationUnit)elem;
            } else {
                try {
                    unit = CoreModelUtil.findTranslationUnitForLocation(path, this.findCProject(this.getProject()));
                }
                catch (CModelException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                }
            }
        }
        return unit;
    }

    private ICProject findCProject(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            ICProject[] cProjects = CoreModel.getDefault().getCModel().getCProjects();
            if (cProjects != null) {
                int i = 0;
                while (i < cProjects.length) {
                    ICProject cProject = cProjects[i];
                    if (project.equals((Object)cProjects[i].getProject())) {
                        return cProject;
                    }
                    ++i;
                }
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public ICElement[] getCElements() {
        ITranslationUnit unit = this.getTranslationUnit();
        if (unit != null) {
            try {
                if (this.offsetIsLineNumber) {
                    ICElement[] result = new ICElement[]{unit.getElementAtLine(this.fOffset)};
                    return result;
                }
                return unit.getElementsAtOffset(this.fOffset);
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public IPath getRelativeIncludePath(IProject project) {
        IPath relativePath;
        IPath path = this.getLocation();
        if (path != null && (relativePath = PathUtil.makeRelativePathToProjectIncludes((IPath)path, (IProject)project)) != null) {
            return relativePath;
        }
        return path;
    }

    public IPath getRelativePath(IPath relativeToPath) {
        IPath relativePath;
        IPath path = this.getPath();
        if (path != null && (relativePath = PathUtil.makeRelativePath((IPath)path, (IPath)relativeToPath)) != null) {
            return relativePath;
        }
        return path;
    }

    public String toString() {
        IPath path = this.getLocation();
        if (path != null) {
            if (this.fLength == 0 && this.fOffset == 0) {
                return path.toString();
            }
            return String.valueOf(path.toString()) + ":" + this.fOffset + "-" + (this.fOffset + this.fLength);
        }
        return "";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ITypeReference)) {
            return false;
        }
        ITypeReference ref = (ITypeReference)obj;
        return this.toString().equals(ref.toString());
    }

    public boolean isLineNumber() {
        return this.offsetIsLineNumber;
    }
}

