/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class IndexCPPSignatureUtil {
    public static String getSignature(IBinding binding) throws CoreException, DOMException {
        ICPPBinding inst;
        StringBuilder buffer = new StringBuilder();
        if (binding instanceof ICPPTemplateInstance) {
            inst = (ICPPTemplateInstance)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(inst.getTemplateArguments(), true));
        } else if (binding instanceof ICPPUnknownClassInstance) {
            inst = (ICPPUnknownClassInstance)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(inst.getArguments(), true));
        } else if (binding instanceof ICPPClassTemplatePartialSpecialization) {
            ICPPClassTemplatePartialSpecialization partial = (ICPPClassTemplatePartialSpecialization)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(partial.getTemplateArguments(), false));
        }
        if (binding instanceof ICPPFunction) {
            ICPPFunction function = (ICPPFunction)binding;
            buffer.append(IndexCPPSignatureUtil.getFunctionParameterString(function.getType()));
        }
        if (binding instanceof ICPPMethod && !(binding instanceof ICPPConstructor)) {
            ICPPFunctionType ft = ((ICPPMethod)binding).getType();
            if (ft.isConst()) {
                buffer.append('c');
            }
            if (ft.isVolatile()) {
                buffer.append('v');
            }
        }
        return buffer.toString();
    }

    public static String getTemplateArgString(ICPPTemplateArgument[] args, boolean qualifyTemplateParameters) throws CoreException, DOMException {
        return ASTTypeUtil.getArgumentListString(args, true);
    }

    private static String getFunctionParameterString(IFunctionType functionType) throws DOMException {
        IType[] types = functionType.getParameterTypes();
        if (types.length == 1 && SemanticUtil.isVoidType(types[0])) {
            types = new IType[]{};
        }
        StringBuilder result = new StringBuilder();
        result.append('(');
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                result.append(',');
            }
            result.append(ASTTypeUtil.getType(types[i]));
            ++i;
        }
        if (functionType instanceof ICPPFunctionType && ((ICPPFunctionType)functionType).takesVarArgs()) {
            if (types.length != 0) {
                result.append(',');
            }
            result.append("...");
        }
        result.append(')');
        return result.toString();
    }

    public static Integer getSignatureHash(IBinding binding) throws CoreException, DOMException {
        String sig = IndexCPPSignatureUtil.getSignature(binding);
        return sig.length() == 0 ? null : new Integer(sig.hashCode());
    }

    public static int compareSignatures(IBinding a, IBinding b) {
        try {
            int siga = IndexCPPSignatureUtil.getSignature(a).hashCode();
            int sigb = IndexCPPSignatureUtil.getSignature(b).hashCode();
            return siga < sigb ? -1 : (siga > sigb ? 1 : 0);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
        }
        return 0;
    }
}

