/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.PotentialTranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaAnalyzer {
    private final List<ITranslationUnit> fForce = new ArrayList<ITranslationUnit>();
    private final List<ITranslationUnit> fChanged = new ArrayList<ITranslationUnit>();
    private final List<ITranslationUnit> fRemoved = new ArrayList<ITranslationUnit>();
    public static boolean sSuppressPotentialTUs = false;

    public void analyzeDelta(ICElementDelta delta) throws CoreException {
        this.processDelta(delta, new HashSet<IResource>());
    }

    private void processDelta(ICElementDelta delta, Set<IResource> handled) throws CoreException {
        int flags = delta.getFlags();
        if ((flags & 8) != 0) {
            ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
            int n = iCElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICElementDelta child = iCElementDeltaArray[n2];
                this.processDelta(child, handled);
                ++n2;
            }
        }
        ICElement element = delta.getElement();
        handled.add(element.getResource());
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                if (tu.isWorkingCopy()) break;
                switch (delta.getKind()) {
                    case 4: {
                        if ((flags & 1) == 0) break;
                        this.fChanged.add(tu);
                        break;
                    }
                    case 1: {
                        this.fChanged.add(tu);
                        break;
                    }
                    case 2: {
                        this.fRemoved.add(tu);
                    }
                }
                break;
            }
            case 12: {
                ICContainer folder = (ICContainer)element;
                if (delta.getKind() != 1) break;
                this.collectSources(folder, this.fChanged);
            }
        }
        IResourceDelta[] rDeltas = delta.getResourceDeltas();
        if (rDeltas != null && !sSuppressPotentialTUs) {
            IResourceDelta[] iResourceDeltaArray = rDeltas;
            int n = rDeltas.length;
            int n3 = 0;
            while (n3 < n) {
                IResource res;
                IResourceDelta rd = iResourceDeltaArray[n3];
                int rdkind = rd.getKind();
                if (rdkind != 1 && (res = rd.getResource()) instanceof IFile && handled.add(res)) {
                    switch (rdkind) {
                        case 4: {
                            if ((rd.getFlags() & 0x100) == 0) break;
                            this.fChanged.add((ITranslationUnit)new PotentialTranslationUnit(element, (IFile)res));
                            break;
                        }
                        case 2: {
                            this.fRemoved.add((ITranslationUnit)new PotentialTranslationUnit(element, (IFile)res));
                        }
                    }
                }
                ++n3;
            }
        }
    }

    private void collectSources(ICContainer container, Collection<ITranslationUnit> sources) throws CoreException {
        container.accept((ICElementVisitor)new TranslationUnitCollector(sources, sources, (IProgressMonitor)new NullProgressMonitor()));
    }

    public ITranslationUnit[] getForcedTUs() {
        return this.fForce.toArray(new ITranslationUnit[this.fForce.size()]);
    }

    public ITranslationUnit[] getChangedTUs() {
        return this.fChanged.toArray(new ITranslationUnit[this.fChanged.size()]);
    }

    public ITranslationUnit[] getRemovedTUs() {
        return this.fRemoved.toArray(new ITranslationUnit[this.fRemoved.size()]);
    }

    public List<ITranslationUnit> getForcedList() {
        return this.fForce;
    }

    public List<ITranslationUnit> getChangedList() {
        return this.fChanged;
    }
}

