/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;

public class RemoteSearchPatternQuery
extends RemoteSearchQuery {
    private static final long serialVersionUID = 1L;
    public static final int FIND_CLASS_STRUCT = 16;
    public static final int FIND_FUNCTION = 32;
    public static final int FIND_VARIABLE = 64;
    public static final int FIND_UNION = 256;
    public static final int FIND_METHOD = 512;
    public static final int FIND_FIELD = 1024;
    public static final int FIND_ENUM = 4096;
    public static final int FIND_ENUMERATOR = 8192;
    public static final int FIND_NAMESPACE = 16384;
    public static final int FIND_TYPEDEF = 65536;
    public static final int FIND_MACRO = 131072;
    public static final int FIND_ALL_TYPES = 227184;
    private String scopeDesc;
    private String patternStr;
    private Pattern[] pattern;

    public RemoteSearchPatternQuery(ICElement[] scope, String scopeDesc, String patternStr, boolean isCaseSensitive, int flags) throws PatternSyntaxException {
        super(scope, flags);
        this.scopeDesc = scopeDesc;
        this.patternStr = patternStr.trim();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        StringBuffer buff = new StringBuffer();
        int n = patternStr.length();
        int i = 0;
        while (i < n) {
            char c = patternStr.charAt(i);
            switch (c) {
                case '*': {
                    buff.append(".*");
                    break;
                }
                case '?': {
                    buff.append('.');
                    break;
                }
                case '.': 
                case ':': {
                    if (buff.length() <= 0) break;
                    if (isCaseSensitive) {
                        patternList.add(Pattern.compile(buff.toString()));
                    } else {
                        patternList.add(Pattern.compile(buff.toString(), 2));
                    }
                    buff = new StringBuffer();
                    break;
                }
                default: {
                    buff.append(c);
                }
            }
            ++i;
        }
        if (buff.length() > 0) {
            if (isCaseSensitive) {
                patternList.add(Pattern.compile(buff.toString()));
            } else {
                patternList.add(Pattern.compile(buff.toString(), 2));
            }
        }
        this.pattern = patternList.toArray(new Pattern[patternList.size()]);
    }

    public IStatus runWithIndex(IIndex index, IIndexLocationConverter converter, IProgressMonitor monitor) throws OperationCanceledException {
        this.fConverter = converter;
        try {
            IndexFilter filter = IndexFilter.ALL;
            IIndexBinding[] bindings = index.findBindings(this.pattern, false, filter, monitor);
            int i = 0;
            while (i < bindings.length) {
                IIndexBinding pdomBinding = bindings[i];
                boolean matches = false;
                if ((this.flags & 0x37770) == 227184) {
                    matches = true;
                } else if (pdomBinding instanceof ICompositeType) {
                    ICompositeType ct = (ICompositeType)pdomBinding;
                    switch (ct.getKey()) {
                        case 1: 
                        case 3: {
                            matches = (this.flags & 0x10) != 0;
                            break;
                        }
                        case 2: {
                            matches = (this.flags & 0x100) != 0;
                        }
                    }
                } else if (pdomBinding instanceof IEnumeration) {
                    matches = (this.flags & 0x1000) != 0;
                } else if (pdomBinding instanceof IEnumerator) {
                    matches = (this.flags & 0x2000) != 0;
                } else if (pdomBinding instanceof IField) {
                    matches = (this.flags & 0x400) != 0;
                } else if (pdomBinding instanceof ICPPMethod) {
                    matches = (this.flags & 0x200) != 0;
                } else if (pdomBinding instanceof IVariable) {
                    matches = (this.flags & 0x40) != 0;
                } else if (pdomBinding instanceof IFunction) {
                    matches = (this.flags & 0x20) != 0;
                } else if (pdomBinding instanceof ICPPNamespace || pdomBinding instanceof ICPPNamespaceAlias) {
                    matches = (this.flags & 0x4000) != 0;
                } else if (pdomBinding instanceof ITypedef) {
                    boolean bl = matches = (this.flags & 0x10000) != 0;
                }
                if (matches) {
                    this.createMatches(index, (IBinding)pdomBinding);
                }
                ++i;
            }
            if ((this.flags & 0x20000) != 0 && this.pattern.length == 1) {
                IIndexBinding[] iIndexBindingArray = bindings = index.findMacroContainers(this.pattern[0], filter, monitor);
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexBinding indexBinding = iIndexBindingArray[n2];
                    this.createMatches(index, (IBinding)indexBinding);
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (DOMException e) {
            return Util.createStatus((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public String getScopeDescription() {
        return this.scopeDesc;
    }

    public Object getPattern() {
        return this.patternStr;
    }
}

