/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.pdi.aif.ValueParent;

public class AIFValueAggregate
extends ValueParent
implements IAIFValueAggregate {
    private final Map<String, IAIFValue> values = new HashMap<String, IAIFValue>();

    public AIFValueAggregate(IValueParent parent, IAIFTypeAggregate type, AIFFactory.SimpleByteBuffer buffer) {
        super(parent, type);
        this.parse(buffer);
    }

    public IAIFValue getFieldValue(String name) {
        return this.values.get(name);
    }

    public String getValueString() throws AIFException {
        String content = "{";
        int length = this.values.size();
        int i = 0;
        while (i < length) {
            IAIFValue value = this.values.get(i);
            content = String.valueOf(content) + value.getValueString();
            if (i < length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return String.valueOf(content) + "}";
    }

    public int length() throws AIFException {
        return this.values.size();
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        IAIFTypeAggregate typeAggregate = (IAIFTypeAggregate)this.getType();
        String[] names = typeAggregate.getFieldNames(15);
        IAIFType[] types = typeAggregate.getFieldTypes(15);
        int i = 0;
        while (i < names.length) {
            IAIFValue val = AIFFactory.getAIFValue(this.getParent(), types[i], buffer);
            this.values.put(names[i], val);
            this.setSize(this.sizeof() + val.sizeof());
            ++i;
        }
    }
}

