/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.rdt.core.IConfigurableLanguage;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteLanguageMapper
implements ILanguageMapper {
    private static final String LOG_TAG = "CDTMiner-RemoteLanguageMapper";
    private static final String LANGUAGE_CLASS_FILE_NAME = "languages.properties";
    private static final ILanguage DEFAULT_LANGUAGE = GPPLanguage.getDefault();
    private static Properties languageIdToClassName = null;
    private final Map<String, ILanguage> languages = new HashMap<String, ILanguage>();
    private final IRemoteIndexerInfoProvider provider;
    private final DataStore dataStore;

    public RemoteLanguageMapper(IRemoteIndexerInfoProvider provider, DataStore dataStore) {
        if (provider == null || dataStore == null) {
            throw new NullPointerException();
        }
        this.provider = provider;
        this.dataStore = dataStore;
    }

    public ILanguage getLanguage(String file) {
        String languageId = this.provider.getLanguageID(file);
        if (languageId == null) {
            UniversalServerUtilities.logWarning((String)LOG_TAG, (String)("No language id for '" + file + "'"), (DataStore)this.dataStore);
            return DEFAULT_LANGUAGE;
        }
        ILanguage language = this.languages.get(languageId);
        if (language == null) {
            language = RemoteLanguageMapper.getLanguageById(languageId, this.provider.getLanguageProperties(languageId), this.dataStore);
            this.languages.put(languageId, language);
        }
        return language;
    }

    public static ILanguage getLanguageById(String languageId, Map<String, String> languageProperties, DataStore dataStore) {
        ILanguage language = RemoteLanguageMapper.instantiateAndConfigureLanguage(languageId, languageProperties, dataStore);
        return language == null ? DEFAULT_LANGUAGE : language;
    }

    private static ILanguage instantiateAndConfigureLanguage(String languageId, Map<String, String> languageProperties, DataStore dataStore) {
        String className = RemoteLanguageMapper.getClassName(languageId, dataStore);
        if (className == null) {
            if (dataStore != null) {
                UniversalServerUtilities.logWarning((String)LOG_TAG, (String)("No class for " + languageId), (DataStore)dataStore);
            }
            return null;
        }
        ILanguage language = null;
        try {
            Class<?> clazz = Class.forName(className);
            language = (ILanguage)clazz.newInstance();
            if (dataStore != null) {
                UniversalServerUtilities.logInfo((String)LOG_TAG, (String)("Instantiated language: " + className), (DataStore)dataStore);
            }
        }
        catch (Exception e) {
            if (dataStore != null) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)dataStore);
            }
            return null;
        }
        if (languageProperties != null && language instanceof IConfigurableLanguage) {
            ((IConfigurableLanguage)language).setProperties(languageProperties);
            if (dataStore != null) {
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Configured language: " + className), (DataStore)dataStore);
            }
        }
        return language;
    }

    private static synchronized String getClassName(String languageId, DataStore dataStore) {
        if (languageIdToClassName == null) {
            block8: {
                try {
                    languageIdToClassName = new Properties();
                    languageIdToClassName.setProperty("org.eclipse.cdt.core.g++", GPPLanguage.class.getCanonicalName());
                    languageIdToClassName.setProperty("org.eclipse.cdt.core.gcc", GCCLanguage.class.getCanonicalName());
                    String pluginDir = dataStore.getAttribute(0);
                    String dataFile = String.valueOf(pluginDir) + File.separator + LANGUAGE_CLASS_FILE_NAME;
                    File file = new File(dataFile);
                    if (file.canRead()) {
                        FileInputStream in = new FileInputStream(file);
                        languageIdToClassName.load(in);
                        ((InputStream)in).close();
                        UniversalServerUtilities.logInfo((String)LOG_TAG, (String)("Loaded language mappings from " + file.getAbsolutePath()), (DataStore)dataStore);
                    } else {
                        UniversalServerUtilities.logWarning((String)LOG_TAG, (String)("Cannot load language mappings file: " + file.getAbsolutePath()), (DataStore)dataStore);
                    }
                }
                catch (FileNotFoundException e) {
                    if (dataStore != null) {
                        UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)dataStore);
                    }
                }
                catch (IOException e) {
                    if (dataStore == null) break block8;
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)dataStore);
                }
            }
            if (dataStore != null) {
                UniversalServerUtilities.logInfo((String)LOG_TAG, (String)("Language ID mappings: " + languageIdToClassName), (DataStore)dataStore);
            }
        }
        return languageIdToClassName.getProperty(languageId);
    }
}

