/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtValueNode;
import org.eclipse.photran.internal.core.parser.ASTDatalistNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IDataStmtObject;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class DataToParameterRefactoring
extends FortranResourceRefactoring {
    boolean changesWereMade = false;

    public String getName() {
        return Messages.DataToParameterRefactoring_Name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError(Messages.bind((String)Messages.DataToParameterRefactoring_SelectedFileCannotBeParsed, (Object)file.getName()));
                    continue;
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        for (ScopingNode scope : ast.getRoot().getAllContainedScopes()) {
            new ScopeConverter().convert(scope, ast);
        }
        if (this.changesWereMade) {
            status.addWarning(Messages.DataToParameterRefactoring_RefactorNotConsideringVarAssignment);
            this.addChangeFromModifiedAST(file, pm);
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataListConverter {
        private ScopeConverter scopeConverter;
        private ASTDatalistNode dataList;
        private IASTListNode<IDataStmtObject> objectList;
        private IASTListNode<ASTDataStmtValueNode> valueList;
        private ASTDataStmtNode dataStmt;
        private List<IDataStmtObject> objectsToDelete;
        private List<ASTDataStmtValueNode> valuesToDelete;

        private DataListConverter() {
        }

        public int convert(ASTDatalistNode dataList, int numDataLists, List<String> assignedVars, ScopeConverter scopeConverter) {
            this.dataList = dataList;
            this.objectList = dataList.getDataStmtSet().getDataStmtObjectList();
            this.valueList = dataList.getDataStmtSet().getDataStmtValueList();
            this.dataStmt = (ASTDataStmtNode)dataList.getParent().getParent();
            this.scopeConverter = scopeConverter;
            this.objectsToDelete = new LinkedList<IDataStmtObject>();
            this.valuesToDelete = new LinkedList<ASTDataStmtValueNode>();
            int i = 0;
            while (i < dataList.getDataStmtSet().getDataStmtObjectList().size()) {
                this.transformToParameter(i, assignedVars);
                ++i;
            }
            return this.removeASTEntries(numDataLists);
        }

        private void transformToParameter(int index, List<String> assignedVars) {
            String parameterName = ((IDataStmtObject)this.objectList.get(index)).toString().trim();
            if (!assignedVars.contains(parameterName)) {
                DataToParameterRefactoring.this.changesWereMade = true;
                IASTNode parameterStmt = this.createParameterStmt(index, parameterName);
                this.scopeConverter.addDataStmtAndParameterStmt(this.dataStmt, parameterStmt);
                this.valuesToDelete.add((ASTDataStmtValueNode)this.valueList.get(index));
                this.objectsToDelete.add((IDataStmtObject)this.objectList.get(index));
            }
        }

        private IASTNode createParameterStmt(int index, String parameterName) {
            StringBuffer parameterStmt = new StringBuffer("parameter ( ");
            parameterStmt.append(String.valueOf(parameterName) + " = ");
            String value = ((ASTDataStmtValueNode)this.valueList.get(index)).getConstant().toString().trim();
            parameterStmt.append(value);
            parameterStmt.append(" )");
            parameterStmt.append(this.trailingComments());
            return DataToParameterRefactoring.parseLiteralStatement(parameterStmt.toString());
        }

        private String trailingComments() {
            String source = SourcePrinter.getSourceCodeFromASTNode(this.dataStmt);
            String[] sourceSplit = source.split("\n");
            String lastLine = sourceSplit[sourceSplit.length - 1];
            int index_comment = 0;
            while (index_comment < lastLine.length()) {
                if (lastLine.charAt(index_comment) == '!') {
                    return " " + lastLine.substring(index_comment);
                }
                ++index_comment;
            }
            return "";
        }

        private int removeASTEntries(int numDataLists) {
            if (this.objectList.size() == this.objectsToDelete.size()) {
                return this.removeEntireDataList(numDataLists);
            }
            return this.removeSpecifiedObjectsOnly(numDataLists);
        }

        private int removeEntireDataList(int numDataLists) {
            this.dataList.removeFromTree();
            if (--numDataLists == 0) {
                this.scopeConverter.prependCommentsToLastParameterStmt(this.leadingComments());
                this.scopeConverter.addNodeToDelete(this.dataStmt);
            }
            return numDataLists;
        }

        private String leadingComments() {
            String source = SourcePrinter.getSourceCodeFromASTNode(this.dataStmt);
            String[] sourceSplit = source.split("\n");
            String commentsBeforeLine = "";
            int i = 0;
            while (i < sourceSplit.length - 1) {
                commentsBeforeLine = String.valueOf(commentsBeforeLine) + sourceSplit[i] + "\n";
                ++i;
            }
            return commentsBeforeLine;
        }

        private int removeSpecifiedObjectsOnly(int numDataLists) {
            this.objectList.removeAll(this.objectsToDelete);
            for (IDataStmtObject n : this.objectList) {
                n.findFirstToken().setWhiteBefore(" ");
            }
            this.valueList.removeAll(this.valuesToDelete);
            return numDataLists;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScopeConverter {
        private IASTListNode<IASTNode> scopeBody;
        private IFortranAST ast;
        private List<IASTNode> dataAndParameterStmts = new LinkedList<IASTNode>();
        private List<IASTNode> nodesToDelete = new LinkedList<IASTNode>();

        private ScopeConverter() {
        }

        public void convert(ScopingNode scope, IFortranAST ast) throws VPGRefactoring.PreconditionFailure {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) {
                return;
            }
            this.ast = ast;
            this.scopeBody = scope.getBody();
            this.convert();
        }

        private void convert() throws VPGRefactoring.PreconditionFailure {
            List<String> assignedVars = this.determineAssignedVariables();
            for (IASTNode node : this.scopeBody) {
                if (!(node instanceof ASTDataStmtNode)) continue;
                this.convertDataStmt((ASTDataStmtNode)node, assignedVars);
            }
            this.insertAndDeleteStmts();
            this.removeLeadingComma();
        }

        private List<String> determineAssignedVariables() {
            LinkedList<String> assignedVars = new LinkedList<String>();
            for (IASTNode node : this.scopeBody) {
                if (!(node instanceof ASTAssignmentStmtNode)) continue;
                assignedVars.add(((ASTAssignmentStmtNode)node).getLhsVariable().getName().getText());
            }
            return assignedVars;
        }

        private void convertDataStmt(ASTDataStmtNode node, List<String> assignedVars) throws VPGRefactoring.PreconditionFailure {
            if (node.getDatalist() == null) {
                throw new VPGRefactoring.PreconditionFailure(Messages.DataToParameterRefactoring_EmptyDataListInNode);
            }
            int size = node.getDatalist().size();
            for (ASTDatalistNode dataList : node.getDatalist()) {
                size = new DataListConverter().convert(dataList, size, assignedVars, this);
            }
        }

        private void insertAndDeleteStmts() {
            int i = 0;
            while (i < this.dataAndParameterStmts.size()) {
                this.scopeBody.insertAfter(this.dataAndParameterStmts.get(i), this.dataAndParameterStmts.get(i + 1));
                Reindenter.reindent(this.dataAndParameterStmts.get(i + 1), this.ast);
                i += 2;
            }
            i = 0;
            while (i < this.nodesToDelete.size()) {
                ASTDataStmtNode delete = (ASTDataStmtNode)this.nodesToDelete.get(i);
                if (this.scopeBody.contains(delete)) {
                    delete.removeFromTree();
                }
                ++i;
            }
        }

        private void removeLeadingComma() {
            for (IASTNode node : this.scopeBody) {
                if (!(node instanceof ASTDataStmtNode)) continue;
                IASTNode comma = node;
                String source_comma = SourcePrinter.getSourceCodeFromASTNode(comma);
                String[] source_comma_split = source_comma.split("\n");
                String statement = source_comma_split[source_comma_split.length - 1].trim();
                String data = statement.substring(0, 4);
                String list_data = statement.substring(4);
                if (!(list_data = list_data.trim()).startsWith(",")) continue;
                list_data = list_data.substring(1);
                list_data = list_data.trim();
                String new_source = new String("");
                int i = 0;
                while (i < source_comma_split.length - 1) {
                    new_source = String.valueOf(new_source) + source_comma_split[i] + "\n";
                    ++i;
                }
                new_source = String.valueOf(new_source) + data + " " + list_data;
                IBodyConstruct without_comma = DataToParameterRefactoring.parseLiteralStatement(new_source);
                comma.replaceWith(without_comma);
                Reindenter.reindent(without_comma, this.ast);
            }
        }

        public void prependCommentsToLastParameterStmt(String comments) {
            IASTNode lastParameterStmt = this.dataAndParameterStmts.get(this.lastParameterStmtIndex());
            IBodyConstruct parameterStmtWithComments = DataToParameterRefactoring.parseLiteralStatement(String.valueOf(comments) + SourcePrinter.getSourceCodeFromASTNode(lastParameterStmt));
            this.replaceLastParameterStmtWith(parameterStmtWithComments);
        }

        private int lastParameterStmtIndex() {
            return this.dataAndParameterStmts.size() - 1;
        }

        private void replaceLastParameterStmtWith(IASTNode newParameterStmt) {
            this.dataAndParameterStmts.remove(this.lastParameterStmtIndex());
            this.dataAndParameterStmts.add(newParameterStmt);
        }

        public void addDataStmtAndParameterStmt(IASTNode dataStmt, IASTNode parameter) {
            this.dataAndParameterStmts.add(dataStmt);
            this.dataAndParameterStmts.add(parameter);
        }

        public void addNodeToDelete(ASTDataStmtNode dataStmt) {
            this.nodesToDelete.add(dataStmt);
        }
    }
}

