/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTImplicitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;

class ImplicitSpecCollector
extends BindingCollector {
    ImplicitSpecCollector() {
    }

    public void visitASTImplicitStmtNode(ASTImplicitStmtNode node) {
        ImplicitSpec implicitSpec = null;
        if (node.getImplicitSpecList() != null) {
            implicitSpec = new ImplicitSpec(node.getImplicitSpecList());
        }
        try {
            this.vpg.setScopeImplicitSpec(node.getImplicitToken().getEnclosingScope(), implicitSpec);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        super.traverseChildren(node);
    }

    public void visitASTExecutableProgramNode(ASTExecutableProgramNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTMainProgramNode(ASTMainProgramNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTFunctionSubprogramNode(ASTFunctionSubprogramNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTModuleNode(ASTModuleNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTBlockDataSubprogramNode(ASTBlockDataSubprogramNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTDerivedTypeDefNode(ASTDerivedTypeDefNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    public void visitASTInterfaceBlockNode(ASTInterfaceBlockNode node) {
        this.setDefaultImplicitSpec(node);
        super.traverseChildren(node);
    }

    private void setDefaultImplicitSpec(ScopingNode node) {
        if (!ScopingNode.isScopingNode(node)) {
            return;
        }
        ImplicitSpec implicitSpec = node == node.getGlobalScope() ? new ImplicitSpec() : node.getEnclosingScope().getImplicitSpec();
        try {
            this.vpg.setScopeImplicitSpec(node, implicitSpec);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

