/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.analysis.types.TypeProcessor;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionType
extends Type {
    private static final long serialVersionUID = 1L;
    private String name;
    private Type returnType = Type.UNKNOWN;
    private List<Type> argumentTypes = new LinkedList<Type>();

    public FunctionType(String name) {
        this.name = name.toLowerCase();
    }

    @Override
    public String toString() {
        return "function(" + this.name + "): " + this.argumentTypes + " -> " + this.returnType;
    }

    @Override
    public <T> T processUsing(TypeProcessor<T> p) {
        return p.ifFunctionType(this.name, this);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof FunctionType && ((FunctionType)other).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static String getStaticThreeLetterTypeSerializationCode() {
        return "fun";
    }

    @Override
    public String getThreeLetterTypeSerializationCode() {
        return "fun";
    }

    @Override
    void finishWriteTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.name, out);
        PhotranVPGSerializer.serialize(this.returnType, out);
        PhotranVPGSerializer.serialize(this.argumentTypes.size(), out);
        for (Type argType : this.argumentTypes) {
            PhotranVPGSerializer.serialize(argType, out);
        }
    }

    public static Type finishReadFrom(InputStream in) throws IOException {
        String name = (String)PhotranVPGSerializer.deserialize(in);
        FunctionType result = new FunctionType(name);
        result.returnType = (Type)PhotranVPGSerializer.deserialize(in);
        int args = (Integer)PhotranVPGSerializer.deserialize(in);
        int i = 0;
        while (i < args) {
            result.argumentTypes.add((Type)PhotranVPGSerializer.deserialize(in));
            ++i;
        }
        return result;
    }
}

